/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.cli.common.handlers;

import com.ibm.appscan.cli.common.CLIConstants;
import com.ibm.appscan.cli.common.CommonCLICore;
import com.ibm.appscan.cli.common.Messages;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.http.HttpClient;
import com.ibm.appscan.common.http.HttpResponse;
import com.ibm.appscan.common.utils.ArchiveUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.common.utils.VersionUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class UpdateHandler
implements CLIConstants {
    private static final String SACLIENT = "SAClientUtil";
    private File m_userTemp;

    public UpdateHandler() {
        File appscanDir = new File(System.getProperty("user.home"), ".appscan");
        this.m_userTemp = new File(appscanDir, "temp");
    }

    public void runUpdate() {
        if (!this.isUpdateAvailable()) {
            System.exit(1);
        }
        try {
            File appscanHome = new File(CommonCore.getDirectoryLocator().getProductRoot());
            this.verifyClientDir(appscanHome);
            this.cleanUpTemp();
            this.downloadLatestClient();
            this.cleanUp();
        }
        catch (AppScanException e) {
            CommonCLICore.getIOConsole().print(Messages.getMessage("command.update.failed", e.getLocalizedMessage()));
            System.exit(1);
        }
    }

    public boolean isUpdateAvailable() {
        boolean updateAvailable = false;
        String serverToolsVersion = VersionUtil.getServerToolsVersion();
        if (serverToolsVersion == null) {
            CommonCLICore.getIOConsole().print(Messages.getMessage("command.update.check.failed", serverToolsVersion));
        } else if (!VersionUtil.usingLatest()) {
            CommonCLICore.getIOConsole().print(Messages.getMessage("command.update.available", serverToolsVersion));
            updateAvailable = true;
        } else {
            CommonCLICore.getIOConsole().print(Messages.getMessage("command.update.not.needed", new Object[0]));
        }
        return updateAvailable;
    }

    private void getSAClientUtil(File destination) throws IOException {
        HttpClient client = new HttpClient();
        String request_url = VersionUtil.getUtilityDownloadURL();
        HttpResponse response = client.get(request_url, null, null);
        if (response.getResponseCode() == 200 || response.getResponseCode() == 201) {
            if (!destination.getParentFile().isDirectory()) {
                destination.getParentFile().mkdirs();
            }
        } else {
            throw new IOException(response.getResponseBodyAsString());
        }
        response.getResponseBodyAsFile(destination);
    }

    private String getScriptName() {
        return SystemUtil.isWindows() ? "appscan.bat" : "appscan.sh";
    }

    private void verifyClientDir(File appscanHome) throws AppScanException {
        if (!new File(appscanHome, "version.info").isFile() || !new File(appscanHome, "bin" + File.separator + this.getScriptName()).isFile()) {
            throw new AppScanException("Invalid install directory");
        }
    }

    private void downloadLatestClient() throws AppScanException {
        File clientZip;
        CommonCLICore.getIOConsole().print(Messages.getMessage("command.update.downloading", new Object[0]));
        if (!this.m_userTemp.isDirectory()) {
            this.m_userTemp.mkdirs();
        }
        if ((clientZip = new File(this.m_userTemp, "SAClientUtil.zip")).isFile()) {
            clientZip.delete();
        }
        try {
            this.getSAClientUtil(clientZip);
            if (!clientZip.isFile()) {
                throw new AppScanException(Messages.getMessage("command.update.download.error", ""));
            }
            CommonCLICore.getIOConsole().print(Messages.getMessage("command.update.extracting", new Object[0]));
            ArchiveUtil.unzip((File)clientZip, (File)clientZip.getParentFile(), (boolean)true, (String[])new String[0]);
        }
        catch (IOException | OutOfMemoryError e) {
            throw new AppScanException(Messages.getMessage("command.update.download.error", e.getLocalizedMessage()));
        }
    }

    private void cleanUpTemp() {
        File[] files;
        for (File file : files = this.m_userTemp.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.getName().startsWith(UpdateHandler.SACLIENT) || name.startsWith(UpdateHandler.SACLIENT);
            }
        })) {
            file.delete();
        }
    }

    private void cleanUp() throws AppScanException {
        File[] files;
        File SAClientDir = new File(this.m_userTemp, SACLIENT);
        for (File file : files = this.m_userTemp.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.getName().startsWith(UpdateHandler.SACLIENT) || name.startsWith(UpdateHandler.SACLIENT);
            }
        })) {
            if (!file.isDirectory()) continue;
            file.renameTo(SAClientDir);
            break;
        }
        if (!SAClientDir.isDirectory()) {
            throw new AppScanException(Messages.getMessage("command.update.download.failed", new Object[0]));
        }
    }
}

