/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.ifa;

import com.hcl.appscan.common.mlservices.MLServiceFactory;
import com.hcl.appscan.ifa.BaseTraceIfaLayer;
import com.hcl.appscan.ifa.ExcludeBadSinkIfaLayer;
import com.hcl.appscan.ifa.ExcludeInfoIfaLayer;
import com.hcl.appscan.ifa.ExcludeLangSpecificBadTraceIfaLayer;
import com.hcl.appscan.ifa.ExcludeLostSinkIfaLayer;
import com.hcl.appscan.ifa.ExcludeNoTraceFilterIfaLayer;
import com.hcl.appscan.ifa.ExcludeTraceFilterIfaLayer;
import com.hcl.appscan.ifa.IncludeCustomHighIfaLayer;
import com.hcl.appscan.ifa.JavaScriptIfaLayer;
import com.hcl.appscan.ifa.LocalTraceIfaLayer;
import com.hcl.appscan.ifa.RemoteTraceIfaLayer;
import com.hcl.appscan.ifa.SparkTraceIfaLayer;
import com.hcl.appscan.ifa.Util;
import com.hcl.appscan.ifa.common.IIfaLayer;
import com.hcl.appscan.ifa.common.IIfaLog;
import com.hcl.appscan.ifa.common.IfaAssessment;
import com.hcl.appscan.ifa.common.IfaLog;
import com.hcl.appscan.ifa.common.IfaQueue;
import com.hcl.appscan.ifa.common.util.ExcludeAllIfaLayer;
import com.hcl.appscan.ifa.common.util.FindingCompressorIfaLayer;
import com.hcl.appscan.ifa.common.util.IncludeAllIfaLayer;
import com.hcl.appscan.ifa.common.util.LogExceptionIfMatchedIfaLayer;
import com.hcl.appscan.ifa.nlp.model.Trace.RemoteTraceModel;
import com.hcl.appscan.ifa.notes.Notes;
import com.ibm.appscan.assessment.Constants;
import com.ibm.appscan.assessment.model.Assessment;
import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.assessment.model.finding.HybridFinding;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.ifa.finding.FindingTrainer;
import java.util.Collection;
import java.util.HashSet;

public class Ifa
implements AutoCloseable {
    public static final String JAVASCRIPT_FLAG = "IFA_JAVASCRIPT";
    public static final String TRACE_FLAG = "IFA_NLP";
    public static final String SPARK_FLAG = "IFA_SPARK";
    private static final String TRACE_LANGUAGES = "Java, DotNET";
    private IfaQueue m_queue;
    private ILogManager m_logger;
    private BaseTraceIfaLayer m_traceIfaLayer;

    public Ifa() {
        this(CommonCore.getLogManager());
    }

    public Ifa(ILogManager logger) {
        this(logger, true);
    }

    public Ifa(ILogManager logger, boolean enabled) {
        this.m_logger = logger;
        this.m_queue = new IfaQueue();
        if (!enabled) {
            this.m_logger.log(new Message(1, Notes.getMessage("ifa.disabled", new Object[0])));
            this.m_queue.register((IIfaLayer)new LogExceptionIfMatchedIfaLayer(new Exception("Ifa is not enabled")), f -> true);
            this.m_queue.register((IIfaLayer)new IncludeAllIfaLayer("Include All Remaining"), f -> true);
            return;
        }
        this.m_queue.register((IIfaLayer)new ExcludeAllIfaLayer("Exclude Excluded"), f -> f.isExcluded());
        this.m_queue.register((IIfaLayer)new IncludeAllIfaLayer("Include Hybrid Engine Results"), f -> f instanceof HybridFinding);
        if (SystemUtil.defaultTrueProperty((String)JAVASCRIPT_FLAG)) {
            this.m_logger.log(new Message(1, Notes.getMessage("ifa.nlp.enabled", "JavaScript")));
            this.m_queue.register((IIfaLayer)new JavaScriptIfaLayer(), JavaScriptIfaLayer::predicate);
        } else {
            this.m_logger.log(new Message(1, Notes.getMessage("ifa.nlp.disabled", "JavaScript")));
        }
        if (CommonCore.getConfiguration().getSettingValueBooleanDefaultFalse("include_custom_high_severity")) {
            this.m_queue.register((IIfaLayer)new IncludeCustomHighIfaLayer(), f -> true);
        }
        this.m_queue.register((IIfaLayer)new ExcludeNoTraceFilterIfaLayer(), f -> f.getTrace() == null);
        this.m_queue.register((IIfaLayer)new ExcludeLostSinkIfaLayer(), f -> f.getTrace() != null);
        this.m_queue.register((IIfaLayer)new ExcludeAllIfaLayer("Exclude Severity Not Vulnerable"), f -> f.getData().getSeverity().equals(Constants.SEVERITY90.NotVulnerable.toString()));
        this.m_queue.register((IIfaLayer)new ExcludeInfoIfaLayer(), f -> true);
        this.m_queue.register((IIfaLayer)new ExcludeAllIfaLayer("Exclude Confidence Unknown"), f -> f.getData().getConfidence().equals("Unknown"));
        this.m_queue.register((IIfaLayer)new ExcludeLangSpecificBadTraceIfaLayer(), f -> f.getTrace() != null);
        this.m_queue.register((IIfaLayer)new ExcludeTraceFilterIfaLayer(), f -> f.getTrace() != null);
        this.m_queue.register((IIfaLayer)new ExcludeBadSinkIfaLayer(), f -> f.getTrace() != null);
        if (!SystemUtil.defaultTrueProperty((String)TRACE_FLAG)) {
            this.m_logger.log(new Message(1, Notes.getMessage("ifa.nlp.disabled", TRACE_LANGUAGES)));
        } else if (SystemUtil.isCommonEngine()) {
            this.m_logger.log(new Message(1, Notes.getMessage("ifa.nlp.commonEngine", new Object[0])));
        } else {
            this.m_logger.log(new Message(1, Notes.getMessage("ifa.nlp.enabled", TRACE_LANGUAGES)));
            MLServiceFactory.getMLServicesNamespace().ifPresent(nameSpace -> {
                try {
                    this.m_traceIfaLayer = ((String)MLServiceFactory.getMLServicesNamespace().get()).toLowerCase().equals("hcl-appscan-sast") ? new RemoteTraceIfaLayer((String)nameSpace) : new RemoteTraceIfaLayer((String)nameSpace, "/" + RemoteTraceModel.getServiceName());
                    this.m_logger.log(new Message(1, Notes.getMessage("ifa.nlp.remote.connected", TRACE_LANGUAGES)));
                }
                catch (Exception e) {
                    this.m_logger.log(new Message(1, Notes.getMessage("ifa.nlp.remote.unreachable", TRACE_LANGUAGES)));
                    this.m_logger.log(e);
                }
            });
            if (this.m_traceIfaLayer == null) {
                try {
                    this.m_traceIfaLayer = new LocalTraceIfaLayer();
                    this.m_logger.log(new Message(1, Notes.getMessage("ifa.nlp.local.started", TRACE_LANGUAGES)));
                }
                catch (Exception e) {
                    this.m_logger.log(e);
                }
            }
            if (this.m_traceIfaLayer != null) {
                FindingCompressorIfaLayer compressed_layer = new FindingCompressorIfaLayer(this.m_traceIfaLayer::getSentence, (IIfaLayer)this.m_traceIfaLayer);
                this.m_queue.register((IIfaLayer)compressed_layer, BaseTraceIfaLayer::predicate);
            } else {
                this.m_queue.register((IIfaLayer)new LogExceptionIfMatchedIfaLayer(new Exception("No version of " + BaseTraceIfaLayer.class.getSimpleName() + " could be loaded")), BaseTraceIfaLayer::predicate);
            }
        }
        if (SystemUtil.defaultTrueProperty((String)SPARK_FLAG)) {
            this.m_queue.register((IIfaLayer)new SparkTraceIfaLayer(), f -> f.getTrace() != null);
        } else {
            this.m_logger.log(new Message(1, Notes.getMessage("ifa.spark.disabled", "Spark")));
        }
        this.m_queue.register((IIfaLayer)new IncludeAllIfaLayer("Include All Remaining"), f -> true);
    }

    public Assessment apply(Assessment a) throws AppScanException {
        IfaLog log = new IfaLog();
        IfaAssessment ifaAssessment = new IfaAssessment(a, (IIfaLog)log);
        this.m_queue.applyIfa(ifaAssessment);
        this.m_logger.log(new Message(1, Notes.getMessage("ifa.nlp.target", a.getDetailsNode().getApplication())));
        this.m_logger.log(new Message(1, log.toString()));
        log.getLayerMessages().forEach(m -> this.m_logger.log(m));
        Collection errors = log.getExceptions();
        if (errors.size() != 0) {
            errors.forEach(e -> this.m_logger.log(e));
            throw new AppScanException("Ifa completed with errors", -2147483548);
        }
        Assessment ifa_d_asmt = ifaAssessment.unwrap();
        this.m_logger.log(this.getDetails(ifa_d_asmt));
        return ifa_d_asmt;
    }

    @Override
    public void close() throws Exception {
        this.m_queue.close();
    }

    private Message getDetails(Assessment a) {
        int ifa_trace_possible_count = 0;
        int one_trace_count = 0;
        int two_trace_count = 0;
        int three_trace_count = 0;
        int ifa_exclude_ml_count = 0;
        int no_trace_excluded_ml_count = 0;
        int good_no_trace_count = 0;
        int original_count = a.getFindingList().size();
        int lost_sink_count = 0;
        int virtual_lost_sink_count = 0;
        HashSet<Language.LANGUAGE> unsupported_languages_set = new HashSet<Language.LANGUAGE>();
        unsupported_languages_set.add(Language.LANGUAGE.CUSTOM);
        unsupported_languages_set.add(Language.LANGUAGE.UNKNOWN);
        for (Finding f : a.getFindingList()) {
            if (!unsupported_languages_set.contains(f.getLanguage())) {
                if (f.isLostSink()) {
                    ++lost_sink_count;
                }
                if (f.isVirtualLostSink()) {
                    ++virtual_lost_sink_count;
                }
            }
            if (f.getTrace() != null) {
                ++ifa_trace_possible_count;
            } else {
                ++good_no_trace_count;
            }
            if (f.getData().getSeverity().equals(Constants.SEVERITY90.High.toString())) {
                ++one_trace_count;
            }
            if (f.getData().getSeverity().equals(Constants.SEVERITY90.Medium.toString())) {
                ++two_trace_count;
            }
            if (!f.getData().getSeverity().equals(Constants.SEVERITY90.Low.toString())) continue;
            ++three_trace_count;
        }
        for (Finding f : a.getExcludedFindings()) {
            if (f.getTrace() != null) {
                ++ifa_trace_possible_count;
                ++ifa_exclude_ml_count;
                continue;
            }
            ++no_trace_excluded_ml_count;
        }
        StringBuffer str = new StringBuffer();
        str.append(this.getClass().getSimpleName() + " Details:");
        str.append(System.getProperty("line.separator"));
        str.append(Notes.getMessage("separator", new Object[0]));
        str.append(System.getProperty("line.separator"));
        str.append(Notes.getMessage("num.attributes", ((FindingTrainer)Util.s_FindingTrainer.get()).getFeatures().size()));
        str.append(System.getProperty("line.separator"));
        str.append(Notes.getMessage("total.ifa.findings", a.getFindingList().size()));
        str.append(System.getProperty("line.separator"));
        str.append(Notes.getMessage("ifa.no.trace.findings", good_no_trace_count));
        str.append(System.getProperty("line.separator"));
        str.append(Notes.getMessage("ifa.trace.findings", one_trace_count + two_trace_count + three_trace_count));
        str.append(System.getProperty("line.separator"));
        str.append(Notes.getMessage("total.findings", original_count));
        str.append(System.getProperty("line.separator"));
        str.append(Notes.getMessage("no.trace.findings", good_no_trace_count + no_trace_excluded_ml_count));
        str.append(System.getProperty("line.separator"));
        str.append(Notes.getMessage("total.ifa.trace.possible.findings", ifa_trace_possible_count));
        str.append(System.getProperty("line.separator"));
        str.append(Notes.getMessage("ml.exclude.findings", ifa_exclude_ml_count + no_trace_excluded_ml_count));
        str.append(System.getProperty("line.separator"));
        str.append(Notes.getMessage("lost.sinks", lost_sink_count));
        str.append(System.getProperty("line.separator"));
        str.append(Notes.getMessage("virtual.lost.sinks", virtual_lost_sink_count));
        str.append(System.getProperty("line.separator"));
        str.append(Notes.getMessage("one.findings", one_trace_count));
        str.append(System.getProperty("line.separator"));
        str.append(Notes.getMessage("two.findings", two_trace_count));
        str.append(System.getProperty("line.separator"));
        str.append(Notes.getMessage("three.findings", three_trace_count));
        str.append(System.getProperty("line.separator"));
        str.append(Notes.getMessage("separator", new Object[0]));
        str.append(System.getProperty("line.separator"));
        return new Message(1, str.toString());
    }
}

