/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.aspdotnet;

import com.ibm.appscan.frameworks.aspdotnet.CompiledFileInfo;
import com.ibm.appscan.frameworks.aspdotnet.util.DotNetVDBUtil;
import com.ibm.appscan.frameworks.aspdotnet.util.DotNetWalaUtil;
import com.ibm.appscan.frameworks.specinfo.FrameworkInfoImpl;
import com.ibm.appscan.frameworks.specinfo.IFrameworkInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.dotnet.loader.CLRMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.xml.sax.SAXException;

public class AspDotNetEntrypoints {
    private static final boolean DEBUG = false;
    private final String precompileOutputDir;
    private final String slnVirtualPath;
    private final IClassHierarchy cha;

    public static AspDotNetEntrypoints make(String webContentDir, String virtualPath, IClassHierarchy cha) {
        return new AspDotNetEntrypoints(webContentDir, virtualPath, cha);
    }

    private AspDotNetEntrypoints(String precompileOutputDir, String virtualPath, IClassHierarchy cha) {
        if (precompileOutputDir == null) {
            throw new IllegalArgumentException("precompiledOutputDir is null");
        }
        if (cha == null) {
            throw new IllegalArgumentException("cha is null");
        }
        this.precompileOutputDir = precompileOutputDir;
        this.slnVirtualPath = virtualPath;
        this.cha = cha;
    }

    public IFrameworkInfo generateEntrypointInfo() throws FileNotFoundException, IOException, SAXException {
        Map<String, Set<String>> entrypointSignatureToURL = this.generateEntrypointSig2URLMapping();
        Set syntheticMethods = Collections.emptySet();
        Set globalBeanDeclarations = Collections.emptySet();
        Map methodToReplacements = Collections.emptyMap();
        return new FrameworkInfoImpl(syntheticMethods, globalBeanDeclarations, entrypointSignatureToURL, methodToReplacements);
    }

    public Map<String, Set<String>> generateEntrypointSig2URLMapping() throws FileNotFoundException, IOException, SAXException {
        HashMap result = HashMapFactory.make();
        Set<String> compiledFilePaths = this.findCompiledFiles();
        for (String compiledFile : compiledFilePaths) {
            this.handleCompiledFile(compiledFile, result);
        }
        return result;
    }

    private void handleCompiledFile(String compiledFile, Map<String, Set<String>> result) throws FileNotFoundException, IOException, SAXException {
        String type;
        CompiledFileInfo info = new CompiledFileInfo(compiledFile);
        String url = info.getVirtualPath();
        if (url == null) {
            TaintLogger.i().getLogger().info((Object)("virtual path null in compiled file " + compiledFile));
            return;
        }
        if (this.slnVirtualPath != null && url.startsWith(this.slnVirtualPath)) {
            url = url.substring(this.slnVirtualPath.length());
        }
        if ((type = info.getType()) == null) {
            TaintLogger.i().getLogger().info((Object)("type attribute null in compiled file " + compiledFile));
            return;
        }
        String assembly = info.getAssembly();
        if (assembly == null) {
            TaintLogger.i().getLogger().info((Object)("assembly attribute null in compiled file " + compiledFile));
            return;
        }
        IClass klass = DotNetWalaUtil.getIClass(type, assembly, this.cha);
        if (klass == null) {
            TaintLogger.i().getLogger().info((Object)("could not find type " + type + " from assembly " + assembly));
            return;
        }
        Collection<IMethod> entrypointMethods = this.collectPageEntrypointMethods(klass);
        for (IMethod e : entrypointMethods) {
            String vdbSig = DotNetVDBUtil.walaDotNet2FullyQualifiedVDBSignature(e.getSignature());
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.method.url", (Object[])new Object[]{vdbSig, url}));
            MapUtil.findOrCreateSet(result, (Object)vdbSig).add(url);
        }
    }

    private Collection<IMethod> collectPageEntrypointMethods(IClass klass) {
        HashSet result = HashSetFactory.make();
        for (IClass tmp = klass; tmp != null && klass.getClassHierarchy().getScope().isApplicationLoader(tmp.getClassLoader()); tmp = tmp.getSuperclass()) {
            try {
                for (IMethod m : tmp.getDeclaredMethods()) {
                    if (!this.isEntrypointMethod(m)) continue;
                    result.add(m);
                }
                continue;
            }
            catch (Exception e) {
                System.err.println(Messages.getString((String)"framework.dotnet.unresolved"));
            }
        }
        return result;
    }

    private boolean isEntrypointMethod(IMethod m) {
        if (m.isStatic()) {
            return false;
        }
        System.out.println("isEntrypointMethod, method name = " + m.getName().toString());
        if (m.getName().toString().contains(".ctor")) {
            return false;
        }
        CLRMethod.Accessibility accessibility = ((CLRMethod)m).getAccessibility();
        return accessibility.equals((Object)CLRMethod.Accessibility.PUBLIC) || accessibility.equals((Object)CLRMethod.Accessibility.FAMILY) || accessibility.equals((Object)CLRMethod.Accessibility.FAM_OR_ASSEM);
    }

    private Set<String> findCompiledFiles() {
        File[] compiledFiles;
        File binDir = new File(this.precompileOutputDir + "/bin");
        if (!binDir.exists() || !binDir.isDirectory()) {
            return Collections.emptySet();
        }
        HashSet result = HashSetFactory.make();
        for (File f : compiledFiles = binDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getAbsolutePath().endsWith(".compiled");
            }
        })) {
            result.add(f.getAbsolutePath());
        }
        return result;
    }
}

