/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.aspdotnet.util;

import com.ibm.appscan.frameworks.FileLocations;
import com.ibm.appscan.frameworks.FrameworksInput;
import com.ibm.appscan.frameworks.aspdotnet.util.XmlReader;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.Iterator2Iterable;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Iterator;

public class Utils {
    public static boolean IsDotNetFramework(FrameworksInput fwInput) {
        String inputType = fwInput.getType();
        return inputType.equalsIgnoreCase("DotNet");
    }

    public static String removeGenericsFromTypeName(String typeName) {
        int pos = typeName.indexOf("&lt;");
        if (pos != -1) {
            String typeNameWithoutGenerics = typeName.substring(0, pos);
            return typeNameWithoutGenerics;
        }
        return typeName;
    }

    public static String GetCsprojPath(FrameworksInput fwInput) {
        FileLocations fileLocations = fwInput.getFileLocs();
        String csProjPath = fileLocations.getProjectFile();
        return csProjPath;
    }

    public static String SearchForMvcDllReference(String csprojPath) {
        XmlReader xmlReader = new XmlReader(csprojPath);
        String reference = xmlReader.GetNodeWithSpecificAttributePrefix("Reference", "Include", "System.Web.Mvc");
        return reference;
    }

    public static boolean IsMvcVersionLegal(String mvcReference) {
        return !mvcReference.isEmpty();
    }

    public static String getVDBSignature(TypeReference type) {
        String VdbClazzSignature = type.getName().toString();
        if ((VdbClazzSignature = VdbClazzSignature.replace("/", ".")).startsWith("L")) {
            VdbClazzSignature = VdbClazzSignature.substring(1, VdbClazzSignature.length());
        }
        return VdbClazzSignature;
    }

    public static FilePositionInfo getMethodPosition(IMethod method) {
        return Utils.getMethodPosition(method, -1);
    }

    public static FilePositionInfo getMethodPosition(IMethod method, int srcLine) {
        FilePositionInfo posInfo = null;
        AnalysisCache cache = new AnalysisCache();
        IR ir = null;
        try {
            ir = cache.getIR(method);
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().info((Object)("Inside Utils#getMethodPosition(), Problem enountered when getting IR for method: " + method.toString() + ".  Skipping..."));
        }
        if (ir != null) {
            Iterator callSites = ir.iterateCallSites();
            for (CallSiteReference site : Iterator2Iterable.make((Iterator)callSites)) {
                int bcIndex = site.getProgramCounter();
                IClassLoader mcl = method.getDeclaringClass().getClassLoader();
                String fileName = null;
                try {
                    fileName = mcl.getSourceFileName(method.getDeclaringClass());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (fileName == null) {
                    fileName = mcl.getSourceFileName(method, bcIndex);
                }
                int line = 0;
                try {
                    line = method.getLineNumber(bcIndex);
                }
                catch (Exception e) {
                    TaintLogger.i().getLogger().debug((Object)Messages.getString((String)"framework.handlers.utils.method.lineno", (Object[])new Object[]{method.toString()}));
                }
                if (fileName == null) continue;
                posInfo = FilePositionInfo.make((String)fileName, (int)(srcLine != -1 ? srcLine : line), (int)0);
                break;
            }
        }
        return posInfo;
    }

    public static String getVDBSignature(IClass clazz) {
        String VdbClazzSignature = clazz.getName().toString();
        if ((VdbClazzSignature = VdbClazzSignature.replace("/", ".")).startsWith("L")) {
            VdbClazzSignature = VdbClazzSignature.substring(1, VdbClazzSignature.length());
        }
        return VdbClazzSignature;
    }

    public static Boolean IsSystemWebMvcInScope(FrameworksInput fwInput) {
        FileLocations fileLocations = fwInput.getFileLocs();
        String scopeFileName = fileLocations.getScopeFileName();
        try {
            String strLine;
            FileInputStream fstream = new FileInputStream(scopeFileName);
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                if (!strLine.endsWith("System.Web.Mvc.dll")) continue;
                return true;
            }
            in.close();
        }
        catch (Exception e) {
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{e.toString() + Messages.getTraceFromException((Exception)e)}));
        }
        return false;
    }

    public static String GetUrl(IClass iclass, IMethod method) {
        String className = iclass.getName().toString();
        int lastSlashIndex = className.lastIndexOf(47);
        String simpleClassNameWithoutControllerSuffix = className.substring(lastSlashIndex + 1, className.toLowerCase().lastIndexOf("controller"));
        String url = "/" + simpleClassNameWithoutControllerSuffix;
        String methodName = method.getName().toString();
        if (!methodName.equals("Index")) {
            url = url + "/" + methodName;
        }
        return url;
    }
}

