/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.aspdotnet.util;

import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XmlReader {
    private Document doc = null;

    protected XmlReader(String xmlFilename) {
        try {
            File xmlFile = new File(xmlFilename);
            if (xmlFile.exists() && !xmlFile.isDirectory()) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = documentBuilderFactory.newDocumentBuilder();
                this.doc = docBuilder.parse(xmlFile);
                this.doc.getDocumentElement().normalize();
            }
        }
        catch (Exception ex) {
            this.doc = null;
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.handler.exception", (Object[])new Object[]{ex.toString() + Messages.getTraceFromException((Exception)ex)}));
        }
    }

    protected String GetNodeWithSpecificAttributePrefix(String tagName, String attributeName, String prefix) {
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.examine", (Object[])new Object[]{"XmlReader::XmlNodeWithSpecificAttributeExist"}));
        if (this.doc == null) {
            return "";
        }
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.examine", (Object[])new Object[]{"XmlReader::XmlNodeWithSpecificAttributeExist doc!=null"}));
        NodeList nodeList = this.doc.getElementsByTagName(tagName);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element e = (Element)nodeList.item(i);
            String a = e.getAttribute(attributeName);
            if (!a.startsWith(prefix) || a.charAt(prefix.length()) == '.') continue;
            return a;
        }
        return "";
    }
}

