/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.cli.config.containers;

import com.hcl.appscan.discovery.containers.Messages;
import com.hcl.appscan.discovery.containers.docker.DockerHandlerFactory;
import com.hcl.appscan.discovery.containers.docker.IDockerHandler;
import com.hcl.appscan.discovery.containers.utils.ContainerUtils;
import com.hcl.appscan.sdk.error.AppScanException;
import com.hcl.appscan.sdk.scan.ITarget;
import com.hcl.appscan.sdk.scanners.sast.SASTScanManager;
import com.hcl.appscan.sdk.scanners.sast.targets.GenericTarget;
import com.ibm.appscan.cli.common.ProgressAdapter;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import java.io.File;

public class PrepareScaHandler {
    private boolean m_isContainer = false;
    private String m_name;

    public PrepareScaHandler(String name, boolean isContainer) {
        this.m_isContainer = isContainer;
        this.m_name = name;
    }

    public File configureForDockerSCA() {
        File appscanConfig = null;
        if (ContainerUtils.isDockerInstalled()) {
            try {
                IDockerHandler handler = DockerHandlerFactory.getHandler(this.m_name, (IProgress)new ProgressAdapter(), this.m_isContainer);
                if (handler == null) {
                    throw new com.ibm.appscan.common.error.AppScanException(Messages.bind(Messages.INVALID_IMAGE, this.m_name));
                }
                File containerArchive = handler.getContainerArchive();
                appscanConfig = this.createConfigFile(containerArchive);
            }
            catch (AppScanException | com.ibm.appscan.common.error.AppScanException e) {
                CommonCore.getLogManager().log(new Message(4, Messages.bind(Messages.ERROR_READ_CONTAINER, e.getMessage())));
            }
        } else {
            CommonCore.getIOConsole().println(new Message(2, Messages.ERROR_NO_DOCKER));
        }
        return appscanConfig;
    }

    private File createConfigFile(File archive) throws AppScanException {
        String tempDir = CommonCore.getDirectoryLocator().getTemp();
        SASTScanManager manager = new SASTScanManager(tempDir);
        manager.setIsOpenSourceOnlyEnabled(true);
        manager.addScanTarget((ITarget)new GenericTarget(archive.getAbsolutePath()));
        manager.createConfig();
        return new File(tempDir, "appscan-config.xml");
    }
}

