/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.internal.discovery.containers.docker;

import com.hcl.appscan.discovery.containers.IContainerEngine;
import com.hcl.appscan.discovery.containers.Messages;
import com.hcl.appscan.discovery.containers.docker.DockerEngine;
import com.hcl.appscan.discovery.containers.docker.IDockerHandler;
import com.hcl.appscan.internal.discovery.containers.docker.ContainerHandler;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.error.AppScanException;
import com.ibm.appscan.common.logging.Message;
import java.io.File;
import java.io.IOException;
import java.util.UUID;

public class ImageHandler
implements IDockerHandler {
    private String m_imageName;
    private IProgress m_progress;
    private IContainerEngine m_engine;
    private boolean m_createdContainer = false;
    private boolean m_pulledImage = false;

    public ImageHandler(String image, IProgress progress) {
        this(image, progress, new DockerEngine());
    }

    public ImageHandler(String image, IProgress progress, IContainerEngine engine) {
        this.m_imageName = image;
        this.m_progress = progress;
        this.m_engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public File getContainerArchive() throws AppScanException {
        File archive = null;
        String containerName = this.getContainerName();
        try {
            if (!this.m_engine.imageExists(this.m_imageName)) {
                this.m_progress.setStatus(new Message(1, Messages.bind(Messages.DOCKER_PULL, this.m_imageName)));
                this.m_engine.pullImage(this.m_imageName);
                this.m_pulledImage = true;
            }
            this.createContainer(containerName);
            archive = new ContainerHandler(containerName, this.m_progress, this.m_engine).getContainerArchive();
        }
        catch (AppScanException | IOException e) {
            this.handleException(this.m_progress, e, Messages.bind(Messages.ERROR_CREATE_CONTAINER, e.getMessage()));
        }
        finally {
            if (this.m_createdContainer) {
                this.removeContainer(containerName);
            }
            if (this.m_pulledImage) {
                this.removeImage();
            }
        }
        return archive;
    }

    private String getContainerName() {
        return "appscan" + UUID.randomUUID();
    }

    private void createContainer(String containerName) throws IOException, AppScanException {
        this.m_progress.setStatus(new Message(1, Messages.bind(Messages.DOCKER_CREATE_CONTAINER, this.m_imageName)));
        this.m_engine.createContainer(this.m_imageName, containerName);
        this.m_createdContainer = true;
    }

    private void removeContainer(String containerName) {
        this.m_progress.setStatus(new Message(1, Messages.DOCKER_REMOVE_CONTAINER));
        try {
            this.m_engine.removeContainer(containerName);
        }
        catch (AppScanException | IOException e) {
            this.m_progress.setStatus(new Message(2, Messages.bind(Messages.DOCKER_RM_FAILED, containerName, e.getMessage())));
        }
    }

    private void removeImage() throws AppScanException {
        this.m_progress.setStatus(new Message(1, Messages.DOCKER_REMOVE_IMAGE));
        try {
            this.m_engine.removeImage(this.m_imageName);
        }
        catch (AppScanException | IOException e) {
            this.m_progress.setStatus(new Message(2, Messages.bind(Messages.DOCKER_RMI_FAILED, this.m_imageName, e.getMessage())));
        }
    }
}

