/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.spring3;

import com.ibm.appscan.frameworks.analyzers.spring.SpringConfigFileInfo;
import com.ibm.appscan.frameworks.handlers.spring3.SpringBeanScope;
import com.ibm.appscan.frameworks.handlers.spring3.Util;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.Global;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.HighLevelSyntheticMethod;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Local;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Param;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;

public class Spring3BeanInfo
extends SpringConfigFileInfo.SpringBeanInfo {
    private SpringBeanScope m_scope;
    private String m_name;
    private String m_beanVdbClassName;
    private IClass m_beanClass;
    private boolean m_isController = false;
    private boolean m_isRestController = false;
    private boolean m_isEntryPoint = false;
    private String m_controllerURL;
    private boolean m_isConvertedFromSpring25BeanInfo = false;
    private FilePositionInfo m_filePosInfo;

    public Spring3BeanInfo(String name, IClass beanClass, SpringBeanScope scope, boolean isController, boolean isRestController, boolean isEntryPoint, String controllerURL) {
        super(null, null, null, null, null);
        this.m_name = name;
        this.m_scope = scope;
        this.m_beanClass = beanClass;
        this.m_isController = isController;
        this.m_isRestController = isRestController;
        this.m_isEntryPoint = isEntryPoint;
        this.m_controllerURL = controllerURL;
        this.m_beanVdbClassName = this.m_beanClass.getName().toString();
        this.m_beanVdbClassName = this.m_beanVdbClassName.replace("/", ".");
        if (this.m_beanVdbClassName.startsWith("L")) {
            this.m_beanVdbClassName = this.m_beanVdbClassName.substring(1, this.m_beanVdbClassName.length());
        }
        this.m_filePosInfo = Util.getClassPosition(this.m_beanClass);
        this.m_isConvertedFromSpring25BeanInfo = false;
    }

    public Spring3BeanInfo(SpringConfigFileInfo.SpringBeanInfo spring25BeanInfo) {
        super(spring25BeanInfo.getId(), spring25BeanInfo.getNames(), spring25BeanInfo.getClassAttr(), spring25BeanInfo.getProperties(), spring25BeanInfo.getFilePosInfo());
        this.m_filePosInfo = spring25BeanInfo.getFilePosInfo();
        this.m_isConvertedFromSpring25BeanInfo = true;
    }

    public String getVdbClassName() {
        return this.m_beanVdbClassName;
    }

    public IClass getClassType(F4FApp app) {
        if (this.m_beanClass == null) {
            this.m_beanClass = app.getIClass(this.m_beanVdbClassName);
        }
        return this.m_beanClass;
    }

    public SpringBeanScope getScope() {
        return this.m_scope;
    }

    public String getName() {
        return this.m_name;
    }

    public FilePositionInfo getFilePosInfo() {
        return this.m_filePosInfo;
    }

    public boolean isController() {
        return this.m_isController;
    }

    public boolean isEntryPoint() {
        return this.m_isEntryPoint;
    }

    public boolean isRestController() {
        return this.m_isRestController;
    }

    public boolean isConvertedFromSpring25BeanInfo() {
        return this.m_isConvertedFromSpring25BeanInfo;
    }

    public String getControllerURL() {
        return this.m_controllerURL;
    }

    public Param createCorrespondingWAFLVariable(F4FApp app, F4FActions actions, HighLevelSyntheticMethod synMethod) {
        Local variable = null;
        if (this.m_beanClass == null) {
            this.m_beanClass = app.getIClass(this.m_beanVdbClassName);
        }
        if (this.m_beanClass == null) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.unknown.class", (Object[])new Object[]{this.m_beanVdbClassName}));
            TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.variable", (Object[])new Object[]{this.m_name}));
            return null;
        }
        switch (this.m_scope) {
            case Request: {
                String globalVariableName = this.m_scope.name() + "." + this.m_name;
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.global", (Object[])new Object[]{globalVariableName}));
                variable = actions.createGlobal(globalVariableName, this.m_beanClass, true);
                break;
            }
            case Session: {
                String globalVariableName = this.m_scope.name() + "." + this.m_name;
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.global", (Object[])new Object[]{globalVariableName}));
                variable = actions.createGlobal(globalVariableName, this.m_beanClass, false);
                break;
            }
            case GlobalSession: 
            case Singleton: {
                String globalVariableName = this.m_scope.name() + "." + this.m_name;
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.global", (Object[])new Object[]{globalVariableName}));
                variable = actions.createGlobal(globalVariableName, this.m_beanClass, false);
                break;
            }
            case Prototype: {
                variable = synMethod.newLocal(this.m_beanClass);
                break;
            }
            default: {
                TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.unknown.scope", (Object[])new Object[]{this.m_scope.toString()}));
                TaintLogger.i().getLogger().warn((Object)Messages.getString((String)"framework.failure.variable", (Object[])new Object[]{this.m_name}));
            }
        }
        return variable;
    }

    public boolean match(Global global) {
        if (this.m_scope.isGlobal()) {
            String fullName = global.getName();
            return fullName.equals(this.m_scope.name() + "." + this.m_name);
        }
        return false;
    }
}

