/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.handlers.spring3;

import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.analyzers.javaee.JavaEEOptions;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.IJSPPrecompilerInfo;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.JspEntrypointResolver;
import com.ibm.appscan.frameworks.analyzers.spring.ModelAndViewUtil;
import com.ibm.appscan.frameworks.analyzers.spring.SpringAppConfigInfo;
import com.ibm.appscan.frameworks.handlers.spring3.Spring3BeanInfo;
import com.ibm.appscan.frameworks.handlers.spring3.SpringConfigManager;
import com.ibm.appscan.frameworks.handlers.spring3.SpringValidator;
import com.ibm.appscan.frameworks.handlers.spring3.Util;
import com.ibm.appscan.frameworks.highlevelapi.F4FActions;
import com.ibm.appscan.frameworks.highlevelapi.F4FApp;
import com.ibm.appscan.frameworks.highlevelapi.processing.F4FActionProcessor;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.EnclosingFormal;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.HighLevelSyntheticMethod;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Local;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Param;
import com.ibm.appscan.frameworks.highlevelapi.synthmethod.Taint;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.shrikeCT.AnnotationsReader;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class WaflGenerator {
    private F4FApp app;
    private F4FActions actions;
    private SpringConfigManager configManager;
    private Map<String, Integer> syntheticMethodNames;

    WaflGenerator(F4FApp app, F4FActions actions, SpringConfigManager configManager) {
        this.app = app;
        this.actions = actions;
        this.configManager = configManager;
        this.syntheticMethodNames = new HashMap<String, Integer>();
    }

    public void processControllerEntryPoints() {
        Map<String, Spring3BeanInfo> theBeanMap = this.configManager.getBeanAndValidatorManager().getBeans();
        Collection<Spring3BeanInfo> theBeanList = theBeanMap.values();
        String theRootUrl = this.configManager.getRootUrl();
        for (Spring3BeanInfo theBeanInfo : theBeanList) {
            if (!theBeanInfo.isController()) continue;
            String theControllerUrl = null;
            theControllerUrl = theBeanInfo.isEntryPoint() && theBeanInfo.getControllerURL() != null ? theRootUrl + theBeanInfo.getControllerURL() : theRootUrl;
            IClass currentClass = theBeanInfo.getClassType(this.app);
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.class.found", (Object[])new Object[]{currentClass.getName().toString()}));
            String currentClassName = currentClass.getName().toString().replace("/", "_");
            if (currentClassName.startsWith("L")) {
                currentClassName = currentClassName.substring(1, currentClassName.length());
            }
            Collection methods = this.app.getMethodsDeclaredInClass(currentClass);
            for (IMethod currentEntryMethod : methods) {
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.method.found", (Object[])new Object[]{currentEntryMethod.getName().toString()}));
                Collection methodAnnotations = this.app.getMethodAnnotations(currentEntryMethod);
                String theUrl = null;
                FilePositionInfo methodPosInfo = Util.getMethodPosition(currentEntryMethod, this.configManager.getSourceDirectoryList());
                FilePositionInfo methodLastPosInfo = Util.getMethodLastPosition(currentEntryMethod, currentClass, this.configManager.getSourceDirectoryList());
                AnalysisCache cache = new AnalysisCache();
                IR ir = LangIndependentWalaUtil.getIR((IMethod)currentEntryMethod, (AnalysisCache)cache);
                for (Annotation annot : methodAnnotations) {
                    String theAnnotation = annot.getType().toString();
                    if (!theAnnotation.contains("RequestMapping") && !theAnnotation.contains("GetMapping") && !theAnnotation.contains("PostMapping") && !theAnnotation.contains("PutMapping") && !theAnnotation.contains("DeleteMapping") && !theAnnotation.contains("PatchMapping")) continue;
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{annot.getType().toString()}));
                    String syntheticMethodName = this.generateSyntheticMethodName(currentEntryMethod);
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.begin.syntheticmethod", (Object[])new Object[]{syntheticMethodName}));
                    HighLevelSyntheticMethod syntheticMethod = HighLevelSyntheticMethod.make((String)syntheticMethodName);
                    Param[] theParams = new Param[currentEntryMethod.getNumberOfParameters()];
                    HashMap<Param, String> paramTypeMap = new HashMap<Param, String>();
                    Collection[] pa = this.app.getMethodParametersAnnotations(currentEntryMethod);
                    int numParameters = currentEntryMethod.getNumberOfParameters();
                    for (int i = 0; i < numParameters; ++i) {
                        if (i <= 0) continue;
                        boolean isTainted = false;
                        String theParamName = null;
                        if (currentEntryMethod.hasLocalVariableTable()) {
                            theParamName = ir.getLocalNames(0, ir.getParameter(i))[0];
                        }
                        for (Annotation a : pa[i - 1]) {
                            String typeString = a.getType().toString();
                            if (!typeString.contains("RequestParam") && !typeString.contains("PathVariable") && !typeString.contains("MatrixVariable") && !typeString.contains("ModelAttribute") && !typeString.contains("RequestHeader") && !typeString.contains("RequestBody") && !typeString.contains("CookieValue")) continue;
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{a.getType().toString()}));
                            String theName = theParamName;
                            if (a.getType().toString().contains("RequestParam") && a.getNamedArguments().get("value") != null) {
                                theName = ((AnnotationsReader.ElementValue)a.getNamedArguments().get("value")).toString();
                            }
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.taint.param.found", (Object[])new Object[]{theName, i}));
                            theParams[i] = this.taintToProperType(theName, currentEntryMethod.getParameterType(i).getName().toString(), syntheticMethod, methodPosInfo);
                            isTainted = true;
                            String vdbTypeString = VDBJavaUtil.jvmToVDBType((String)currentEntryMethod.getParameterType(i).getName().toString());
                            Param param = this.taintToProperType(theName, currentEntryMethod.getParameterType(i).getName().toString(), syntheticMethod, methodLastPosInfo);
                            paramTypeMap.put(param, vdbTypeString);
                            break;
                        }
                        if (isTainted) continue;
                        if (i + 1 < numParameters && annot.getNamedArguments().get("method") != null && ((AnnotationsReader.ElementValue)annot.getNamedArguments().get("method")).toString().contains("POST") && currentEntryMethod.getParameterType(i + 1).getName().toString().contains("BindingResult")) {
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{"BindingResult"}));
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.taint.param.found", (Object[])new Object[]{theParamName, i}));
                            theParams[i] = this.taintToProperType(theParamName, currentEntryMethod.getParameterType(i).getName().toString(), syntheticMethod, methodPosInfo);
                            String vdbTypeString = VDBJavaUtil.jvmToVDBType((String)currentEntryMethod.getParameterType(i).getName().toString());
                            Param thisParamLastLinePos = this.taintToProperType(theParamName, currentEntryMethod.getParameterType(i).getName().toString(), syntheticMethod, methodLastPosInfo);
                            paramTypeMap.put(thisParamLastLinePos, vdbTypeString);
                            continue;
                        }
                        String paramName = currentEntryMethod.getParameterType(i).getName().toString();
                        if ((paramName = paramName.replace("/", ".")).startsWith("L")) {
                            paramName = paramName.substring(1, paramName.length());
                        }
                        Local theLocal = syntheticMethod.newLocal(paramName);
                        theParams[i] = theLocal;
                        paramTypeMap.put(theParams[i], paramName);
                    }
                    this.processValidators(currentClass, currentEntryMethod, pa, syntheticMethod, theParams);
                    String theFilename = currentClass.getSourceFileName();
                    theUrl = annot.getNamedArguments().get("value") != null ? theControllerUrl + Util.cleanString(((AnnotationsReader.ElementValue)annot.getNamedArguments().get("value")).toString()) : theControllerUrl;
                    HashSet<String> urlSet = new HashSet<String>();
                    urlSet.add(theUrl);
                    HashMap vdb2Urls = HashMapFactory.make();
                    vdb2Urls.put(syntheticMethod.getVdbSignature(), urlSet);
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.method.url", (Object[])new Object[]{syntheticMethod.getVdbSignature(), theUrl}));
                    F4FActionProcessor.addUrls((Map)vdb2Urls);
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{currentEntryMethod.getSignature()}));
                    Local returnVariable = syntheticMethod.addCall(currentEntryMethod, methodPosInfo, theParams);
                    if (this.containsAnnotation(methodAnnotations, "ResponseBody") || theBeanInfo.isRestController()) {
                        FilePositionInfo returnPosition = Util.getMethodLastPosition(currentEntryMethod, currentClass, this.configManager.getSourceDirectoryList());
                        if (returnPosition == null) {
                            returnPosition = methodPosInfo;
                        }
                        this.generateCallToSink(returnVariable, syntheticMethod, returnPosition);
                        this.actions.addHighLevelSyntheticMethod(syntheticMethod);
                        continue;
                    }
                    JspEntrypointResolver jspEntrypointResolver = JspEntrypointResolver.make((IJSPPrecompilerInfo)JavaEEOptions.getPrecompilerInfo((Properties)this.configManager.getOptions()), (String)this.configManager.getWebContentDir());
                    Set<Object> forwardPathsUsingJavaConfig = HashSetFactory.make();
                    if (this.configManager.getUsingJavaConfig()) {
                        forwardPathsUsingJavaConfig = this.configManager.getPathsToViewEntrypoints(currentEntryMethod, new AnalysisCache());
                    }
                    Set<Object> forwardPaths = HashSetFactory.make();
                    forwardPaths = ModelAndViewUtil.getPathsToViewEntrypoints((IMethod)currentEntryMethod, (AnalysisCache)new AnalysisCache(), (SpringAppConfigInfo)this.configManager.get25AppConfigInfo(), (String)this.configManager.getWebContentDir());
                    if (forwardPaths.isEmpty()) {
                        forwardPaths = forwardPathsUsingJavaConfig;
                    } else if (!forwardPathsUsingJavaConfig.isEmpty()) {
                        forwardPaths.addAll(forwardPathsUsingJavaConfig);
                    }
                    if (forwardPaths.size() == 0) {
                        ArrayList<String> freemarkerFileList;
                        boolean returnTypeString = false;
                        TypeReference typeReference = currentEntryMethod.getReturnType();
                        if (typeReference.getName().toString().equals("Ljava/lang/String")) {
                            returnTypeString = true;
                        }
                        if (returnTypeString && (freemarkerFileList = this.configManager.getFreemarkerFileList()).size() > 0) {
                            FilePositionInfo returnPosition = Util.getMethodLastPosition(currentEntryMethod, currentClass, this.configManager.getSourceDirectoryList());
                            if (returnPosition == null) {
                                returnPosition = methodPosInfo;
                            }
                            for (Param thisParam : theParams) {
                                if (!(thisParam instanceof Taint)) continue;
                                String typeInVDB = (String)paramTypeMap.get(thisParam);
                                this.generateCallToSinkForTaintParam(thisParam, typeInVDB, syntheticMethod, returnPosition);
                            }
                        }
                    }
                    for (String string : forwardPaths) {
                        if (!string.endsWith(".jsp")) {
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.failure.unrecognized", (Object[])new Object[]{string}));
                        }
                        if (!jspEntrypointResolver.isValidJSPPath(string)) {
                            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.view.not.found", (Object[])new Object[]{string}));
                            continue;
                        }
                        String jspEntrypointSignature = jspEntrypointResolver.getJSPEntrypointSig(string);
                        String vdbSignature = VDBJavaUtil.jvmToVDBSignature((String)jspEntrypointSignature);
                        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{vdbSignature}));
                        syntheticMethod.addCall(vdbSignature, methodPosInfo, new Param[]{EnclosingFormal.FIRST, EnclosingFormal.SECOND});
                    }
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.syntheticmethod", (Object[])new Object[]{syntheticMethod.getVdbSignature()}));
                    this.actions.addHighLevelSyntheticMethod(syntheticMethod);
                }
            }
        }
    }

    private Param taintToProperType(String paramName, String targetTypeName, HighLevelSyntheticMethod method, FilePositionInfo position) {
        Taint result;
        Taint taint = result = paramName != null ? Taint.taintWithParamName((String)paramName) : Taint.taint();
        if (targetTypeName.equals("J")) {
            result = method.addCall("java.lang.Long.parseLong(java.lang.String):long", position, new Param[]{result});
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"java.lang.Long.parseLong(java.lang.String):long"}));
        } else if (targetTypeName.equals("I")) {
            result = method.addCall("java.lang.Integer.parseInt(java.lang.String):int", position, new Param[]{result});
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"java.lang.Integer.parseInt(java.lang.String):int"}));
        } else if (targetTypeName.equals("S")) {
            result = method.addCall("java.lang.Short.parseShort(java.lang.String):short", position, new Param[]{result});
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"java.lang.Short.parseShort(java.lang.String):short"}));
        } else if (targetTypeName.equals("B")) {
            result = method.addCall("java.lang.Byte.parseByte(java.lang.String):byte", position, new Param[]{result});
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"java.lang.Byte.parseByte(java.lang.String):byte"}));
        } else if (targetTypeName.equals("D")) {
            result = method.addCall("java.lang.Double.parseDouble(java.lang.String):double", position, new Param[]{result});
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"java.lang.Double.parseDouble(java.lang.String):double"}));
        } else if (targetTypeName.equals("F")) {
            result = method.addCall("java.lang.Float.parseFloat(java.lang.String):float", position, new Param[]{result});
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"java.lang.Float.parseFloat(java.lang.String):float"}));
        } else if (targetTypeName.equals("Ljava/lang/Boolean")) {
            result = method.addCall("java.lang.Boolean.valueOf(java.lang.String):java.lang.Boolean", position, new Param[]{result});
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{"java.lang.Boolean.valueOf(java.lang.String):java.lang.Boolean"}));
        }
        return result;
    }

    private void processValidators(IClass currentClass, IMethod currentEntryMethod, Collection<Annotation>[] parameterAnnoList, HighLevelSyntheticMethod syntheticMethod, Param[] theParams) {
        for (int index = 0; index < currentEntryMethod.getNumberOfParameters(); ++index) {
            if (index <= 0) continue;
            block1: for (Annotation anno : parameterAnnoList[index - 1]) {
                if (!anno.getType().toString().contains("Valid")) continue;
                TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.annotation.found", (Object[])new Object[]{anno.getType().toString()}));
                TypeReference paramType = currentEntryMethod.getParameterType(index);
                ArrayList<SpringValidator> fieldValidators = this.configManager.getBeanAndValidatorManager().getValidator(paramType);
                if (fieldValidators == null) continue;
                HighLevelSyntheticMethod classLevelValidateSynMethod = null;
                for (SpringValidator validator : fieldValidators) {
                    if (classLevelValidateSynMethod != null) continue;
                    FilePositionInfo methodFilePosInfo = Util.getMethodPosition(currentEntryMethod, this.configManager.getSourceDirectoryList());
                    classLevelValidateSynMethod = validator.getClassLevelValidateSynMethod();
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.syntheticmethod", (Object[])new Object[]{classLevelValidateSynMethod.getVdbSignature()}));
                    this.actions.addHighLevelSyntheticMethod(classLevelValidateSynMethod, false);
                    TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{classLevelValidateSynMethod.getVdbSignature()}));
                    Local localValue = syntheticMethod.addCall(classLevelValidateSynMethod.getVdbSignature(), methodFilePosInfo, new Param[]{theParams[index]});
                    theParams[index] = localValue;
                    continue block1;
                }
            }
        }
    }

    private String generateSyntheticMethodName(IMethod theMethod) {
        String syntheticMethodKey = theMethod.getName().toString();
        Integer num = this.syntheticMethodNames.get(syntheticMethodKey);
        Integer value = num == null ? 1 : num + 1;
        this.syntheticMethodNames.put(syntheticMethodKey, value);
        String syntheticMethodName = value == 1 ? "AppScan.Synthetic.Spring3." + theMethod.getName().toString() + "__entry(javax.servlet.http.HttpServletRequest;javax.servlet.http.HttpServletResponse):void" : "AppScan.Synthetic.Spring3." + theMethod.getName().toString() + "_" + value + "__entry(javax.servlet.http.HttpServletRequest;javax.servlet.http.HttpServletResponse):void";
        return syntheticMethodName;
    }

    private boolean containsAnnotation(Collection<Annotation> annotations, String annotationName) {
        for (Annotation annot : annotations) {
            if (!annot.getType().toString().contains(annotationName)) continue;
            return true;
        }
        return false;
    }

    private void generateCallToSink(Local inputParam, HighLevelSyntheticMethod synMethod, FilePositionInfo filePositionInfo) {
        String callToGetWriterSig = "javax.servlet.ServletResponse.getWriter():java.io.PrintWriter";
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{callToGetWriterSig}));
        Local writerObject = synMethod.addCall(callToGetWriterSig, filePositionInfo, new Param[]{EnclosingFormal.SECOND});
        StringBuilder callSig = new StringBuilder("java.io.Writer.write(");
        callSig.append(inputParam == null ? "" : inputParam.getDeclaredVDBType());
        callSig.append(")");
        callSig.append(":void");
        TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{callSig.toString()}));
        synMethod.addCall(callSig.toString(), filePositionInfo, new Param[]{writerObject, inputParam});
    }

    private void generateCallToSinkForTaintParam(Param inputParam, String paramVDBType, HighLevelSyntheticMethod synMethod, FilePositionInfo filePositionInfo) {
        if (paramVDBType.contains("String")) {
            String callToGetWriterSig = "javax.servlet.ServletResponse.getWriter():java.io.PrintWriter";
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{callToGetWriterSig}));
            Local writerObject = synMethod.addCall(callToGetWriterSig, filePositionInfo, new Param[]{EnclosingFormal.SECOND});
            StringBuilder callSig = new StringBuilder("java.io.Writer.write(");
            callSig.append(paramVDBType);
            callSig.append(")");
            callSig.append(":void");
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{callSig.toString()}));
            synMethod.addCall(callSig.toString(), filePositionInfo, new Param[]{writerObject, inputParam});
        } else {
            String callToGetWriterSig = "javax.servlet.ServletResponse.getWriter():java.io.PrintWriter";
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{callToGetWriterSig}));
            Local writerObject = synMethod.addCall(callToGetWriterSig, filePositionInfo, new Param[]{EnclosingFormal.SECOND});
            StringBuilder callSig = new StringBuilder("java.io.PrintWriter.print(");
            callSig.append("java.lang.Object");
            callSig.append(")");
            callSig.append(":void");
            TaintLogger.i().getLogger().info((Object)Messages.getString((String)"framework.generate.call", (Object[])new Object[]{callSig.toString()}));
            synMethod.addCall(callSig.toString(), filePositionInfo, new Param[]{writerObject, inputParam});
        }
    }
}

