/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.driver;

import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IRuleCopier;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.grammar.string.SimpleRuleCopier;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IValueSymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.stringAnalysis.grammar.InvocationSymbol;
import com.ibm.wala.stringAnalysis.grammar.SignatureSymbol;
import com.ibm.wala.stringAnalysis.sanitizerDetection.driver.IStringConstantPropagationSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StringConstantPropagationAnalysis {
    public static SimpleGrammar manageConstantString(SimpleGrammar g, Collection<? extends IVariable> vars, final IStringConstantPropagationSelector cselector) {
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        HashSet<IVariable> hist = new HashSet<IVariable>();
        for (IVariable iVariable : vars) {
            StringConstantPropagationAnalysis.collectDirectConstantStringRules(rules, g, iVariable, hist, cselector);
        }
        HashSet<IProductionRule> newRules = new HashSet<IProductionRule>();
        for (IProductionRule r : rules) {
            IProductionRule nr = r.copy((IRuleCopier)new SimpleRuleCopier(){

                public Collection<ISymbol> copyRight(Collection<? extends ISymbol> symbols, Collection<ISymbol> result) {
                    ISymbol s = symbols.iterator().next();
                    if (s instanceof InvocationSymbol) {
                        InvocationSymbol invoke = (InvocationSymbol)s;
                        List params = new ArrayList();
                        int[] pp = cselector.select(invoke.getFunction().getName());
                        params = StringConstantPropagationAnalysis.convertToSafeConstantList(invoke.getParameters(), pp);
                        InvocationSymbol newSym = new InvocationSymbol(invoke.getCallGraph(), invoke.getCGNode(), invoke.getInstruction(), invoke.getFunction(), invoke.getReceiver(), params);
                        return Collections.singletonList(newSym);
                    }
                    return Collections.emptyList();
                }
            });
            newRules.add(nr);
        }
        g.getRules().removeAll(rules);
        g.getRules().addAll(newRules);
        return g;
    }

    private static void collectDirectConstantStringRules(Collection<IProductionRule> rules, SimpleGrammar g, IVariable v, Collection<IVariable> h, IStringConstantPropagationSelector cselector) {
        if (h.contains(v)) {
            return;
        }
        h.add(v);
        Set rs = g.getRules(v);
        for (IProductionRule r : rs) {
            List right = r.getRight();
            if (right.size() != 1) continue;
            ISymbol s = (ISymbol)right.get(0);
            if (s instanceof InvocationSymbol) {
                InvocationSymbol isym = (InvocationSymbol)s;
                SignatureSymbol ssym = isym.getFunction();
                String sig = ssym.getName();
                int[] params = cselector.select(sig);
                if (params == null) continue;
                for (int i : params) {
                    if (i < 0) {
                        ISymbol recv = isym.getReceiver();
                        StringConstantPropagationAnalysis.collectDirectConstantStringRules(rules, g, (IVariable)recv, h, cselector);
                        continue;
                    }
                    ISymbol p = isym.getParameter(i);
                    if (p instanceof IVariable) {
                        StringConstantPropagationAnalysis.collectDirectConstantStringRules(rules, g, (IVariable)p, h, cselector);
                        continue;
                    }
                    rules.add(r);
                }
                continue;
            }
            if (StringConstantPropagationAnalysis.isLegalConstant(s)) {
                rules.add(r);
                continue;
            }
            if (!(s instanceof IVariable)) continue;
            StringConstantPropagationAnalysis.collectDirectConstantStringRules(rules, g, (IVariable)s, h, cselector);
        }
    }

    private static ISymbol convertToSafeConstant(ISymbol s) {
        return StringSymbol.MIN;
    }

    private static List<ISymbol> convertToSafeConstantList(List<ISymbol> l, int[] maySafe) {
        ArrayList<ISymbol> res = new ArrayList<ISymbol>(l.size());
        int i = 0;
        for (int p : maySafe) {
            for (int j = i; j < p; ++j) {
                ISymbol e = l.get(j);
                res.add(e);
            }
            ISymbol e = l.get(p);
            if (StringConstantPropagationAnalysis.isLegalConstant(e)) {
                res.add(StringConstantPropagationAnalysis.convertToSafeConstant(e));
            } else {
                res.add(e);
            }
            i = p + 1;
        }
        for (int j = i; j < l.size(); ++j) {
            ISymbol e = l.get(j);
            res.add(e);
        }
        return res;
    }

    private static boolean isLegalConstant(ISymbol s) {
        return s instanceof IValueSymbol;
    }
}

