/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common;

import com.ibm.appscan.common.Configuration;
import com.ibm.appscan.common.DirectoryLocator;
import com.ibm.appscan.common.VersionInfo;
import com.ibm.appscan.common.build.IBuildManager;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.model.IConsole;
import com.ibm.appscan.internal.common.build.BuildManager;
import com.ibm.appscan.internal.common.logging.DefaultLogManager;
import com.ibm.appscan.internal.common.model.Console;

public final class CommonCore {
    private static VersionInfo versionInfo = null;
    private static DirectoryLocator directoryLocator = new DirectoryLocator();
    private static IBuildManager buildManager = null;
    private static String logName = "client.log";
    private static ILogManager logManager = null;
    private static Configuration configuration = new Configuration();
    private static IConsole m_console = null;

    private CommonCore() {
    }

    public static DirectoryLocator getDirectoryLocator() {
        return directoryLocator;
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static synchronized IBuildManager getBuildManager() {
        if (buildManager == null) {
            buildManager = new BuildManager();
        }
        return buildManager;
    }

    public static void setLogName(String name) {
        logName = name;
    }

    public static synchronized ILogManager getLogManager() {
        if (logManager == null) {
            logManager = new DefaultLogManager(logName);
            logManager.init();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    logManager.close();
                }
            }));
        }
        return logManager;
    }

    public static synchronized void setLogManager(ILogManager mgr) {
        logManager = mgr;
    }

    public static synchronized IConsole getIOConsole() {
        if (m_console == null) {
            m_console = new Console();
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    m_console.close();
                }
            }));
        }
        return m_console;
    }

    static synchronized void setVersionInfo(VersionInfo vi) {
        versionInfo = vi;
    }

    public static synchronized VersionInfo getVersionInfo() {
        return versionInfo;
    }
}

