/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.logging.stats;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.metrics.DoubleAvgMetric;
import com.ibm.appscan.common.metrics.HighestValueMetric;
import com.ibm.appscan.common.metrics.IntegerSumMetric;
import com.ibm.appscan.common.metrics.LanguageMetric;
import com.ibm.appscan.common.metrics.LowestValueMetric;
import com.ibm.appscan.common.metrics.Metric;
import com.ibm.appscan.common.metrics.StringListMetric;
import com.ibm.appscan.common.metrics.StringMetric;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.xml.DOMWriter;
import com.ibm.appscan.common.xml.XmlFileWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PrepareStatsWriter
extends XmlFileWriter {
    private File m_working_dir;
    protected File m_final_stats;
    protected HashMap<String, Metric> m_metrics = new HashMap();
    private HashSet<String> m_integer_sum_metrics;
    private HashSet<String> m_average_value_metrics;
    private HashSet<String> m_highest_value_metrics;
    private HashSet<String> m_string_list_metrics;
    private HashSet<String> m_lowest_value_metrics;

    public PrepareStatsWriter(File output_dir, File stats_dir) {
        super(output_dir);
        this.m_working_dir = stats_dir;
    }

    public Collection<Metric> getMetrics() {
        return this.m_metrics.values();
    }

    protected void replaceMetric(String name, String value) {
        Metric m = this.getMetric(name);
        m.addMetricValue(value);
        this.m_metrics.put(name, m);
    }

    public void addStringListMetric(String name, String value) {
        if (!this.m_metrics.containsKey(name)) {
            this.m_metrics.put(name, new StringListMetric(value));
        }
        this.m_metrics.get(name).addMetricValue(value);
    }

    public void setMetricValue(String name, String value) {
        if (this.m_metrics.containsKey(name)) {
            // empty if block
        }
    }

    public void removeMetric(String name) {
        this.m_metrics.remove(name);
    }

    @Override
    protected String getFileName() {
        File[] matchingFiles = this.getBasePathForOutput().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("orig");
            }
        });
        return matchingFiles.length == 1 ? matchingFiles[0].getName().substring(0, matchingFiles[0].getName().lastIndexOf(".")) + ".stats" : "java.stats";
    }

    @Override
    protected void writeXml(DOMWriter writer) {
        writer.beginElement("SastMetrics");
        for (String key : this.m_metrics.keySet()) {
            Metric metric = this.m_metrics.get(key);
            if (key == "FilesScanned") {
                key = "ClassFilesScanned";
            }
            if (metric.getMetricValue() != null && metric.getMetricValue().length() > 0) {
                writer.beginElement(key);
                writer.endElement(metric.getMetricValue());
                continue;
            }
            if (metric.getMetaData().isEmpty()) continue;
            writer.beginElement(metric.getMetricName());
            for (String data : metric.getMetaData().keySet()) {
                writer.setAttribute(data, metric.getMetaData().get(data));
            }
            writer.endElement();
        }
        writer.endElement();
    }

    @Override
    public void saveXml() throws IOException, TransformerException, ParserConfigurationException {
        this.processStatsDirectories();
        super.saveXml();
    }

    protected void processStatsDirectories() throws FileNotFoundException, ParserConfigurationException, IOException {
        this.processStatsFiles(this.m_working_dir);
    }

    protected void processStatsFiles(File dir) throws ParserConfigurationException, FileNotFoundException, IOException {
        block8: {
            block7: {
                if (!dir.isDirectory()) break block7;
                for (File f : dir.listFiles()) {
                    this.processStatsFiles(f);
                }
                break block8;
            }
            if (!FileUtil.getFileExtension(dir).equals("stats")) break block8;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = null;
            try {
                doc = builder.parse(new FileInputStream(dir));
            }
            catch (SAXException e) {
                CommonCore.getLogManager().log(e);
            }
            Element root = doc.getDocumentElement();
            NodeList stats = root.getChildNodes();
            for (int i = 0; i < stats.getLength(); ++i) {
                Node node = stats.item(i);
                if (node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase("language") && node.hasAttributes()) {
                    String language = node.getAttributes().getNamedItem("name").getNodeValue();
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    NamedNodeMap nodeMap = node.getAttributes();
                    for (int j = 0; j < nodeMap.getLength(); ++j) {
                        Node attribute = nodeMap.item(j);
                        attributes.put(attribute.getNodeName(), attribute.getNodeValue());
                    }
                    this.m_metrics.put(language, new LanguageMetric(attributes));
                    continue;
                }
                if (node.getNodeType() != 1) continue;
                if (!node.getNodeName().equals("SourceCodeOnlyScan")) {
                    this.getMetric(node.getNodeName()).addMetricValue(node.getTextContent());
                    if (!stats.item(i).getNodeName().equals("Language")) continue;
                    this.getMetric("Languages").addMetricValue(node.getTextContent().toLowerCase());
                    continue;
                }
                if (dir.getAbsolutePath().contains(File.separator + "slices" + File.separator + "Java" + File.separator)) continue;
                this.getMetric(node.getNodeName()).addMetricValue(node.getTextContent());
            }
        }
    }

    public Metric getMetric(String name) {
        if (this.m_metrics.get(name) != null) {
            return this.m_metrics.get(name);
        }
        Metric ret = this.getIntegerSumMetrics().contains(name) ? new IntegerSumMetric(name) : (this.getAverageValueMetrics().contains(name) ? new DoubleAvgMetric(name) : (this.getHighestValueMetrics().contains(name) ? new HighestValueMetric(name) : (this.getStringListMetrics().contains(name) ? new StringListMetric(name) : (this.getLowestValueMetrics().contains(name) ? new LowestValueMetric(name) : new StringMetric(name)))));
        this.m_metrics.put(name, ret);
        return this.m_metrics.get(name);
    }

    protected HashSet<String> getIntegerSumMetrics() {
        if (this.m_integer_sum_metrics == null) {
            this.m_integer_sum_metrics = new HashSet();
            this.m_integer_sum_metrics.add("ClassFilesEncountered");
            this.m_integer_sum_metrics.add("NumberOfSlices");
            this.m_integer_sum_metrics.add("MethodsScanned");
            this.m_integer_sum_metrics.add("SkippedMethods");
            this.m_integer_sum_metrics.add("IRGenTimeTakenSec");
            this.m_integer_sum_metrics.add("TotalPrepareTimeMS");
            this.m_integer_sum_metrics.add("TotalRoots");
            this.m_integer_sum_metrics.add("TotalFindings");
            this.m_integer_sum_metrics.add("LinesScanned");
            this.m_integer_sum_metrics.add("TotalVulnerabilityTypes");
            this.m_integer_sum_metrics.add("TotalMediumFindings");
            this.m_integer_sum_metrics.add("TotalHighFindings");
            this.m_integer_sum_metrics.add("TotalLowFindings");
            this.m_integer_sum_metrics.add("TotalFindingsWithTraces");
            this.m_integer_sum_metrics.add("TotalLowIFAFindings");
            this.m_integer_sum_metrics.add("TotalMediumIFAFindings");
            this.m_integer_sum_metrics.add("TotalHighIFAFindings");
            this.m_integer_sum_metrics.add("TotalIFAFindings");
            this.m_integer_sum_metrics.add("IRFileSize");
            this.m_integer_sum_metrics.add("ClassFilesScanned");
            this.m_integer_sum_metrics.add("FilesScanned");
            this.m_integer_sum_metrics.add("AnalysisTimeTakenSec");
            this.m_integer_sum_metrics.add("ClassFilesExcluded");
        }
        return this.m_integer_sum_metrics;
    }

    protected HashSet<String> getAverageValueMetrics() {
        if (this.m_average_value_metrics == null) {
            this.m_average_value_metrics = new HashSet();
            this.m_average_value_metrics.add("PercentageMethodsSkipped");
            this.m_average_value_metrics.add("IRGenAverageMemoryUsage");
            this.m_average_value_metrics.add("IRGenAverageCPUUsage");
            this.m_average_value_metrics.add("AnalysisAverageMemoryUsage");
        }
        return this.m_average_value_metrics;
    }

    protected HashSet<String> getHighestValueMetrics() {
        if (this.m_highest_value_metrics == null) {
            this.m_highest_value_metrics = new HashSet();
            this.m_highest_value_metrics.add("IRGenPeakMemoryUsage");
            this.m_highest_value_metrics.add("IRGenPeakCPUUsage");
            this.m_highest_value_metrics.add("AnalysisPeakMemoryUsage");
            this.m_highest_value_metrics.add("ScanWeightValue");
        }
        return this.m_highest_value_metrics;
    }

    public HashSet<String> getStringListMetrics() {
        if (this.m_string_list_metrics == null) {
            this.m_string_list_metrics = new HashSet();
            this.m_string_list_metrics.add("Languages");
            this.m_string_list_metrics.add("Language");
        }
        return this.m_string_list_metrics;
    }

    protected HashSet<String> getLowestValueMetrics() {
        if (this.m_lowest_value_metrics == null) {
            this.m_lowest_value_metrics = new HashSet();
            this.m_lowest_value_metrics.add("PercentageAvailDiskSpace");
            this.m_lowest_value_metrics.add("AvailableDiskSpaceGB");
            this.m_lowest_value_metrics.add("AvailableDiskSpaceBytes");
        }
        return this.m_lowest_value_metrics;
    }
}

