/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.model.xml;

import com.ibm.appscan.common.model.IScanFile;
import com.ibm.appscan.common.model.xml.IModelXMLConstants;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.common.xml.XMLFileReader;
import com.ibm.appscan.internal.common.model.ScanFile;
import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;

public class TargetInfoReader
extends XMLFileReader
implements IModelXMLConstants {
    private boolean m_transformed;
    private String m_name;
    private String m_type;
    private String m_path;
    private String m_strategy;
    private String m_languageType;
    private String m_fileDir;
    private Set<String> m_targetInfos = new HashSet<String>();
    private Map<String, String> m_buildInfos = new Hashtable<String, String>();
    private Set<IScanFile> m_files = new HashSet<IScanFile>();
    private boolean m_processedRoot = false;

    public TargetInfoReader(File file) {
        super(file);
        this.m_fileDir = file.getAbsolutePath();
        this.m_transformed = new File(file.getParentFile(), ".transformed").exists();
    }

    private void processTarget(StartElement element) {
        this.m_name = this.getAttribute(element, "name");
        this.m_type = this.getAttribute(element, "type");
        this.m_path = this.getAttribute(element, "path");
        this.m_strategy = this.getAttribute(element, "strategy");
        this.m_languageType = this.getAttribute(element, "language_type");
        this.m_processedRoot = true;
    }

    private void processChildTarget(StartElement element) {
        String path = this.getAttribute(element, "working_directory");
        if (path != null) {
            this.m_targetInfos.add(path + '/' + ".targetinfo");
        }
    }

    private void processBuildInfo(StartElement element) {
        Iterator<Attribute> iter = element.getAttributes();
        while (iter.hasNext()) {
            Attribute attribute = iter.next();
            this.m_buildInfos.put(attribute.getName().getLocalPart(), attribute.getValue());
        }
    }

    private void processScanFile(StartElement element) {
        String path = this.getAttribute(element, "analysis_path");
        if (path != null) {
            this.m_files.add(new ScanFile(PathUtil.replaceBackslashes(path), this.getAttribute(element, "src_path"), this.getAttribute(element, "checksum")));
        }
    }

    @Override
    protected boolean process(StartElement element) {
        String name = element.getName().getLocalPart();
        if ("Target".equals(name)) {
            if (this.m_processedRoot) {
                this.processChildTarget(element);
            } else {
                this.processTarget(element);
            }
        } else if (this.m_transformed && "BuildInfo".equals(name)) {
            this.processBuildInfo(element);
        } else if ("ScanFile".equals(name)) {
            this.processScanFile(element);
        }
        return true;
    }

    public boolean isTransformed() {
        return this.m_transformed;
    }

    public String getName() {
        return this.m_name;
    }

    public String getType() {
        return this.m_type;
    }

    public String getPath() {
        return this.m_path;
    }

    public String getStrategy() {
        return this.m_strategy;
    }

    public String getLanguageType() {
        return this.m_languageType;
    }

    public Set<String> getTargetInfos() {
        return this.m_targetInfos;
    }

    public Map<String, String> getBuildInfos() {
        return this.m_buildInfos;
    }

    public Set<IScanFile> getScanFiles() {
        return this.m_files;
    }

    public String getFileDir() {
        return this.m_fileDir;
    }
}

