/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.utils;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public class CryptoUtils {
    public static final String RSA_PUB_FILENAME = "rsa.pub";
    private static final String PUBLIC_KEY_CERT_FILENAME = "publicKey.cert";
    private static final String PRIVATE_KEY_STORE_FILENAME = "privateKey.store";
    private static final String AES_KEY_DIRECTORY_PATH = System.getProperty("user.home") + File.separator + ".hcl";
    private static final String AES_KEY_PATH = AES_KEY_DIRECTORY_PATH + File.separator + "temp.dat";
    private static boolean FIPS_ENABLED = false;
    private static final int READ_BUFFER_SIZE = 8192;
    private static final String KEY_HASH_ALGORITHM = "SHA-256";
    private static final String AES_CIPHER_ALGORITHM = "AES";
    private static final String RSA_CIPHER_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private static final String CHECKSUM_ALGORITHM = "SHA-256";

    public static byte[] aesEncrypt(byte[] data, Key key) throws NoSuchAlgorithmException, IOException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException {
        if (key == null) {
            key = CryptoUtils.generateAesKey();
            CryptoUtils.writeAesKey(key);
        }
        return CryptoUtils.doCrypt(1, data, key, AES_CIPHER_ALGORITHM);
    }

    public static byte[] aesDecrypt(byte[] data, Key key) throws NoSuchAlgorithmException, IOException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException {
        if (key == null) {
            key = CryptoUtils.readAesKey();
        }
        return CryptoUtils.doCrypt(2, data, key, AES_CIPHER_ALGORITHM);
    }

    private static Key generateAesKey() throws NoSuchAlgorithmException, NoSuchProviderException {
        SecureRandom rand = new SecureRandom();
        KeyGenerator generator = FIPS_ENABLED ? KeyGenerator.getInstance(AES_CIPHER_ALGORITHM, "BCFIPS") : KeyGenerator.getInstance(AES_CIPHER_ALGORITHM);
        generator.init(128, rand);
        return generator.generateKey();
    }

    private static void writeAesKey(Key key) throws IOException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException {
        File appscanDirectoryFile = new File(AES_KEY_DIRECTORY_PATH);
        if (!appscanDirectoryFile.exists()) {
            new File(AES_KEY_DIRECTORY_PATH).mkdir();
        }
        Path aesKeyPath = new File(AES_KEY_PATH).toPath();
        byte[] encodedKey = key.getEncoded();
        byte[] obfuscatedKey = CryptoUtils.obfuscateData(encodedKey);
        Files.write(aesKeyPath, obfuscatedKey, new OpenOption[0]);
    }

    private static Key readAesKey() throws IOException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException {
        Path aesKeyPath = new File(AES_KEY_PATH).toPath();
        byte[] obfuscatedKey = Files.readAllBytes(aesKeyPath);
        byte[] unobfuscatedKey = CryptoUtils.unobfuscateData(obfuscatedKey);
        SecretKeySpec key = new SecretKeySpec(unobfuscatedKey, AES_CIPHER_ALGORITHM);
        return key;
    }

    private static byte[] obfuscateData(byte[] data) throws NoSuchAlgorithmException, IOException, InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException {
        return CryptoUtils.doCrypt(1, data, CryptoUtils.getObfuscationKey(), AES_CIPHER_ALGORITHM);
    }

    private static byte[] unobfuscateData(byte[] data) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, IOException, NoSuchProviderException {
        return CryptoUtils.doCrypt(2, data, CryptoUtils.getObfuscationKey(), AES_CIPHER_ALGORITHM);
    }

    private static Key getObfuscationKey() throws NoSuchAlgorithmException, IOException {
        String commonChecksum = CryptoUtils.getCheckSum(CommonCore.getBuildManager().getBuilderTypes().getClass().toString());
        String checksum = CryptoUtils.getCheckSum(SystemUtil.getMachineSerialNumber() + SystemUtil.getMachineUID() + commonChecksum);
        return CryptoUtils.buildKey(checksum);
    }

    public static byte[] aesEncrypt(byte[] data) throws IOException, GeneralSecurityException {
        return CryptoUtils.aesEncrypt(data, null);
    }

    public static byte[] aesDecrypt(byte[] data) throws IOException, GeneralSecurityException {
        return CryptoUtils.aesDecrypt(data, null);
    }

    public static Key buildKey(String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digester = MessageDigest.getInstance("SHA-256");
        digester.update(password.getBytes("UTF-8"));
        byte[] key = digester.digest();
        if (key.length > 16) {
            byte[] part = new byte[16];
            System.arraycopy(key, 0, part, 0, 16);
            key = part;
        }
        SecretKeySpec spec = new SecretKeySpec(key, AES_CIPHER_ALGORITHM);
        return spec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCheckSum(File file) throws NoSuchAlgorithmException, IOException {
        String checksum = null;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        try (FilterInputStream dis = null;){
            dis = new DigestInputStream(new FileInputStream(file), md);
            int read = 0;
            while (read >= 0) {
                byte[] block = new byte[8192];
                read = dis.read(block);
            }
            byte[] digest = md.digest();
            checksum = String.format("%0" + (digest.length << 1) + "x", new BigInteger(1, digest));
        }
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressSecurityTrace
    public static String getCheckSum(String str) throws NoSuchAlgorithmException, IOException {
        String checksum = null;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        try (FilterInputStream dis = null;){
            dis = new DigestInputStream(new ByteArrayInputStream(str.getBytes()), md);
            int read = 0;
            while (read >= 0) {
                byte[] block = new byte[8192];
                read = dis.read(block);
            }
            byte[] digest = md.digest();
            checksum = String.format("%0" + (digest.length << 1) + "x", new BigInteger(1, digest));
        }
        return checksum;
    }

    static boolean canEncrypt() {
        return new File(CommonCore.getDirectoryLocator().getConfig() + RSA_PUB_FILENAME).isFile() || new File(CommonCore.getDirectoryLocator().getConfig() + PUBLIC_KEY_CERT_FILENAME).isFile();
    }

    @SuppressSecurityTrace
    public static Key buildPublicKey(BigInteger modulus, BigInteger exponent) throws GeneralSecurityException {
        KeyFactory fact = KeyFactory.getInstance("RSA");
        RSAPublicKeySpec keySpec = new RSAPublicKeySpec(modulus, exponent);
        return fact.generatePublic(keySpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Key readPublicKey(String path) throws IOException, GeneralSecurityException {
        BigInteger e;
        BigInteger m;
        try (BufferedReader reader = new BufferedReader(new FileReader(path));){
            m = new BigInteger(1, DatatypeConverter.parseBase64Binary((String)reader.readLine()));
            e = new BigInteger(1, DatatypeConverter.parseBase64Binary((String)reader.readLine()));
        }
        return CryptoUtils.buildPublicKey(m, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Key readPublicKeyCert() throws IOException, CertificateException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(CommonCore.getDirectoryLocator().getConfig() + PUBLIC_KEY_CERT_FILENAME)));
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            Certificate certificate = factory.generateCertificate(bis);
            PublicKey publicKey = certificate.getPublicKey();
            return publicKey;
        }
        finally {
            IOUtil.close(bis);
        }
    }

    public static byte[] rsaEncrypt(byte[] data, Key key) throws IOException, GeneralSecurityException {
        if (key == null) {
            String publicKeyPath = CommonCore.getDirectoryLocator().getConfig() + RSA_PUB_FILENAME;
            File publicKey = new File(publicKeyPath);
            key = publicKey.isFile() ? CryptoUtils.readPublicKey(publicKeyPath) : CryptoUtils.readPublicKeyCert();
        }
        return CryptoUtils.doCrypt(1, data, key, RSA_CIPHER_ALGORITHM);
    }

    public static byte[] rsaEncrypt(byte[] data) throws IOException, GeneralSecurityException {
        return CryptoUtils.rsaEncrypt(data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readPassword() throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(CommonCore.getDirectoryLocator().getConfig() + "agent.apsettings"));
        try {
            reader.readLine();
            reader.readLine();
            String pc = reader.readLine();
            String pw = "";
            for (int i = 0; i < pc.length(); ++i) {
                pw = pw + (pc.charAt(i) + (i == 0 ? 118 : (int)pc.charAt(i - 1)) ^ 0x8209);
            }
            String string = pw;
            return string;
        }
        finally {
            IOUtil.close(reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Key readPrivateKeyStore(String keyID) throws IOException, GeneralSecurityException {
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(CommonCore.getDirectoryLocator().getConfig() + PRIVATE_KEY_STORE_FILENAME)));
        char[] password = CryptoUtils.readPassword().toCharArray();
        try {
            KeyStore ks = FIPS_ENABLED ? KeyStore.getInstance("JKS", "BCFIPS") : KeyStore.getInstance("JKS");
            ks.load(bis, password);
            Key key = ks.getKey(keyID, password);
            return key;
        }
        finally {
            IOUtil.close(bis);
        }
    }

    static byte[] rsaDecrypt(byte[] data, Key key) throws IOException, GeneralSecurityException {
        return CryptoUtils.doCrypt(2, data, key, RSA_CIPHER_ALGORITHM);
    }

    public static byte[] rsaDecrypt(byte[] data, String keyID) throws IOException, GeneralSecurityException {
        Key key = CryptoUtils.readPrivateKeyStore(keyID);
        return CryptoUtils.rsaDecrypt(data, key);
    }

    public static byte[] doCrypt(int cipherMode, byte[] data, Key key, String algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException {
        Cipher cipher = CryptoUtils.getCipher(algorithm);
        cipher.init(cipherMode, key);
        return cipher.doFinal(data);
    }

    public static Cipher getCipher(String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Cipher cipher = FIPS_ENABLED && !algorithm.contains("RSA") ? Cipher.getInstance(algorithm, "BCFIPS") : Cipher.getInstance(algorithm);
        return cipher;
    }

    public static void enableFips() {
        FIPS_ENABLED = true;
    }
}

