/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.common.model;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IConsole;
import com.ibm.appscan.common.utils.StringUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

public class Console
implements IConsole {
    private ILogManager m_logManager = CommonCore.getLogManager();
    private BufferedReader m_in;
    private PrintWriter m_out;
    private OutputStream m_err;
    private int m_logLevel = 3;

    public Console() {
        java.io.Console console = System.console();
        if (console == null) {
            this.setInputSource(System.in);
            this.setOutputTarget(System.out);
        } else {
            this.m_in = new BufferedReader(console.reader());
            this.m_out = console.writer();
        }
        this.m_err = System.err;
    }

    @Override
    public void setInputSource(InputStream in) {
        try {
            this.m_in = new BufferedReader(new InputStreamReader(in, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            this.m_logManager.log(new Message(e));
        }
    }

    @Override
    public void setOutputTarget(OutputStream out) {
        this.m_out = new PrintWriter(out);
    }

    @Override
    public void setErrorTarget(OutputStream err) {
        this.m_err = err;
    }

    @Override
    public void setLogLevel(int logLevel) {
        this.m_logLevel = logLevel;
    }

    @Override
    public PrintWriter getPrintWriter() {
        return this.m_out;
    }

    @Override
    public void print(String message) {
        if (message != null) {
            message = StringUtil.tagMessage(message, 1);
            this.m_out.write(message);
            this.m_out.flush();
        }
    }

    @Override
    public void print(Message message) {
        String msg = message.getText();
        int sev = message.getSeverity();
        if (msg != null) {
            msg = StringUtil.tagMessage(msg, sev);
            try {
                if (sev == 4) {
                    this.m_err.write(msg.getBytes());
                    this.m_err.flush();
                } else if (SystemUtil.isCommonEngine() || sev >= this.m_logLevel) {
                    this.m_out.write(msg);
                    this.m_out.flush();
                }
            }
            catch (IOException e) {
                this.m_logManager.log(new Message(e));
            }
        }
    }

    @Override
    public String readInput() {
        String input = null;
        try {
            input = this.m_in.readLine();
        }
        catch (IOException e) {
            this.m_logManager.log(new Message(e));
        }
        return input;
    }

    @Override
    public void println(String message) {
        this.print(message + "\n");
    }

    @Override
    public void println(Message message) {
        if (message.getText() != null) {
            this.print(new Message(message.getSeverity(), message.getText() + "\n"));
        }
    }

    @Override
    public void close() {
        try {
            if (this.m_in != null) {
                this.m_in.close();
            }
            if (this.m_out != null) {
                this.m_out.close();
            }
        }
        catch (IOException e) {
            this.m_logManager.log(new Message(e));
        }
    }
}

