/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.common.model;

import com.ibm.appscan.common.error.IErrorManager;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.model.CustomTargetInfo;
import com.ibm.appscan.common.model.IBuildInfo;
import com.ibm.appscan.common.model.IBuildInfoManager;
import com.ibm.appscan.common.model.IScanModelVisitable;
import com.ibm.appscan.common.model.IScanTarget;
import com.ibm.appscan.common.model.IScanTargetCollector;
import com.ibm.appscan.common.model.IScanTargetProxy;
import com.ibm.appscan.common.model.SaveLocation;
import com.ibm.appscan.common.model.ScanModelVisitor;
import com.ibm.appscan.common.model.ScanTargetStrategy;
import com.ibm.appscan.common.model.StringPattern;
import com.ibm.appscan.common.model.validation.IValidationIssue;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.internal.common.model.BuildInfo;
import com.ibm.appscan.internal.common.model.BuildInfoManager;
import com.ibm.appscan.internal.common.model.BuildInfoProxy;
import com.ibm.appscan.internal.common.model.ScanTarget;
import com.ibm.appscan.internal.common.model.TransientStringPattern;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class ScanTargetProxy
implements IScanTargetProxy,
IScanModelVisitable {
    protected ScanTarget m_target;
    protected IScanTargetCollector m_collector;
    private BuildInfoProxy m_buildInfo;
    private Map<String, Object> m_properties = new Hashtable<String, Object>();
    private int m_count = 0;

    ScanTargetProxy(ScanTarget target, IScanTargetCollector collector) {
        this.m_target = target;
        this.m_collector = collector;
        this.m_buildInfo = this.m_target.getBuildInfoManager() == null ? new BuildInfoProxy(new BuildInfoManager(this.m_target)) : new BuildInfoProxy(this.m_target.getBuildInfoManager());
    }

    private CustomTargetInfo getCustomTargetInfo() {
        return this.m_target.getScan().getCustomTargetInfo(this.getPath());
    }

    private boolean matchFound(String path, Set<StringPattern> set) {
        for (StringPattern pattern : set) {
            if (!this.m_target.getAdjustedPattern(pattern).matches(path)) continue;
            return true;
        }
        return false;
    }

    protected ScanTarget createScanTarget(ScanTargetStrategy strategy) {
        ScanTarget target = this.m_target.newScanTarget(strategy);
        this.m_collector.add(target);
        ++this.m_count;
        return target;
    }

    private ScanTarget internalCreateScanTarget(ScanTargetStrategy strategy, boolean checkExclusions) {
        ScanTarget newTarget;
        if (checkExclusions && !this.m_target.handlesIncludesExcludes()) {
            String path = strategy.getPath();
            CustomTargetInfo info = this.getCustomTargetInfo();
            Set<StringPattern> includes = info.getIncludes();
            if (!includes.isEmpty() && !this.matchFound(path, includes)) {
                this.m_target.newChildScanTarget(strategy, true);
                return null;
            }
            if (this.matchFound(path, info.getExcludes())) {
                this.m_target.newChildScanTarget(strategy, true);
                return null;
            }
        }
        if ((newTarget = this.createScanTarget(strategy)) != null && newTarget.getBuildInfoManager() != null) {
            this.setInheritedIncludesExcludes(newTarget, this.getCustomTargetInfo());
        }
        return newTarget;
    }

    @Override
    public final boolean newScanTarget(ScanTargetStrategy strategy) {
        return this.internalCreateScanTarget(strategy, true) != null;
    }

    @Override
    public final boolean newScanTargetSkipScanTargetExclusionCheck(ScanTargetStrategy strategy) {
        ScanTarget newTarget = this.internalCreateScanTarget(strategy, false);
        return newTarget != null;
    }

    @Override
    public final boolean newScanTarget(ScanTargetStrategy strategy, CustomTargetInfo info) {
        ScanTarget newTarget = this.internalCreateScanTarget(strategy, true);
        if (newTarget != null && newTarget.getBuildInfoManager() != null) {
            BuildInfo buildInfo = newTarget.getBuildInfoManager().m_buildInfo;
            for (Map.Entry<String, String> entry : info.getBuildInfos().entrySet()) {
                buildInfo.setReadOnlyProperty(entry.getKey(), entry.getValue());
            }
            this.m_target.getScan().fireScanTargetAdded(newTarget);
            return true;
        }
        return false;
    }

    @Override
    public String getPath() {
        return this.m_target.getPath();
    }

    @Override
    public File getWorkingDirectory() {
        return this.m_target.getWorkingDirectory();
    }

    @Override
    public File getScanHome() {
        SaveLocation location = this.m_target.getScan().getSaveLocation();
        return location == null ? null : location.getWorkLocation();
    }

    @Override
    public IBuildInfo getBuildInfo() {
        return this.m_buildInfo;
    }

    private String findValue(IScanTarget start, String key) {
        IScanTarget current;
        for (current = start; current != null; current = current.getParent()) {
            IBuildInfoManager mgr = current.getBuildInfoManager();
            if (mgr == null || !mgr.isUserEdited(key)) continue;
            return mgr.getProperty(key);
        }
        for (current = start; current != null && current.getBuildInfoManager() != null; current = current.getParent()) {
            String value = current.getBuildInfoManager().getDiscoveredProperty(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public void inheritedSetBuildInfo(String key, String value) {
        String parentValue = this.findValue(this.m_target.getParent(), key);
        if (parentValue != null) {
            this.m_buildInfo.getInnerBuildInfo().m_map.put(key, parentValue);
        } else if (value != null) {
            this.m_buildInfo.setProperty(key, value);
        }
    }

    @Override
    public String inheritedGetBuidInfo(String key) {
        return this.findValue(this.m_target, key);
    }

    @Override
    public Set<StringPattern> getIncludes() {
        return Collections.unmodifiableSet(this.getCustomTargetInfo().getIncludes());
    }

    @Override
    public Set<StringPattern> getExcludes() {
        return Collections.unmodifiableSet(this.getCustomTargetInfo().getExcludes());
    }

    @Override
    public IErrorManager getErrorManager() {
        return this.m_target.getErrorManager();
    }

    @Override
    public ILogManager getLogManager() {
        return this.m_target.getScan().getLogManager();
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.m_properties;
    }

    @Override
    public void flagScanIncomplete(boolean incomplete) {
        this.m_target.getScan().m_incomplete = incomplete;
    }

    @Override
    public void setLanguageType(String lang) {
        this.m_target.m_languageType = lang;
    }

    public int getCount() {
        return this.m_count;
    }

    @Override
    public IScanModelVisitable getParent() {
        IScanTarget parent = this.m_target.getParent();
        return parent == null ? this.m_target.getScan() : parent;
    }

    @Override
    public void accept(ScanModelVisitor visitor) {
        this.m_target.accept(visitor);
    }

    @Override
    public Collection<IValidationIssue> getValidationIssues() {
        return this.m_target.getValidationIssues();
    }

    @Override
    public Collection<String> getNameSpaces() {
        return this.m_target.getNameSpaces();
    }

    private void setInheritedIncludesExcludes(IScanTarget newTarget, CustomTargetInfo info) {
        CustomTargetInfo newInfo = this.m_target.getScan().getCustomTargetInfo(newTarget.getPath());
        for (StringPattern pattern : info.getExcludes()) {
            newInfo.getExcludes().add(new TransientStringPattern(pattern.toString()));
        }
    }

    @Override
    public String getSourceAbsolutePath(String relative_directory) {
        File ret = this.getSourceAbsolutePath("src_root", relative_directory);
        if (ret != null) {
            return ret.getAbsolutePath();
        }
        ret = this.getSourceAbsolutePath("web_content_dir", relative_directory);
        if (ret != null) {
            return ret.getAbsolutePath();
        }
        return relative_directory;
    }

    private File getSourceAbsolutePath(String property, String relative_path) {
        File ret = null;
        if (SystemUtil.isCommonEngine()) {
            File realtive_directory = new File(relative_path);
            if (this.getBuildInfo().getProperty(property) != null) {
                for (String path : this.getBuildInfo().getProperty(property).split(File.pathSeparator)) {
                    ret = FileUtil.getFilesGivenRootAndRelativePath(new File(path), realtive_directory, "_staging");
                    if (ret == null) continue;
                    return ret;
                }
            }
        }
        return ret;
    }

    @Override
    public boolean isExcludedTarget() {
        return this.m_target.isExcluded();
    }
}

