/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.command;

import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.andromeda.lang.ILangServices;
import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.VerificationMonitor;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraphBuilderCancelException;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.stringAnalysis.sanitizerDetection.command.ISaProgress;
import com.ibm.wala.stringAnalysis.sanitizerDetection.command.SanitizerDetector;
import com.ibm.wala.stringAnalysis.sanitizerDetection.diagnostics.TimedSection;
import com.ibm.wala.stringAnalysis.sanitizerDetection.diagnostics.Timing;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SAConfig;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SALogger;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.SASpec;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.ScopeUtil;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.StringAnalysisStatus;
import com.ibm.wala.stringAnalysis.sanitizerDetection.util.TimingData;
import com.ibm.wala.stringAnalysis.sanitizerDetection.wafl.WAFLMarshaller;
import com.ibm.wala.stringAnalysis.util.SAUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import org.eclipse.core.runtime.IProgressMonitor;

public class StandaloneSaAnalyzer {
    private static final Logger logger = SALogger.logger;

    public static ISaProgress emptySaProgress() {
        return new ISaProgress(){

            @Override
            public void setProgressMonitor(IProgressMonitor progressMonitor) {
            }

            @Override
            public void setNumberOfProjects(int numberOfProjects) {
            }

            @Override
            public void setNumberOfCandidates(int numberOfCandidates) {
            }

            @Override
            public void setCurrentProject(String projectName) {
            }

            @Override
            public void setCurrentCandidate(String candidateSignature) {
            }
        };
    }

    public static StringAnalysisStatus analyzeProject(String projectName, ILangServices langServices, AnalysisScope scope, SAConfig.SAType saType, Collection<SASpec> illegalPatterns, Collection<String> candidates, ISaProgress saProgress, VerificationMonitor monitor, Logger logger) throws IOException, ClassHierarchyException {
        logger.info((Object)("Analyzing project: " + projectName));
        SanitizerDetector detector = new SanitizerDetector(projectName, scope, langServices, saType, saProgress, monitor, logger);
        detector.setCandidates(candidates);
        StringAnalysisStatus stat = new StringAnalysisStatus(projectName, illegalPatterns);
        detector.findSanitizers(stat);
        return stat;
    }

    public static void printStringAnalysisStatus(StringAnalysisStatus stat, File outputFile, SAConfig.OutputFormat outputFormat) {
        switch (outputFormat) {
            case XML: {
                try {
                    WAFLMarshaller.marshal(stat.getResult(), new FileOutputStream(outputFile));
                }
                catch (JAXBException e) {
                    e.printStackTrace();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                break;
            }
            case CSV: {
                try {
                    stat.printReport(new PrintWriter(outputFile));
                    break;
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void logTimingData(File outputDir, String applicationName) {
        Timing.i().logReport();
        TimingData timingData = TimingData.createFromTiming(Timing.i());
        File timingOutFile = new File(outputDir, TimingData.getTimingFile(applicationName));
        try {
            timingData.writeToFile(timingOutFile);
        }
        catch (FileNotFoundException e) {
            logger.warn((Object)("Can't write timing output to " + timingOutFile));
        }
        Timing.i().clearTimers();
    }

    public static void main(String[] args) throws IOException, ClassHierarchyException, IllegalArgumentException, CallGraphBuilderCancelException {
        SAConfig config = new SAConfig();
        config.parseCommandLine(args);
        StandaloneSaAnalyzer.setupLogger(config);
        File scopeFile = config.getScopeFile();
        Collection<SASpec> patterns = config.getPatterns();
        SAConfig.SAType saType = config.getSAType();
        ILangServices lang = config.getLangServices();
        File outputDir = config.getOutputDir();
        File outputFile = config.getOutputFile();
        SAConfig.OutputFormat outputFormat = config.getOutputFormat();
        String appName = config.getApplicationName();
        Collection<String> candidates = config.getCandidates();
        VerificationMonitor monitor = new VerificationMonitor(config.getTimeLimit() * 1000L);
        Logger logger = TaintLogger.i().getLogger();
        AnalysisScope scope = ScopeUtil.getScope(scopeFile, lang.getLanguage(), config.getExclusionFile());
        Timing.i().startedSection(TimedSection.Total);
        StringAnalysisStatus stat = StandaloneSaAnalyzer.analyzeProject(appName, lang, scope, saType, patterns, candidates, StandaloneSaAnalyzer.emptySaProgress(), monitor, logger);
        Timing.i().finishedSection(TimedSection.Total);
        StandaloneSaAnalyzer.printStringAnalysisStatus(stat, outputFile, outputFormat);
        StandaloneSaAnalyzer.logTimingData(outputDir, appName);
    }

    private static void setupLogger(SAConfig config) throws FactoryConfigurationError {
        File log4jConfigFile = config.getLog4JConfigFile();
        DOMConfigurator.configure((String)log4jConfigFile.getAbsolutePath());
        SAUtil.setDebugPrinter((AUtil.IDebugPrinter)new AUtil.IDebugPrinter(){
            private final StringBuffer buff = new StringBuffer();

            public void print(String s) {
                if (SAUtil.DEBUG) {
                    this.buff.append(s);
                }
            }

            public void println(String s) {
                if (SAUtil.DEBUG) {
                    this.buff.append(s);
                    logger.debug((Object)this.buff.toString());
                    this.buff.delete(0, this.buff.length());
                }
            }
        });
    }
}

