/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.driver;

import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.samso.client.IPathVerifier;
import com.ibm.wala.stringAnalysis.client.IGrammarBasedStringAnalyzer;
import com.ibm.wala.stringAnalysis.client.IStringVerifier;
import com.ibm.wala.stringAnalysis.grammar.GR;
import com.ibm.wala.stringAnalysis.sanitizerDetection.driver.IStringAnalyzerProvider;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.util.MonitorUtil;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class MultiLanguageStringAnalyzerProvider<T>
implements IStringAnalyzerProvider<T> {
    private final Map<Language, IStringAnalyzerProvider<T>> providerMap;
    private final Language language;

    public MultiLanguageStringAnalyzerProvider(Language language) {
        this.language = language;
        this.providerMap = this.initializeMap();
    }

    protected abstract Map<Language, IStringAnalyzerProvider<T>> initializeMap();

    @Override
    public IGrammarBasedStringAnalyzer<T> createStringAnalyzer(CallGraph cg, CGNode n, AnalysisOptions opts, ITranslatorRepository<T> repo, Map<CGNode, GR> grCache, MonitorUtil.IProgressMonitor monitor, Logger logger) {
        return this.providerMap.get(this.language).createStringAnalyzer(cg, n, opts, repo, grCache, monitor, logger);
    }

    @Override
    public IStringVerifier<T, IVariable> createStringVerifier(IGrammarBasedStringAnalyzer<T> sa, MonitorUtil.IProgressMonitor monitor) {
        return this.providerMap.get(this.language).createStringVerifier(sa, monitor);
    }

    @Override
    public ITranslatorRepository<T> createTranslatorRepository() {
        return this.providerMap.get(this.language).createTranslatorRepository();
    }

    @Override
    public IPathVerifier createPathVerifier(IGrammarBasedStringAnalyzer<T> sa, MonitorUtil.IProgressMonitor monitor, Logger logger) {
        return this.providerMap.get(this.language).createPathVerifier(sa, monitor, logger);
    }
}

