/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.driver;

import com.ibm.wala.stringAnalysis.sanitizerDetection.driver.IBackwardPropagation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class OfflineBackwardPropagation
implements IBackwardPropagation {
    private final Map<String, Map<Integer, List<Integer>>> M = new HashMap<String, Map<Integer, List<Integer>>>();
    static int RET = -1;
    static int NONE = 0;

    public OfflineBackwardPropagation(InputStream is) {
        this.loadPropagation(this.M, is);
    }

    public static OfflineBackwardPropagation loadFromResource(String resourceName) {
        InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream(resourceName);
        return new OfflineBackwardPropagation(is);
    }

    private static int parseNumber(String vstr) {
        int i = vstr.indexOf(".");
        if (i > 0) {
            vstr = vstr.substring(0, i);
        }
        if (vstr.equals("ret")) {
            return RET;
        }
        if (vstr.startsWith("v")) {
            vstr = vstr.substring(1, vstr.length());
            return Integer.parseInt(vstr) - 1;
        }
        if (vstr.equals("none")) {
            return NONE;
        }
        assert (false) : "illegal format: " + vstr;
        return NONE;
    }

    protected void loadPropagation(Map<String, Map<Integer, List<Integer>>> M, InputStream is) {
        Pattern whiteSpaces = Pattern.compile("\\s+");
        BufferedReader rd = new BufferedReader(new InputStreamReader(is));
        try {
            String line = rd.readLine();
            while (line != null) {
                if (line.startsWith("#")) {
                    line = rd.readLine();
                    continue;
                }
                if (line.startsWith("METHOD")) {
                    line = rd.readLine();
                    continue;
                }
                String[] strs = whiteSpaces.split(line);
                if (strs.length == 3) {
                    List<Integer> l;
                    String sig = strs[0];
                    String src = strs[1];
                    String dst = strs[2];
                    int vdst = OfflineBackwardPropagation.parseNumber(dst);
                    int vsrc = OfflineBackwardPropagation.parseNumber(src);
                    Map<Integer, List<Integer>> m = M.get(sig);
                    if (m == null) {
                        m = new HashMap<Integer, List<Integer>>();
                        M.put(sig, m);
                    }
                    if ((l = m.get(vdst)) == null) {
                        l = new LinkedList<Integer>();
                        m.put(vdst, l);
                    }
                    l.add(vsrc);
                }
                line = rd.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean hasPropagation(String sig) {
        return this.M.containsKey(sig);
    }

    @Override
    public List<Integer> propagate(String sig, int nUses, int n) {
        Map<Integer, List<Integer>> m = this.M.get(sig);
        if (m != null && m.containsKey(n)) {
            return m.get(n);
        }
        return Collections.emptyList();
    }
}

