/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.driver;

import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.impl.PartialCallGraph;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.stringAnalysis.grammar.GR;
import com.ibm.wala.stringAnalysis.java.client.JavaStringAnalyzer;
import com.ibm.wala.stringAnalysis.java.translator.JavaIR2GR;
import com.ibm.wala.stringAnalysis.sanitizerDetection.driver.CustomPathSensitiveIR2GR;
import com.ibm.wala.stringAnalysis.sanitizerDetection.driver.JavaStorelessSymbolFactory;
import com.ibm.wala.stringAnalysis.translator.CG2Grammar;
import com.ibm.wala.stringAnalysis.translator.IBB2Grammar;
import com.ibm.wala.stringAnalysis.translator.ICG2Grammar;
import com.ibm.wala.stringAnalysis.translator.IIR2Grammar;
import com.ibm.wala.stringAnalysis.translator.ISSA2Rule;
import com.ibm.wala.stringAnalysis.translator.ISymbolFactory;
import com.ibm.wala.stringAnalysis.translator.ITranslatorRepository;
import com.ibm.wala.stringAnalysis.translator.PathSensitiveBB2GR;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class PathSensitiveJavaStringAnalyzer<T>
extends JavaStringAnalyzer<T> {
    protected static CallGraph createPartialCallGraph(CallGraph cg, CGNode n) {
        HashSet<CGNode> nodes = new HashSet<CGNode>();
        nodes.add(n);
        Set reachableNodes = DFS.getReachableNodes((Graph)cg, nodes);
        IClass klass = n.getMethod().getDeclaringClass();
        IMethod initMethod = klass.getClassInitializer();
        if (initMethod != null) {
            Set initNodes = cg.getNodes(initMethod.getReference());
            reachableNodes.addAll(initNodes);
        }
        PartialCallGraph pcg = PartialCallGraph.make((CallGraph)cg, nodes, (Collection)reachableNodes);
        return pcg;
    }

    public PathSensitiveJavaStringAnalyzer(CallGraph cg, PointerAnalysis pa, IClassHierarchy cha, MonitorUtil.IProgressMonitor monitor, Logger logger) {
        super(cg, pa, cha, monitor, logger);
    }

    protected abstract Map<CGNode, GR> getCache();

    protected ICG2Grammar<T> createCG2GR(IIR2Grammar<T> ir2gr) {
        return new CG2Grammar(ir2gr, this.monitor, this.logger);
    }

    protected IIR2Grammar<T> createIR2GR(IBB2Grammar<T> bb2gr) {
        JavaIR2GR base = new JavaIR2GR(bb2gr);
        CustomPathSensitiveIR2GR p = new CustomPathSensitiveIR2GR(base, this.getCache());
        return p;
    }

    protected IBB2Grammar<T> createBaseBB2GR(ISSA2Rule<T> ssa2rule) {
        return super.createBB2GR(ssa2rule);
    }

    protected IBB2Grammar<T> createBB2GR(ISSA2Rule<T> ssa2rule) {
        return new PathSensitiveBB2GR(this.createBaseBB2GR(ssa2rule));
    }

    protected ISymbolFactory<T> createSymbolFactory(ITranslatorRepository<T> repository, IVariableFactory<IVariable> varFactory) {
        return new JavaStorelessSymbolFactory<T>(repository, varFactory);
    }
}

