/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class FileUtil {
    private static int BUFF_SIZE = 256;

    public static File createTempFileForResource(String resourceName) throws IOException {
        File file = File.createTempFile("resource", "txt");
        FileOutputStream out = new FileOutputStream(file);
        InputStream in = ClassLoader.getSystemResourceAsStream(resourceName);
        byte[] buff = new byte[BUFF_SIZE];
        int nbyte = in.read(buff);
        while (nbyte >= 0) {
            ((OutputStream)out).write(buff, 0, nbyte);
            nbyte = in.read(buff);
        }
        ((OutputStream)out).close();
        in.close();
        return file;
    }

    public static ArrayList<File> findFiles(File rootFile, String extension) {
        if (!rootFile.canRead()) {
            return new ArrayList<File>();
        }
        if (rootFile.isDirectory()) {
            File[] files;
            ArrayList<File> results = new ArrayList<File>();
            for (File file : files = rootFile.listFiles()) {
                results.addAll(FileUtil.findFiles(file, extension));
            }
            return results;
        }
        if (rootFile.isFile() && rootFile.getName().toLowerCase().endsWith(extension)) {
            ArrayList<File> rc = new ArrayList<File>();
            rc.add(rootFile);
            return rc;
        }
        return new ArrayList<File>();
    }
}

