/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.stringAnalysis.sanitizerDetection.util;

import com.ibm.wala.andromeda.lang.ILangServices;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.Atom;
import com.ibm.wala.util.strings.StringStuff;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class SignatureUtil {
    public static IClass getDeclaringClass(String sig, IClassHierarchy cha) {
        String declaringClass = sig.substring(0, sig.lastIndexOf("..") == -1 ? sig.lastIndexOf(46) : sig.lastIndexOf(".."));
        declaringClass = StringStuff.deployment2CanonicalTypeString((String)declaringClass);
        for (IClassLoader l : cha.getLoaders()) {
            IClass klass;
            if (!cha.getScope().isApplicationLoader(l) || (klass = cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)l.getReference(), (String)declaringClass))) == null) continue;
            return klass;
        }
        return null;
    }

    public static IClass getDeclaringClassAllLoaders(String sig, IClassHierarchy cha) {
        String declaringClass = sig.substring(0, sig.lastIndexOf("..") == -1 ? sig.lastIndexOf(46) : sig.lastIndexOf(".."));
        declaringClass = StringStuff.deployment2CanonicalTypeString((String)declaringClass);
        return SignatureUtil.findClass(cha, declaringClass);
    }

    public static boolean isInnerClass(IClass c) {
        return c.getName().toString().indexOf(36) >= 0;
    }

    public static IClass findClass(IClassHierarchy cha, String typeName) {
        for (IClassLoader l : cha.getLoaders()) {
            TypeReference tr = TypeReference.findOrCreate((ClassLoaderReference)l.getReference(), (String)typeName);
            IClass c = cha.lookupClass(tr);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    public static boolean containsCompatibleSignature(Collection<String> signatures, Collection<IClass> concreteTypes, MethodReference mr) {
        String methodName = mr.getName().toString();
        String fullMethodSignature = methodName + mr.getDescriptor().toString();
        for (String sig : signatures) {
            if (SignatureUtil.isPartialSig(sig)) {
                if (!sig.endsWith(methodName)) continue;
                for (IClass concreteType : concreteTypes) {
                    if (!SignatureUtil.hasCompatibleMethod(concreteType, sig)) continue;
                    return true;
                }
                continue;
            }
            if (!sig.endsWith(fullMethodSignature)) continue;
            for (IClass concreteType : concreteTypes) {
                if (!SignatureUtil.hasCompatibleMethod(concreteType, sig)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasCompatibleMethod(IClass c, String signature) {
        IClassHierarchy cha = c.getClassHierarchy();
        IClass declaringClass = SignatureUtil.getDeclaringClass(signature, cha);
        return declaringClass != null && cha.isAssignableFrom(declaringClass, c);
    }

    public static boolean isPartialSig(String sourceSig) {
        return !sourceSig.contains("(");
    }

    public static boolean canBeReturnTypeOf(IClass c, IMethod m) {
        IClassHierarchy cha = m.getClassHierarchy();
        IClass returnTypeClass = cha.lookupClass(m.getReturnType());
        if (null == returnTypeClass) {
            return false;
        }
        return cha.isAssignableFrom(returnTypeClass, c) || cha.isAssignableFrom(c, returnTypeClass);
    }

    public static boolean isNestedInType(IClass klass, TypeReference t) {
        return klass.getName().toString().startsWith(t.getName().toString() + "$");
    }

    public static boolean isCompatibleWithSignature(IMethod method, String sig, Language l) {
        IClassHierarchy cha = method.getClassHierarchy();
        IClass declaringClass = method.getDeclaringClass();
        Set<IMethod> matches = SignatureUtil.findMatchingMethods(cha, Collections.singleton(sig), l);
        for (IMethod currentMethod : matches) {
            IClass currentDeclaringClass;
            if (!currentMethod.getName().equals((Object)method.getName()) || !currentMethod.getDescriptor().equals((Object)method.getDescriptor()) || !(currentDeclaringClass = currentMethod.getDeclaringClass()).equals(declaringClass) && !cha.isAssignableFrom(currentDeclaringClass, declaringClass)) continue;
            return true;
        }
        return false;
    }

    public static Set<IMethod> findMatchingMethods(IClassHierarchy cha, Collection<String> sigs, Language l) {
        return SignatureUtil.findMatchingMethods(cha, sigs, new Predicate<IMethod>(){

            public boolean test(IMethod m) {
                return true;
            }
        }, l);
    }

    public static Set<IMethod> findMatchingMethods(IClassHierarchy cha, Collection<String> sigs, Predicate<IMethod> f, Language l) {
        HashSet methods = HashSetFactory.make();
        for (String sig : sigs) {
            if (SignatureUtil.isPartialSig(sig)) {
                Collection<IMethod> matches = SignatureUtil.partialSig2Methods(sig, cha, f);
                methods.addAll(matches);
                continue;
            }
            IMethod matchingMethod = SignatureUtil.sig2Method(sig, cha, l);
            if (matchingMethod == null) continue;
            methods.add(matchingMethod);
        }
        return methods;
    }

    public static boolean isCompatibleWithAny(IMethod method, Collection<String> methodSigs, Language l) {
        for (String methodSig : methodSigs) {
            if (!SignatureUtil.isCompatibleWithSignature(method, methodSig, l)) continue;
            return true;
        }
        return false;
    }

    private static IMethod getMostDerivedImplementation(Collection<IMethod> methods) {
        if (null == methods || methods.size() == 0) {
            return null;
        }
        IMethod result = methods.iterator().next();
        for (IMethod m : methods) {
            IClass curDeclaringClass = m.getDeclaringClass();
            IClass resultDeclaringClass = result.getDeclaringClass();
            assert (curDeclaringClass.getClassHierarchy().equals(resultDeclaringClass.getClassHierarchy()));
            IClassHierarchy cha = curDeclaringClass.getClassHierarchy();
            if (!cha.isAssignableFrom(resultDeclaringClass, curDeclaringClass)) continue;
            result = m;
        }
        return result;
    }

    public static Collection<Selector> partialSig2Selectors(String sig, IClassHierarchy cha) {
        HashSet result = HashSetFactory.make();
        IClass c = SignatureUtil.getDeclaringClass(sig, cha);
        if (c != null) {
            String methodName = sig.substring(sig.lastIndexOf(46) + 1, sig.length());
            Collection allMethods = c.getAllMethods();
            for (IMethod m : allMethods) {
                if (!m.getName().toString().equals(methodName)) continue;
                result.add(m.getSelector());
            }
        }
        return result;
    }

    public static Selector sig2Selector(String sig, IClassHierarchy cha, Language l) {
        IMethod m = SignatureUtil.sig2Method(sig, cha, l);
        return m == null ? null : m.getSelector();
    }

    public static Collection<Selector> sig2Selectors(String sig, IClassHierarchy cha, Language l) {
        Selector s;
        Collection<Object> ret = SignatureUtil.isPartialSig(sig) ? SignatureUtil.partialSig2Selectors(sig, cha) : ((s = SignatureUtil.sig2Selector(sig, cha, l)) == null ? Collections.emptySet() : Collections.singleton(s));
        return ret;
    }

    public static Collection<IMethod> partialSig2Methods(String sig, IClassHierarchy cha, Predicate<IMethod> f) {
        HashSet result = HashSetFactory.make();
        IClass klass = SignatureUtil.getDeclaringClass(sig, cha);
        if (klass != null) {
            String methodName = sig.substring(sig.lastIndexOf(46) + 1, sig.length());
            Collection methods = null;
            methods = klass.getAllMethods();
            if (methods != null) {
                HashMap sortedMethods = HashMapFactory.make();
                for (IMethod method : methods) {
                    if (!method.getName().toString().equals(methodName)) continue;
                    String fullSig = method.getName().toString() + method.getDescriptor().toString();
                    if (!sortedMethods.containsKey(fullSig)) {
                        sortedMethods.put(fullSig, new HashSet());
                    }
                    ((Collection)sortedMethods.get(fullSig)).add(method);
                }
                for (Collection c : sortedMethods.values()) {
                    IMethod mostDerived = SignatureUtil.getMostDerivedImplementation(c);
                    if (mostDerived.isInit() && !mostDerived.getDeclaringClass().equals(klass) || !f.test((Object)mostDerived)) continue;
                    result.add(mostDerived);
                }
            }
        }
        return result;
    }

    public static synchronized IMethod sig2Method(String sig, IClassHierarchy cha, Language l) {
        IClass klass = SignatureUtil.getDeclaringClass(sig, cha);
        if (klass == null) {
            return null;
        }
        int methodNameStartIndex = (sig.contains("..") ? sig.lastIndexOf("..") : sig.lastIndexOf(46)) + 1;
        String selector = sig.substring(methodNameStartIndex);
        String name = selector.substring(0, selector.indexOf(40));
        String d = selector.substring(selector.indexOf(40));
        Atom a = Atom.findOrCreateUnicodeAtom((String)name);
        Descriptor dd = Descriptor.findOrCreateUTF8((Language)l, (String)d);
        IMethod m = klass.getMethod(new Selector(a, dd));
        return m;
    }

    public static synchronized IMethod sig2MethodAllLoaders(String sig, IClassHierarchy cha, Language l) {
        IClass klass = SignatureUtil.getDeclaringClassAllLoaders(sig, cha);
        if (klass == null) {
            return null;
        }
        int methodNameStartIndex = (sig.contains("..") ? sig.lastIndexOf("..") : sig.lastIndexOf(46)) + 1;
        String selector = sig.substring(methodNameStartIndex);
        String name = selector.substring(0, selector.indexOf(40));
        String d = selector.substring(selector.indexOf(40));
        Atom a = Atom.findOrCreateUnicodeAtom((String)name);
        Descriptor dd = Descriptor.findOrCreateUTF8((Language)l, (String)d);
        IMethod m = klass.getMethod(new Selector(a, dd));
        return m;
    }

    public static boolean matchesSanitizerPattern(IClassHierarchy ch, IMethod m, ILangServices languageSpecificServices) {
        return m.isStatic() && m.getNumberOfParameters() == 1 && SignatureUtil.isStringish(m.getParameterType(0), ch, languageSpecificServices) && SignatureUtil.isStringish(m.getReturnType(), ch, languageSpecificServices) || false == m.isStatic() && m.getNumberOfParameters() == 2 && SignatureUtil.isStringish(m.getParameterType(1), ch, languageSpecificServices) && SignatureUtil.isStringish(m.getReturnType(), ch, languageSpecificServices);
    }

    public static boolean matchesValidatorPattern(IClassHierarchy ch, IMethod m, ILangServices languageSpecificServices) {
        return m.isStatic() && m.getNumberOfParameters() == 1 && SignatureUtil.isStringish(m.getParameterType(0), ch, languageSpecificServices) && TypeReference.Boolean.equals((Object)m.getReturnType()) || false == m.isStatic() && m.getNumberOfParameters() == 2 && SignatureUtil.isStringish(m.getParameterType(1), ch, languageSpecificServices) && TypeReference.Boolean.equals((Object)m.getReturnType());
    }

    public static boolean isStringish(TypeReference type, IClassHierarchy ch, ILangServices lngSpecificServices) {
        IClass c = ch.lookupClass(type);
        if (c != null) {
            return lngSpecificServices.isStringish(c);
        }
        return false;
    }
}

