/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee;

import com.ibm.appscan.frameworks.analyzers.javaee.BeanScope;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.types.TypeReference;

public class BeanSeed {
    public final IMethod callerMethod;
    public final CallSiteReference callSite;
    public final int param;
    public final BeanScope scope;
    public final String name;
    public final String ap;
    public final TypeReference typeOfBean;
    public final int srcLine;

    public BeanSeed(IMethod callerMethod, CallSiteReference callSite, int param, BeanScope scope, String name, String ap, TypeReference typeOfBean, int srcLine) {
        this.callerMethod = callerMethod;
        this.callSite = callSite;
        this.param = param;
        this.scope = scope;
        assert (scope != null);
        this.name = name;
        this.ap = ap;
        this.typeOfBean = typeOfBean;
        this.srcLine = srcLine;
    }

    public String toString() {
        return String.format("Bean %s is used at method %s, the call site %s uses, in param %d of type %s", this.ap == null ? String.format("%s.%s", new Object[]{this.scope, this.name}) : String.format("%s.%s.%s", new Object[]{this.scope, this.name, this.ap}), this.callerMethod.getSignature(), this.callSite.toString(), this.param, this.typeOfBean);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ap == null ? 0 : this.ap.hashCode());
        result = 31 * result + (this.callSite == null ? 0 : this.callSite.hashCode());
        result = 31 * result + (this.callerMethod == null ? 0 : this.callerMethod.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.param;
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + this.srcLine;
        result = 31 * result + (this.typeOfBean == null ? 0 : this.typeOfBean.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BeanSeed other = (BeanSeed)obj;
        if (this.ap == null ? other.ap != null : !this.ap.equals(other.ap)) {
            return false;
        }
        if (this.callSite == null ? other.callSite != null : !this.callSite.equals((Object)other.callSite)) {
            return false;
        }
        if (this.callerMethod == null ? other.callerMethod != null : !this.callerMethod.equals(other.callerMethod)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.param != other.param) {
            return false;
        }
        if (this.scope == null ? other.scope != null : !this.scope.equals((Object)other.scope)) {
            return false;
        }
        if (this.srcLine != other.srcLine) {
            return false;
        }
        return !(this.typeOfBean == null ? other.typeOfBean != null : !this.typeOfBean.equals((Object)other.typeOfBean));
    }
}

