/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee;

import com.ibm.appscan.frameworks.analyzers.javaee.JavaEEMethodConstants;
import com.ibm.appscan.frameworks.analyzers.javaee.JavaEEOptions;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.JSPAnalyzer;
import com.ibm.appscan.frameworks.parsers.deploymentDescriptorParser.IJavaEEDeploymentDescriptorInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.strings.StringStuff;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class JavaEEEntrypoints {
    private static final Set<Selector> servletRequestEntrypointSelectors;

    public static Map<String, Set<String>> getURLAndEntrypointInfo(IJavaEEDeploymentDescriptorInfo ddInfo, String webContentDir, IClassHierarchy cha, Properties options, JSPAnalyzer jspAnalyser) {
        HashMap sig2URL = HashMapFactory.make();
        JavaEEEntrypoints.handleServletClasses(ddInfo, cha, sig2URL, options);
        JavaEEEntrypoints.handleFilters(ddInfo, cha, sig2URL, options);
        jspAnalyser.handleMappedJSPs(ddInfo, sig2URL);
        jspAnalyser.handleAllJSPs(sig2URL);
        return sig2URL;
    }

    private static void handleServletClasses(IJavaEEDeploymentDescriptorInfo ddInfo, IClassHierarchy cha, Map<String, Set<String>> sig2URL, Properties options) {
        Set<String> servletsToIgnore = JavaEEEntrypoints.computeServletsToIgnore(options);
        Collection<String> allServletClassNames = ddInfo.getAllServletClassNames();
        for (String servletClassName : allServletClassNames) {
            if (servletsToIgnore.contains(servletClassName)) continue;
            Set<String> sigs = JavaEEEntrypoints.getEntrypointSigsForServletRequests(servletClassName, cha);
            Collection<String> servletNames = ddInfo.getServletNamesForServletClass(servletClassName);
            for (String servletName : servletNames) {
                JavaEEEntrypoints.addSig2URLMappings(ddInfo, sig2URL, sigs, servletName);
            }
            JavaEEEntrypoints.handleNonRequestEntrypoints(servletClassName, cha, sig2URL);
        }
    }

    private static void handleFilters(IJavaEEDeploymentDescriptorInfo ddInfo, IClassHierarchy cha, Map<String, Set<String>> sig2URL, Properties options) {
        Collection<String> allFilterClassNames = ddInfo.getAllFilterClassNames();
        for (String filterClassName : allFilterClassNames) {
            Set<String> sigs = JavaEEEntrypoints.getEntrypointSigsForFilterClass(filterClassName, cha);
            Collection<String> filterNames = ddInfo.getFilterNamesForFilterClass(filterClassName);
            for (String name : filterNames) {
                if (ddInfo.getFilterURLMappings().get(name) == null && ddInfo.getFilterServletMappings().get(name) == null) continue;
                for (String sig : sigs) {
                    TaintLogger.i().getLogger().info((Object)Messages.getString("framework.method.url", sig, ""));
                    MapUtil.findOrCreateSet(sig2URL, (Object)sig);
                }
            }
        }
    }

    private static Set<String> getEntrypointSigsForFilterClass(String filterClassName, IClassHierarchy cha) {
        IClass klass = cha.lookupClass(WalaUtil.createTypeRefForJavaClassName(filterClassName));
        if (klass == null) {
            return Collections.emptySet();
        }
        IClass filterKlass = cha.lookupClass(WalaUtil.createTypeRefForJavaClassName("javax.servlet.Filter"));
        if (filterKlass == null || !cha.implementsInterface(klass, filterKlass)) {
            return Collections.emptySet();
        }
        HashSet result = HashSetFactory.make();
        for (IMethod filterMethod : filterKlass.getDeclaredMethods()) {
            IMethod klassMethod = klass.getMethod(filterMethod.getSelector());
            assert (klassMethod != null);
            result.add(VDBJavaUtil.jvmToVDBSignature(klassMethod.getSignature()));
        }
        return result;
    }

    private static void handleNonRequestEntrypoints(String servletClassName, IClassHierarchy cha, Map<String, Set<String>> sig2url) {
        TypeReference typeRef = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)StringStuff.deployment2CanonicalTypeString((String)servletClassName));
        IClass klass = cha.lookupClass(typeRef);
        if (klass == null) {
            return;
        }
        HashSet nonRequestEntrypoints = HashSetFactory.make((int)1);
        JavaEEEntrypoints.addIfOverridingHttpServletMethod(cha, klass, nonRequestEntrypoints, Selector.make((String)"init(Ljavax/servlet/ServletConfig;)V"));
        JavaEEEntrypoints.addIfOverridingHttpServletMethod(cha, klass, nonRequestEntrypoints, Selector.make((String)"init()V"));
        JavaEEEntrypoints.addIfOverridingHttpServletMethod(cha, klass, nonRequestEntrypoints, Selector.make((String)"destroy()V"));
        for (String sig : nonRequestEntrypoints) {
            MapUtil.findOrCreateSet(sig2url, (Object)sig);
        }
    }

    private static void addSig2URLMappings(IJavaEEDeploymentDescriptorInfo ddInfo, Map<String, Set<String>> sig2URL, Set<String> sigs, String servletName) {
        List<String> urls = ddInfo.getServletMappings().get(servletName);
        if (urls != null) {
            for (String sig : sigs) {
                if (!urls.isEmpty()) {
                    TaintLogger.i().getLogger().info((Object)Messages.getString("framework.method.url", sig, urls.get(0)));
                }
                MapUtil.findOrCreateSet(sig2URL, (Object)sig).addAll(urls);
            }
        } else {
            for (String sig : sigs) {
                TaintLogger.i().getLogger().info((Object)Messages.getString("framework.method.url", sig, ""));
                MapUtil.findOrCreateSet(sig2URL, (Object)sig);
            }
        }
    }

    private static Set<String> computeServletsToIgnore(Properties options) {
        HashSet servletsToIgnore = HashSetFactory.make();
        String ignoreServletsStr = options.getProperty(JavaEEOptions.SERVLETS_TO_IGNORE.getName());
        if (ignoreServletsStr != null) {
            String[] split;
            for (String className : split = ignoreServletsStr.split(",")) {
                servletsToIgnore.add(className);
            }
        }
        return servletsToIgnore;
    }

    private static Set<String> getEntrypointSigsForServletRequests(String servletClassName, IClassHierarchy cha) {
        TypeReference typeRef = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)StringStuff.deployment2CanonicalTypeString((String)servletClassName));
        IClass klass = cha.lookupClass(typeRef);
        if (klass == null) {
            TaintLogger.i().getLogger().warn((Object)("could not find servlet class " + servletClassName));
            return Collections.emptySet();
        }
        HashSet result = HashSetFactory.make((int)1);
        for (Selector s : servletRequestEntrypointSelectors) {
            JavaEEEntrypoints.addIfOverridingHttpServletMethod(cha, klass, result, s);
        }
        return result;
    }

    private static void addIfOverridingHttpServletMethod(IClassHierarchy cha, IClass klass, Set<String> result, Selector selector) {
        MethodReference ref = MethodReference.findOrCreate((TypeReference)klass.getReference(), (Selector)selector);
        IMethod method = cha.resolveMethod(ref);
        if (method != null && !method.getDeclaringClass().getName().equals((Object)JavaEEMethodConstants.HTTP_SERVLET_NAME)) {
            result.add(VDBJavaUtil.jvmToVDBSignature(method.getSignature()));
        }
    }

    static {
        HashSet tmp = HashSetFactory.make();
        tmp.add(Selector.make((String)"doGet(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V)"));
        tmp.add(Selector.make((String)"doHead(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V)"));
        tmp.add(Selector.make((String)"doPost(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V)"));
        tmp.add(Selector.make((String)"doPut(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V)"));
        tmp.add(Selector.make((String)"doDelete(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V)"));
        tmp.add(Selector.make((String)"doOptions(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V)"));
        tmp.add(Selector.make((String)"doTrace(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V)"));
        tmp.add(Selector.make((String)"service(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V)"));
        tmp.add(Selector.make((String)"getLastModified(Ljavax/servlet/http/HttpServletRequest;)J)"));
        servletRequestEntrypointSelectors = Collections.unmodifiableSet(tmp);
    }
}

