/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee.jsp;

import com.ibm.appscan.frameworks.analyzers.javaee.BeanScope;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.ElAccess;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.UnhandledELException;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.GlobalRefExpr;
import com.ibm.appscan.frameworks.specinfo.NonDetSelectionExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class BeanElAccess
extends ElAccess {
    private List<String> propertyNames;
    private String beanName;
    private Set<List<IMethod>> possibleMethodSequences;
    private Set<BeanScope> beanScopes = HashSetFactory.make();
    private Set<BeanDecl> beanDecls = HashSetFactory.make();

    public BeanElAccess(IClassHierarchy cha, List<String> accessPath, IMethod jspEvaluateCall, CallSiteReference callSiteReference, int srcLine) throws UnhandledELException {
        super(jspEvaluateCall, callSiteReference, srcLine);
        if (accessPath.size() < 2) {
            throw new UnhandledELException();
        }
        this.analyzeAccessPath(accessPath);
        this.possibleMethodSequences = BeanElAccess.getPossibleMethodSequences(this.propertyNames, cha);
        if (this.possibleMethodSequences.size() == 0) {
            logger.warn((Object)("Did not find any method sequences that can perform the access " + accessPath));
            throw new UnhandledELException();
        }
        for (List<IMethod> seq : this.possibleMethodSequences) {
            IClass beanClass = seq.get(0).getDeclaringClass();
            for (BeanScope beanScope : this.beanScopes) {
                this.beanDecls.add(BeanDecl.makeWithConcreteType((String)(beanScope.toString() + "." + this.beanName), (String)VDBJavaUtil.jvmToVDBType(beanClass.getName().toString()), (BeanDecl.BeanLifespan)beanScope.getLifeSpan()));
            }
        }
    }

    private void analyzeAccessPath(List<String> accessPath) throws UnhandledELException {
        boolean scopeIsExplicit = false;
        for (BeanScope scope : BeanScope.values()) {
            if (!accessPath.get(0).startsWith(scope.toString())) continue;
            this.beanScopes.add(scope);
            if (accessPath.size() < 3) {
                logger.warn((Object)("Bean access using EL expression " + accessPath + " is too short. Skipping."));
                throw new UnhandledELException();
            }
            scopeIsExplicit = true;
            break;
        }
        int beanNameIndex = scopeIsExplicit ? 1 : 0;
        this.beanName = accessPath.get(beanNameIndex);
        this.propertyNames = accessPath.subList(beanNameIndex + 1, accessPath.size());
        if (!scopeIsExplicit) {
            this.beanScopes.add(BeanScope.Request);
            this.beanScopes.add(BeanScope.Session);
        }
    }

    public static Set<List<IMethod>> getPossibleMethodSequences(List<String> propertyNames, IClassHierarchy cha) {
        HashSet result = HashSetFactory.make();
        String firstProperty = propertyNames.get(0);
        IClassLoader applicationsCL = cha.getLoader(ClassLoaderReference.Application);
        String propertyGetterName = BeanElAccess.getPropertyGetterMethodName(firstProperty);
        Iterator iterator = applicationsCL.iterateAllClasses();
        while (iterator.hasNext()) {
            IClass klass = (IClass)iterator.next();
            if (BeanElAccess.notAValidBeanClass(klass)) continue;
            for (IMethod method : klass.getDeclaredMethods()) {
                if (!BeanElAccess.isValidAccessorMethodForProperty(propertyGetterName, method)) continue;
                ArrayList<IMethod> seq = new ArrayList<IMethod>(1);
                seq.add(method);
                result.add(seq);
            }
        }
        for (int i = 1; i < propertyNames.size(); ++i) {
            HashSet tmp = HashSetFactory.make();
            String getterName = BeanElAccess.getPropertyGetterMethodName(propertyNames.get(i));
            for (ArrayList<IMethod> seq : result) {
                IMethod lastMethod = (IMethod)seq.get(seq.size() - 1);
                IClass returnType = cha.lookupClass(lastMethod.getReturnType());
                if (returnType == null || BeanElAccess.notAValidBeanClass(returnType)) continue;
                for (IMethod method : returnType.getAllMethods()) {
                    if (!BeanElAccess.isValidAccessorMethodForProperty(getterName, method)) continue;
                    ArrayList<IMethod> newSeq = new ArrayList<IMethod>(seq);
                    newSeq.add(method);
                    tmp.add(newSeq);
                }
            }
            result = tmp;
        }
        return result;
    }

    private static boolean notAValidBeanClass(IClass klass) {
        return klass.isAbstract() || klass.isInterface() || klass.isPrivate();
    }

    private static boolean isValidAccessorMethodForProperty(String propertyGetterName, IMethod method) {
        return method.getNumberOfParameters() == 1 && method.isPublic() && !method.isStatic() && !method.isAbstract() && method.getName().toString().equals(propertyGetterName);
    }

    @Override
    public NonVoidSyntheticExpr getSyntheticExpr() {
        NonVoidSyntheticExpr beanAccessExpr;
        if (this.beanScopes.size() == 1) {
            beanAccessExpr = GlobalRefExpr.make((String)(this.beanScopes.iterator().next().toString() + "." + this.beanName));
        } else {
            HashSet globalRefs = HashSetFactory.make();
            for (BeanScope beanScope : this.beanScopes) {
                globalRefs.add(GlobalRefExpr.make((String)(beanScope.toString() + "." + this.beanName)));
            }
            beanAccessExpr = NonDetSelectionExpr.make((Set)globalRefs);
        }
        beanAccessExpr = ObjectRefExpr.make((NonVoidSyntheticExpr)beanAccessExpr, (String)"");
        return BeanElAccess.makeSynthExprForElAccess(beanAccessExpr, this.possibleMethodSequences);
    }

    public static NonVoidSyntheticExpr makeSynthExprForElAccess(NonVoidSyntheticExpr baseExpr, Set<List<IMethod>> possibleMethodSequences) {
        NonVoidSyntheticExpr result;
        if (possibleMethodSequences.size() == 1) {
            result = BeanElAccess.createNestedInvokeForSeq(possibleMethodSequences.iterator().next(), baseExpr);
        } else {
            HashSet possibleInvokes = HashSetFactory.make();
            for (List<IMethod> seq : possibleMethodSequences) {
                possibleInvokes.add(BeanElAccess.createNestedInvokeForSeq(seq, baseExpr));
            }
            result = NonDetSelectionExpr.make((Set)possibleInvokes);
        }
        return result;
    }

    private static NonVoidSyntheticExpr createNestedInvokeForSeq(List<IMethod> seq, NonVoidSyntheticExpr initialExpr) {
        NonVoidSyntheticExpr result = initialExpr;
        for (IMethod m : seq) {
            result = VDBJavaUtil.invokeFromJVMSig(null, m.getSignature(), Collections.singletonMap(0, result));
        }
        return result;
    }

    private static String getPropertyGetterMethodName(String propName) {
        return "get" + propName.substring(0, 1).toUpperCase() + propName.substring(1);
    }

    @Override
    public Set<BeanDecl> getGlobalBeanDecls() {
        return this.beanDecls;
    }
}

