/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee.jsp;

import com.ibm.appscan.frameworks.analyzers.javaee.jsp.IJSPPrecompilerInfo;
import com.ibm.appscan.frameworks.specinfo.FormalParameterExpr;
import com.ibm.appscan.frameworks.specinfo.InvokeExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.types.Selector;
import com.ibm.wala.util.collections.HashMapFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class JspEntrypointResolver {
    static final Logger logger = TaintLogger.i().getLogger();
    private final IJSPPrecompilerInfo jspInfo;
    private final String webContentDir;

    public static JspEntrypointResolver make(IJSPPrecompilerInfo jspInfo, String webContentDir) {
        return new JspEntrypointResolver(jspInfo, webContentDir);
    }

    private JspEntrypointResolver(IJSPPrecompilerInfo jspInfo, String webContentDir) {
        this.jspInfo = jspInfo;
        this.webContentDir = webContentDir;
    }

    public InvokeExpr getInvokeForEntryOfPathTarget(String forwardPath, FilePositionInfo filePosInfo, int requestInd, int responseInd) {
        if (!forwardPath.endsWith(".jsp")) {
            logger.warn((Object)("Found forward to a non jsp file " + forwardPath));
            return null;
        }
        if (!this.isValidJSPPath(forwardPath)) {
            logger.info((Object)("JSP path " + forwardPath + " does not point to valid JSP"));
            return null;
        }
        String jspEntrypointSignature = this.getJSPEntrypointSig(forwardPath);
        HashMap jspInvokeParamPos2Value = HashMapFactory.make();
        jspInvokeParamPos2Value.put(1, ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)requestInd), (String)""));
        jspInvokeParamPos2Value.put(2, ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)responseInd), (String)""));
        return VDBJavaUtil.invokeFromJVMSig(filePosInfo, jspEntrypointSignature, jspInvokeParamPos2Value);
    }

    public boolean isValidJSPPath(String jspPath) {
        String separatorRegex = this.escapeBackSlashesForRegex(File.separator);
        String jspFileSubPath = jspPath.replaceAll("/", separatorRegex);
        String fullPath = this.webContentDir + jspFileSubPath;
        return new File(fullPath).exists();
    }

    private String escapeBackSlashesForRegex(String str) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char curChar = str.charAt(i);
            result.append(curChar);
            if (curChar != '\\') continue;
            result.append('\\');
        }
        return result.toString();
    }

    public String getJSPEntrypointSig(String trueForwardPath) {
        Set<Selector> entrypointSelectors = this.jspInfo.getEntrypointSelectors();
        if (entrypointSelectors.size() > 1) {
            logger.info((Object)("TODO: handle more than one entrypoint selector for a JSP " + entrypointSelectors));
        }
        Selector selector = entrypointSelectors.iterator().next();
        return this.jspInfo.getPrecompiledClassNameForJSP(trueForwardPath) + "." + selector.toString();
    }
}

