/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee.jsp;

import com.ibm.appscan.frameworks.analyzers.javaee.JavaEEOptions;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.IJSPPrecompilerInfo;
import com.ibm.appscan.frameworks.analyzers.javaee.taglibs.ITagLibDefInfo;
import com.ibm.wala.ipa.cfg.ExplodedInterproceduralCFG;
import com.ibm.wala.types.Selector;
import com.ibm.wala.util.collections.Pair;
import java.util.Collections;
import java.util.Properties;
import java.util.Set;

public class WebLogicInfo
implements IJSPPrecompilerInfo {
    private final String packageName;
    private static final Selector JSP_SERVICE_SELECTOR = Selector.make((String)"_jspService(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V");
    private static final Pair<String, Integer> JSP_RUNTIME_INCLUDE_SIG = Pair.make((Object)"javax.servlet.jsp.PageContext.include(Ljava/lang/String;)V", (Object)1);
    private static final Pair<String, Integer> JSP_EL_EVALUATE_SIG = null;

    public static WebLogicInfo make(Properties options) {
        return new WebLogicInfo(options);
    }

    private WebLogicInfo(Properties options) {
        String packageNameOpt = options.getProperty(JavaEEOptions.JSP_PACKAGE_NAME.getName());
        if (packageNameOpt == null) {
            throw new IllegalArgumentException(JavaEEOptions.JSP_PACKAGE_NAME.getName() + " option must be set");
        }
        this.packageName = packageNameOpt;
    }

    private static String getJavaClassForJSPFile(String jspFilePath) {
        int jspNameStartIndex = jspFilePath.lastIndexOf(47) + 1;
        String className = "__" + WebLogicInfo.makeJavaIdentifier(jspFilePath.substring(jspNameStartIndex, jspFilePath.length() - 4));
        String packageName = "";
        if (jspNameStartIndex > 1) {
            packageName = WebLogicInfo.makeJavaPackage(jspFilePath.substring(1, jspNameStartIndex - 1)) + ".";
        }
        return packageName + className;
    }

    @Override
    public Set<Selector> getEntrypointSelectors() {
        return Collections.singleton(JSP_SERVICE_SELECTOR);
    }

    @Override
    public String getPrecompiledClassNameForJSP(String jspPath) {
        return this.packageName + "." + WebLogicInfo.getJavaClassForJSPFile(jspPath);
    }

    @Override
    public Pair<String, Integer> getRuntimeIncludeMethodSig() {
        return JSP_RUNTIME_INCLUDE_SIG;
    }

    @Override
    public Pair<String, Integer> getELEvaluateMethodSig() {
        return JSP_EL_EVALUATE_SIG;
    }

    private static final String makeJavaIdentifier(String identifier) {
        identifier = identifier.toLowerCase();
        StringBuffer modifiedIdentifier = new StringBuffer(identifier.length());
        for (int i = 0; i < identifier.length(); ++i) {
            char ch = identifier.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                modifiedIdentifier.append(ch);
                continue;
            }
            modifiedIdentifier.append("_" + ch + "_");
        }
        return modifiedIdentifier.toString();
    }

    private static final String makeJavaPackage(String path) {
        path = path.toLowerCase();
        String[] classNameComponents = path.split("/");
        StringBuffer legalClassNames = new StringBuffer();
        for (int i = 0; i < classNameComponents.length; ++i) {
            legalClassNames.append("_" + WebLogicInfo.makeJavaIdentifier(classNameComponents[i]));
            if (i >= classNameComponents.length - 1) continue;
            legalClassNames.append('.');
        }
        return legalClassNames.toString();
    }

    @Override
    public boolean tagLibAnalysisSupported() {
        return false;
    }

    @Override
    public ITagLibDefInfo getTagLibDefInfo(ExplodedInterproceduralCFG icfg) {
        throw new IllegalStateException("tag library analysis not supported");
    }
}

