/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee.taglibs;

import com.ibm.appscan.frameworks.analyzers.generic.StringConstantFlow;
import com.ibm.appscan.frameworks.analyzers.javaee.taglibs.ElExpUtil;
import com.ibm.appscan.frameworks.analyzers.javaee.taglibs.ITagLibDefInfo;
import com.ibm.appscan.frameworks.analyzers.javaee.taglibs.TagLibraryInfo;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.Pair;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class SpringBindInfo
implements TagLibraryInfo {
    private static final String DO_START_TAG_SIG = "org.springframework.web.servlet.tags.BindTag.doStartTag()I";
    private static final String SET_PATH_SIG = "org.springframework.web.servlet.tags.BindTag.setPath(Ljava/lang/String;)V";

    @Override
    public boolean understands(MethodReference declaredTarget) {
        return declaredTarget.getSignature().equals(DO_START_TAG_SIG);
    }

    @Override
    public ITagLibDefInfo.ReachingDef getFact(SSAAbstractInvokeInstruction invokeInstruction, CGNode cgNode, int instructionIndex) {
        assert (invokeInstruction.isDispatch());
        int receiver = invokeInstruction.getReceiver();
        String bindPath = this.getBindPath(receiver, cgNode);
        if (bindPath == null) {
            return null;
        }
        Pair<NonVoidSyntheticExpr, Set<BeanDecl>> synthExpr = this.getSyntheticExprForBindPath(bindPath, cgNode.getClassHierarchy(), cgNode.getMethod(), invokeInstruction.getCallSite(), WalaUtil.getSourceLine(cgNode.getMethod(), invokeInstruction.getCallSite()));
        if (synthExpr == null) {
            return null;
        }
        String nameToBind = "status.value";
        return new ITagLibDefInfo.ReachingDef(nameToBind, (NonVoidSyntheticExpr)synthExpr.fst, (Set)synthExpr.snd);
    }

    private Pair<NonVoidSyntheticExpr, Set<BeanDecl>> getSyntheticExprForBindPath(String bindPath, IClassHierarchy cha, IMethod caller, CallSiteReference evalSite, int srcLine) {
        String fakeELExp = "${" + bindPath + "}";
        return ElExpUtil.getSyntheticExprForElExp(cha, caller, evalSite, srcLine, fakeELExp);
    }

    private String getBindPath(int receiver, CGNode cgNode) {
        IR ir = cgNode.getIR();
        DefUse du = cgNode.getDU();
        for (SSAInstruction use : Iterator2Iterable.make((Iterator)du.getUses(receiver))) {
            SSAAbstractInvokeInstruction invoke;
            MethodReference declaredTarget;
            if (!(use instanceof SSAAbstractInvokeInstruction) || !(declaredTarget = (invoke = (SSAAbstractInvokeInstruction)use).getDeclaredTarget()).getSignature().equals(SET_PATH_SIG)) continue;
            int setPathArg = invoke.getUse(1);
            StringConstantFlow flow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
            Collection possibleStrings = flow.findIntraprocStringsFlowingToVar(setPathArg);
            if (possibleStrings.size() == 1) {
                return (String)possibleStrings.iterator().next();
            }
            return null;
        }
        return null;
    }
}

