/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.spring;

import com.ibm.appscan.frameworks.analyzers.javaee.BeanUtil;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.IJSPPrecompilerInfo;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.JspEntrypointResolver;
import com.ibm.appscan.frameworks.analyzers.spring.ISpringControllerInfo;
import com.ibm.appscan.frameworks.analyzers.spring.ModelAndViewUtil;
import com.ibm.appscan.frameworks.analyzers.spring.SpringAppConfigInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringConfigFileInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringEntrypointHandler;
import com.ibm.appscan.frameworks.analyzers.spring.SpringEntrypointInvokeInfo;
import com.ibm.appscan.frameworks.specinfo.AssignableSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.AssignmentExpr;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.FormalParameterExpr;
import com.ibm.appscan.frameworks.specinfo.GlobalRefExpr;
import com.ibm.appscan.frameworks.specinfo.ISyntheticMethod;
import com.ibm.appscan.frameworks.specinfo.LocalRefExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticMethodImpl;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.StringStuff;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExtendsMultiActionControllerInfo
implements ISpringControllerInfo {
    private static final TypeReference MULTI_ACTION_CONTROLLER_REF = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)StringStuff.deployment2CanonicalTypeString((String)"org.springframework.web.servlet.mvc.multiaction.MultiActionController"));
    private static final Logger logger = TaintLogger.i().getLogger();

    @Override
    public boolean isApplicable(IClass klass, IClassHierarchy cha) {
        logger.info((Object)Messages.getString("framework.handler.searching", "org.springframework.web.servlet.mvc.multiaction.MultiActionController", ""));
        IClass multiActionControllerKlass = cha.lookupClass(MULTI_ACTION_CONTROLLER_REF);
        if (multiActionControllerKlass == null) {
            logger.info((Object)Messages.getString("framework.missing", "org.springframework.web.servlet.mvc.multiaction.MultiActionController"));
            return false;
        }
        boolean result = cha.isAssignableFrom(multiActionControllerKlass, klass);
        if (!result) {
            logger.info((Object)Messages.getString("framework.missing", "org.springframework.web.servlet.mvc.multiaction.MultiActionController"));
        }
        return result;
    }

    @Override
    public Collection<SpringEntrypointInvokeInfo> getSyntheticEntrypointMethods(IClass klass, SpringConfigFileInfo.SpringBeanInfo beanInfo, String idForSignature, IJSPPrecompilerInfo precompilerInfo, String webContentDir, SpringAppConfigInfo configInfo) {
        Set<IMethod> entrypointMethods = this.collectMultiActionEntrypointMethods(klass);
        HashSet result = HashSetFactory.make((int)entrypointMethods.size());
        for (IMethod entrypoint : entrypointMethods) {
            result.add(this.handleEntrypointMethod(entrypoint, klass, beanInfo, idForSignature, precompilerInfo, webContentDir, configInfo));
        }
        return result;
    }

    private SpringEntrypointInvokeInfo handleEntrypointMethod(IMethod entrypoint, IClass klass, SpringConfigFileInfo.SpringBeanInfo beanInfo, String idForSignature, IJSPPrecompilerInfo precompilerInfo, String webContentDir, SpringAppConfigInfo configInfo) {
        IClassHierarchy cha = klass.getClassHierarchy();
        ArrayList<BeanDecl> localBeanDeclarations = new ArrayList<BeanDecl>();
        ArrayList<Object> statements = new ArrayList<Object>();
        HashSet globalBeanDeclarations = HashSetFactory.make();
        logger.info((Object)Messages.getString("framework.begin.syntheticmethod", SpringEntrypointHandler.createEntrypointVDBSignature(idForSignature + "_" + entrypoint.getName().toString())));
        String formObjectLocalName = null;
        BeanDecl localBeanDecl = null;
        TypeReference formObjectType = this.getFormObjectType(entrypoint);
        if (formObjectType != null && (localBeanDecl = this.createFormObject(localBeanDeclarations, formObjectLocalName = "theBean", formObjectType)) != null) {
            String commandName;
            String localBeanType = localBeanDecl.getType();
            if (!localBeanType.equals("java.lang.Object")) {
                logger.info((Object)Messages.getString("framework.taint.found", localBeanType));
                statements.addAll(BeanUtil.taintBeanPropertiesIncludingInner(localBeanType, formObjectLocalName, beanInfo.getFilePosInfo(), cha));
            }
            if ((commandName = "command") != null) {
                String heapName = "request." + commandName;
                ObjectRefExpr beanRef = ObjectRefExpr.make((NonVoidSyntheticExpr)GlobalRefExpr.make((String)heapName), (String)"");
                ObjectRefExpr l = ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)formObjectLocalName), (String)"");
                logger.info((Object)Messages.getString("framework.generate.write", heapName));
                statements.add(AssignmentExpr.make((FilePositionInfo)beanInfo.getFilePosInfo(), (AssignableSyntheticExpr)beanRef, (NonVoidSyntheticExpr)l));
                BeanDecl globalBean = BeanDecl.makeWithConcreteType((String)heapName, (String)localBeanDecl.getType(), (BeanDecl.BeanLifespan)BeanDecl.BeanLifespan.ENTRYPOINT);
                globalBeanDeclarations.add(globalBean);
            }
        }
        HashMap actualParameterPos2Value = HashMapFactory.make();
        actualParameterPos2Value.put(1, ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)0), (String)""));
        actualParameterPos2Value.put(2, ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)1), (String)""));
        if (localBeanDecl != null) {
            actualParameterPos2Value.put(3, ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)formObjectLocalName), (String)""));
        }
        logger.info((Object)Messages.getString("framework.generate.call", entrypoint.getSignature()));
        statements.add(VDBJavaUtil.invokeFromJVMSig(beanInfo.getFilePosInfo(), entrypoint.getSignature(), actualParameterPos2Value));
        statements.addAll(ModelAndViewUtil.getStatementsInvokingEntryOfView(entrypoint, new AnalysisCache(), configInfo, JspEntrypointResolver.make(precompilerInfo, webContentDir), beanInfo.getFilePosInfo(), webContentDir, beanInfo));
        logger.info((Object)Messages.getString("framework.generate.syntheticmethod", SpringEntrypointHandler.createEntrypointVDBSignature(idForSignature + "_" + entrypoint.getName().toString())));
        SyntheticMethodImpl synthMethod = new SyntheticMethodImpl(SpringEntrypointHandler.createEntrypointVDBSignature(idForSignature + "_" + entrypoint.getName().toString()), localBeanDeclarations, statements);
        return SpringEntrypointInvokeInfo.make(entrypoint, (ISyntheticMethod)synthMethod, globalBeanDeclarations);
    }

    private BeanDecl createFormObject(Collection<BeanDecl> localBeanDeclarations, String formObjectLocalName, TypeReference formObjectType) {
        BeanDecl result = BeanDecl.makeWithConcreteType((String)formObjectLocalName, (String)VDBJavaUtil.jvmToVDBType(formObjectType.getName().toString()), (BeanDecl.BeanLifespan)BeanDecl.BeanLifespan.LOCAL);
        localBeanDeclarations.add(result);
        return result;
    }

    private TypeReference getFormObjectType(IMethod entrypoint) {
        TypeReference possibleType;
        if (entrypoint.getNumberOfParameters() >= 4 && (possibleType = entrypoint.getParameterType(3)).isReferenceType() && !possibleType.getName().toString().equals(StringStuff.deployment2CanonicalTypeString((String)"javax.servlet.http.HttpSession"))) {
            return possibleType;
        }
        return null;
    }

    private Set<IMethod> collectMultiActionEntrypointMethods(IClass klass) {
        HashSet result = HashSetFactory.make();
        for (IMethod m : klass.getDeclaredMethods()) {
            String returnTypeName;
            TypeReference secondParameterType;
            TypeReference firstParameterType;
            if (m.isStatic() || !m.isPublic() || m.getNumberOfParameters() < 3 || !(firstParameterType = m.getParameterType(1)).getName().toString().equals("Ljavax/servlet/http/HttpServletRequest") || !(secondParameterType = m.getParameterType(2)).getName().toString().equals("Ljavax/servlet/http/HttpServletResponse")) continue;
            TypeReference returnType = m.getReturnType();
            if (returnType.equals((Object)TypeReference.Void)) {
                result.add(m);
            }
            if (!(returnTypeName = returnType.getName().toString()).equals("Ljava/lang/String") && !returnTypeName.equals("Ljava/util/Map") && !returnTypeName.equals("Lorg/springframework/web/servlet/ModelAndView")) continue;
            result.add(m);
        }
        return result;
    }
}

