/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.spring;

import com.ibm.appscan.frameworks.util.DOMParserWithLineNumbers;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.PreNamespaceContext;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SpringConfigFileInfo {
    private final Map<String, SpringBeanInfo> beanId2BeanInfo = HashMapFactory.make();
    private final String namespaceURI;

    public static SpringConfigFileInfo make(String filename) throws IOException, SAXException {
        return new SpringConfigFileInfo(filename);
    }

    private SpringConfigFileInfo(String filename) throws IOException, SAXException {
        DOMParserWithLineNumbers parser = new DOMParserWithLineNumbers(filename);
        Document document = parser.getDocument();
        this.namespaceURI = this.getNamespaceURI(document, filename, false);
        this.populate(document, filename);
    }

    private String getNamespaceURI(Document document, String filename, boolean checkNamespace) {
        NodeList childNodes = document.getChildNodes();
        Node beansNode = null;
        String namespaceName = null;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            String nodeName = child.getNodeName();
            int colonIndex = nodeName.indexOf(":");
            if (colonIndex != -1) {
                nodeName = nodeName.substring(colonIndex + 1, nodeName.length());
                namespaceName = nodeName.substring(0, colonIndex);
            }
            if (!nodeName.equals("beans")) continue;
            beansNode = child;
            break;
        }
        if (beansNode == null) {
            TaintLogger.i().getLogger().info((Object)("could not find proper root node for Spring config file " + filename));
            return null;
        }
        assert (beansNode != null);
        NamedNodeMap attributes = beansNode.getAttributes();
        if (attributes == null) {
            return null;
        }
        String attrName = checkNamespace && namespaceName != null ? "xmlns:" + namespaceName : "xmlns";
        Node nsAttribute = attributes.getNamedItem(attrName);
        if (nsAttribute == null) {
            return null;
        }
        return nsAttribute.getNodeValue();
    }

    private void populate(Document document, String filename) {
        XPath xpath = this.createXPath();
        try {
            String beansNamespaceURI;
            XPathExpression xPathExpression = xpath.compile(this.adjustForNS("/pre:beans/*"));
            NodeList nodes = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            if (nodes.getLength() == 0 && (beansNamespaceURI = this.getNamespaceURI(document, filename, true)) != null) {
                xpath.setNamespaceContext((NamespaceContext)new PreNamespaceContext(beansNamespaceURI));
                xPathExpression = xpath.compile(this.adjustForNS("/pre:beans/*"));
                nodes = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
            }
            for (int i = 0; i < nodes.getLength(); ++i) {
                SpringBeanInfo beanInfo = this.handleBean(nodes.item(i), xpath, filename);
                if (beanInfo == null) continue;
                for (String name : beanInfo.getNames()) {
                    this.beanId2BeanInfo.put(name, beanInfo);
                }
                String id = beanInfo.getId();
                if (id != null) {
                    this.beanId2BeanInfo.put(id, beanInfo);
                }
                if (id != null || !beanInfo.getNames().isEmpty() || beanInfo.getClassAttr() == null) continue;
                this.beanId2BeanInfo.put(beanInfo.getClassAttr(), beanInfo);
            }
        }
        catch (XPathExpressionException e) {
            TaintLogger.i().getLogger().warn((Object)Messages.getString("framework.failure.parsing", filename));
            TaintLogger.i().getLogger().warn((Object)Messages.getString("framework.handler.exception", e.toString() + Messages.getTraceFromException(e)));
        }
    }

    private SpringBeanInfo handleBean(Node beanNode, XPath xpath, String filename) throws XPathExpressionException {
        int i;
        if (!beanNode.getNodeName().equals("bean") && !beanNode.getLocalName().equals("bean")) {
            return null;
        }
        String id = this.getStringAttrValue(beanNode, "id");
        String name = this.getStringAttrValue(beanNode, "name");
        ArrayList<String> names = new ArrayList<String>();
        if (name != null) {
            if (name.contains(",") || name.contains(";")) assert (false) : "need to handle multiple bean names";
            names.add(name);
        }
        String className = this.getStringAttrValue(beanNode, "class");
        HashMap properties = HashMapFactory.make();
        NodeList propertyNodes = (NodeList)xpath.compile(this.adjustForNS("pre:property")).evaluate(beanNode, XPathConstants.NODESET);
        for (i = 0; i < propertyNodes.getLength(); ++i) {
            Node propNode = propertyNodes.item(i);
            Pair<String, Object> property = this.getProperty(propNode, xpath, filename);
            if (property == null) continue;
            properties.put(property.fst, property.snd);
        }
        for (i = 0; i < beanNode.getAttributes().getLength(); ++i) {
            String value;
            String attr = beanNode.getAttributes().item(i).getNodeName();
            if (attr == null || !attr.startsWith("p:") || (value = beanNode.getAttributes().item(i).getNodeValue()) == null) continue;
            properties.put(attr.substring(2), value);
        }
        int lineNumber = Integer.valueOf((String)beanNode.getUserData("startLine"));
        int columnNumber = Integer.valueOf((String)beanNode.getUserData("startColumn"));
        if (id == null && name == null && className != null) {
            name = className;
            names.add(className);
        }
        SpringBeanInfo beanInfo = new SpringBeanInfo(id, names, className, properties, FilePositionInfo.make((String)filename, (int)lineNumber, (int)columnNumber));
        return beanInfo;
    }

    private Pair<String, Object> getProperty(Node propNode, XPath xpath, String filename) throws XPathExpressionException {
        NodeList nestedMapNodes;
        Node nestedBeanNode;
        SpringBeanInfo nestedBeanInfo;
        String propName = this.getStringAttrValue(propNode, "name");
        assert (propName != null) : "property with no name!!";
        String propValueAttr = this.getStringAttrValue(propNode, "value");
        if (propValueAttr != null) {
            return Pair.make((Object)propName, (Object)propValueAttr);
        }
        String propRefAttr = this.getStringAttrValue(propNode, "ref");
        if (propRefAttr != null) {
            return Pair.make((Object)propName, (Object)new BeanRef(propRefAttr));
        }
        NodeList nestedValNodes = (NodeList)xpath.compile(this.adjustForNS("pre:value")).evaluate(propNode, XPathConstants.NODESET);
        if (nestedValNodes.getLength() == 1) {
            Node nestedVal = nestedValNodes.item(0);
            String value = xpath.compile("normalize-space(text())").evaluate(nestedVal);
            return Pair.make((Object)propName, (Object)value);
        }
        NodeList nestedBeanNodes = (NodeList)xpath.compile(this.adjustForNS("pre:bean")).evaluate(propNode, XPathConstants.NODESET);
        if (nestedBeanNodes.getLength() == 1 && (nestedBeanInfo = this.handleBean(nestedBeanNode = nestedBeanNodes.item(0), xpath, filename)) != null) {
            return Pair.make((Object)propName, (Object)nestedBeanInfo);
        }
        NodeList nestedListNodes = (NodeList)xpath.compile(this.adjustForNS("pre:list")).evaluate(propNode, XPathConstants.NODESET);
        if (nestedListNodes.getLength() == 1) {
            // empty if block
        }
        if ((nestedMapNodes = (NodeList)xpath.compile(this.adjustForNS("pre:map")).evaluate(propNode, XPathConstants.NODESET)).getLength() == 1) {
            Node mapNode = nestedMapNodes.item(0);
            HashMap<String, BeanRef> theMap = new HashMap<String, BeanRef>();
            NodeList entryNodes = (NodeList)xpath.compile(this.adjustForNS("pre:entry")).evaluate(mapNode, XPathConstants.NODESET);
            for (int i = 0; i < entryNodes.getLength(); ++i) {
                Node currentEntry = entryNodes.item(i);
                Node keyAttribute = currentEntry.getAttributes().getNamedItem("key");
                Node value_refAttribute = currentEntry.getAttributes().getNamedItem("value-ref");
                if (keyAttribute == null || value_refAttribute == null) continue;
                theMap.put(keyAttribute.getTextContent(), new BeanRef(value_refAttribute.getTextContent()));
            }
            return Pair.make((Object)propName, theMap);
        }
        NodeList nestedPropsNodes = (NodeList)xpath.compile(this.adjustForNS("pre:props")).evaluate(propNode, XPathConstants.NODESET);
        if (nestedPropsNodes.getLength() == 1) {
            Node propsNode = nestedPropsNodes.item(0);
            Properties theProps = new Properties();
            NodeList actualPropertyNodes = (NodeList)xpath.compile(this.adjustForNS("pre:prop")).evaluate(propsNode, XPathConstants.NODESET);
            for (int i = 0; i < actualPropertyNodes.getLength(); ++i) {
                Node currentPropNode = actualPropertyNodes.item(i);
                String key = currentPropNode.getAttributes().getNamedItem("key").getTextContent();
                String value = xpath.compile("normalize-space(text())").evaluate(currentPropNode);
                theProps.setProperty(key, value);
            }
            return Pair.make((Object)propName, (Object)theProps);
        }
        TaintLogger.i().getLogger().info((Object)("unhandled property " + propName));
        return null;
    }

    private XPath createXPath() {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        if (this.namespaceURI != null) {
            xpath.setNamespaceContext((NamespaceContext)new PreNamespaceContext(this.namespaceURI));
        }
        return xpath;
    }

    private String adjustForNS(String query) {
        return this.namespaceURI != null ? query : query.replaceAll("pre:", "");
    }

    private String getStringAttrValue(Node item, String attrName) {
        Node value = item.getAttributes().getNamedItem(attrName);
        return value == null ? null : value.getNodeValue();
    }

    public SpringBeanInfo getBeanInfo(String beanId) {
        return this.beanId2BeanInfo.get(beanId);
    }

    public Set<SpringBeanInfo> getAllBeanInfo() {
        return HashSetFactory.make(this.beanId2BeanInfo.values());
    }

    public static class SpringBeanInfo {
        private final String id;
        private final Collection<String> names;
        private final String classAttr;
        private final Map<String, Object> properties;
        private final FilePositionInfo filePosInfo;

        public SpringBeanInfo(String id, Collection<String> names, String classAttr, Map<String, Object> properties, FilePositionInfo filePosInfo) {
            this.id = id;
            this.names = names;
            this.classAttr = classAttr;
            this.properties = properties;
            this.filePosInfo = filePosInfo;
        }

        public Collection<String> getNames() {
            return this.names;
        }

        public String getId() {
            return this.id;
        }

        public String getClassAttr() {
            return this.classAttr;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public FilePositionInfo getFilePosInfo() {
            return this.filePosInfo;
        }
    }

    public static class BeanRef {
        private final String beanName;

        public BeanRef(String beanName) {
            this.beanName = beanName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.beanName == null ? 0 : this.beanName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BeanRef other = (BeanRef)obj;
            return !(this.beanName == null ? other.beanName != null : !this.beanName.equals(other.beanName));
        }

        public String getBeanName() {
            return this.beanName;
        }
    }
}

