/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.spring;

import com.ibm.appscan.frameworks.analyzers.javaee.JavaEEOptions;
import com.ibm.appscan.frameworks.analyzers.spring.ExtendsAbstractFormControllerInfo;
import com.ibm.appscan.frameworks.analyzers.spring.ExtendsAbstractWizardFormControllerInfo;
import com.ibm.appscan.frameworks.analyzers.spring.ExtendsMultiActionControllerInfo;
import com.ibm.appscan.frameworks.analyzers.spring.ExtendsSimpleFormControllerInfo;
import com.ibm.appscan.frameworks.analyzers.spring.ISpringControllerInfo;
import com.ibm.appscan.frameworks.analyzers.spring.ImplementsControllerInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringAppConfigInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringConfigFileInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringEntrypointInvokeInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringURLInfo;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.FrameworkInfoImpl;
import com.ibm.appscan.frameworks.specinfo.IFrameworkInfo;
import com.ibm.appscan.frameworks.specinfo.ISyntheticMethod;
import com.ibm.appscan.frameworks.util.BeanDeclUtil;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.strings.StringStuff;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SpringEntrypointHandler {
    private static final boolean DEBUG = false;
    private static final List<ISpringControllerInfo> knownControllerInfo = new ArrayList<ISpringControllerInfo>();

    public static Pair<IFrameworkInfo, Map<IMethod, SpringConfigFileInfo.SpringBeanInfo>> getEntrypointInfo(SpringAppConfigInfo configInfo, IClassHierarchy cha, SpringURLInfo urlInfo, Properties options, String webContentDir) {
        HashSet syntheticMethods = HashSetFactory.make();
        HashMap entrypointSignatureToURL = HashMapFactory.make();
        Set<BeanDecl> globalBeanDeclarations = Collections.emptySet();
        HashMap entrypointMethods = HashMapFactory.make();
        block0: for (SpringConfigFileInfo.SpringBeanInfo beanInfo : configInfo.getAllBeanInfo()) {
            IClass klass;
            String classAttr = beanInfo.getClassAttr();
            if (classAttr == null || (klass = cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)StringStuff.deployment2CanonicalTypeString((String)classAttr)))) == null) continue;
            boolean handled = false;
            for (ISpringControllerInfo info : knownControllerInfo) {
                if (!info.isApplicable(klass, cha)) continue;
                handled = true;
                globalBeanDeclarations = SpringEntrypointHandler.applyControllerInfo(configInfo, cha, urlInfo, options, webContentDir, syntheticMethods, entrypointSignatureToURL, globalBeanDeclarations, entrypointMethods, beanInfo, klass, info);
                continue block0;
            }
        }
        Map methodToReplacements = Collections.emptyMap();
        return Pair.make((Object)new FrameworkInfoImpl((Set)syntheticMethods, globalBeanDeclarations, (Map)entrypointSignatureToURL, methodToReplacements), (Object)entrypointMethods);
    }

    private static void dumpInfoOnUnhandledController(IClassHierarchy cha, IClass klass) {
        IClass springControllerKlass = cha.lookupClass(ImplementsControllerInfo.SPRING_CONTROLLER);
        if (springControllerKlass != null && cha.implementsInterface(klass, springControllerKlass)) {
            System.err.println("should handle Controller class " + klass.getName());
            IClass tmp = klass;
            while ((tmp = tmp.getSuperclass()) != null) {
                System.err.println("superclass " + tmp.getName());
                if (!tmp.getName().toString().startsWith("Lorg/springframework")) continue;
                break;
            }
        }
    }

    private static Set<BeanDecl> applyControllerInfo(SpringAppConfigInfo configInfo, IClassHierarchy cha, SpringURLInfo urlInfo, Properties options, String webContentDir, Set<ISyntheticMethod> syntheticMethods, Map<String, Set<String>> entrypointSignatureToURL, Set<BeanDecl> globalBeanDeclarations, Map<IMethod, SpringConfigFileInfo.SpringBeanInfo> entrypointMethods, SpringConfigFileInfo.SpringBeanInfo beanInfo, IClass klass, ISpringControllerInfo info) {
        String beanId = beanInfo.getId();
        if (beanId == null) {
            beanId = beanInfo.getNames().iterator().next();
        }
        String cleanedUpBeanId = beanId.replace('/', '_').replace('.', '_');
        Collection<SpringEntrypointInvokeInfo> allInvokeInfo = info.getSyntheticEntrypointMethods(klass, beanInfo, cleanedUpBeanId, JavaEEOptions.getPrecompilerInfo(options), webContentDir, configInfo);
        for (SpringEntrypointInvokeInfo invokeInfo : allInvokeInfo) {
            Set<String> urls;
            syntheticMethods.add(invokeInfo.getSyntheticMethod());
            globalBeanDeclarations = BeanDeclUtil.mergeDecls(globalBeanDeclarations, invokeInfo.getGlobalBeans(), cha);
            IMethod entrypoint = invokeInfo.getEntrypoint();
            if (entrypoint != null) {
                entrypointMethods.put(entrypoint, beanInfo);
            }
            if ((urls = urlInfo.getURLs(beanId, entrypoint != null ? entrypoint.getName().toString() : null)) == null) {
                urls = Collections.emptySet();
            }
            if (!urls.isEmpty()) {
                for (String theUrl : urls) {
                    TaintLogger.i().getLogger().info((Object)Messages.getString("framework.method.url", invokeInfo.getSyntheticMethod().getSignature(), theUrl));
                }
            }
            entrypointSignatureToURL.put(invokeInfo.getSyntheticMethod().getSignature(), urls);
        }
        return globalBeanDeclarations;
    }

    public static String createEntrypointVDBSignature(String id) {
        return VDBJavaUtil.jvmToVDBSignature("AppScan.Synthetic.Spring2_5." + id + "_entry(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;)V");
    }

    static {
        knownControllerInfo.add(new ExtendsSimpleFormControllerInfo());
        knownControllerInfo.add(new ExtendsAbstractWizardFormControllerInfo());
        knownControllerInfo.add(new ExtendsAbstractFormControllerInfo());
        knownControllerInfo.add(new ExtendsMultiActionControllerInfo());
        knownControllerInfo.add(new ImplementsControllerInfo());
    }
}

