/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.struts1;

import com.ibm.appscan.frameworks.analyzers.generic.CodeProcessor;
import com.ibm.appscan.frameworks.analyzers.struts1.AnalyzedBean;
import com.ibm.appscan.frameworks.analyzers.struts1.StrutsDynaBeanAnalyzer;
import com.ibm.appscan.frameworks.analyzers.struts1.StrutsForwardAnalyzer;
import com.ibm.appscan.frameworks.specinfo.CallSiteReplacement;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class StrutsCodeAnalyzer {
    public static final boolean verbose = false;
    private final IClassHierarchy cha;
    private final StrutsForwardAnalyzer forwardAnalyzer;
    private final StrutsDynaBeanAnalyzer dynaBeanAnalyzer;

    public StrutsCodeAnalyzer(IClassHierarchy cha, AnalysisCache cache, Set<String> actionClassNames, Set<String> actionClassesWithDynaBeans, Set<String> exceptionHandlerClassNames, Map<String, String> actionClassWithDynaBean2GlobalBeanName, Map<String, AnalyzedBean> actionClass2AnalyzedBean) {
        this.cha = cha;
        CodeProcessor codeProcessor = new CodeProcessor(cha, cache);
        this.forwardAnalyzer = StrutsForwardAnalyzer.make(cha, actionClassNames, exceptionHandlerClassNames);
        this.dynaBeanAnalyzer = StrutsDynaBeanAnalyzer.make(cha, actionClassesWithDynaBeans, actionClassWithDynaBean2GlobalBeanName, actionClass2AnalyzedBean);
        codeProcessor.addVisitor((CodeProcessor.ICodeVisitor)this.forwardAnalyzer);
        codeProcessor.addVisitor((CodeProcessor.ICodeVisitor)this.dynaBeanAnalyzer);
        codeProcessor.process();
    }

    public Collection<StrutsForwardAnalyzer.ForwardInfo> getPossibleForwards(String actionClass) {
        return this.forwardAnalyzer.getForwardInfoForClass(actionClass);
    }

    public Map<String, Set<CallSiteReplacement>> getReplacementsForDynaBeanAccesses() {
        return this.dynaBeanAnalyzer.getReplacementsForBeanAccesses();
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }
}

