/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.struts1;

import com.ibm.appscan.frameworks.analyzers.javaee.jsp.JspEntrypointResolver;
import com.ibm.appscan.frameworks.analyzers.struts1.AnalyzedStrutsAction;
import com.ibm.appscan.frameworks.specinfo.InvokeExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticExpr;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.strings.StringStuff;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class StrutsForwardUtil {
    private static final Logger logger = TaintLogger.i().getLogger();

    public static void addInvokeForForwardPath(Collection<AnalyzedStrutsAction> allActions, IClassHierarchy cha, List<SyntheticExpr> statements, String forwardPath, JspEntrypointResolver resolver, FilePositionInfo filePosInfo, int requestInd, int responseInd) {
        String trueForwardPath = StrutsForwardUtil.findTrueForwardPath(forwardPath, allActions);
        if (!trueForwardPath.endsWith(".jsp")) {
            logger.warn((Object)("Found forward to a non jsp file " + trueForwardPath));
            return;
        }
        InvokeExpr invoke = resolver.getInvokeForEntryOfPathTarget(trueForwardPath, filePosInfo, requestInd, responseInd);
        if (invoke != null) {
            String calleeSignature = VDBJavaUtil.vdb2JVMSignature(invoke.getCalleeVDBSignature());
            IMethod resolved = cha.resolveMethod(StringStuff.makeMethodReference((String)calleeSignature));
            if (resolved != null) {
                logger.info((Object)Messages.getString("framework.generate.call", calleeSignature));
                statements.add((SyntheticExpr)invoke);
            } else {
                logger.debug((Object)("could not resolve JSP entrypoint method " + calleeSignature));
            }
        }
    }

    static String findTrueForwardPath(String forwardPath, Collection<AnalyzedStrutsAction> allActions) {
        if (forwardPath.endsWith(".jsp")) {
            return forwardPath;
        }
        if (forwardPath.endsWith(".do")) {
            String strippedPath = forwardPath.substring(0, forwardPath.length() - 3);
            for (AnalyzedStrutsAction otherAction : allActions) {
                if (!otherAction.getPath().equals(strippedPath) || otherAction.getActionClass() == null || !otherAction.getActionClass().equals("org.apache.struts.actions.ForwardAction")) continue;
                return otherAction.getParameter();
            }
        }
        return forwardPath;
    }
}

