/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.java;

import com.ibm.appscan.frameworks.FileLocations;
import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.analyzers.javaee.CoreJavaEEFrameworkHandler;
import com.ibm.appscan.frameworks.analyzers.javaee.JavaEEOptions;
import com.ibm.appscan.frameworks.analyzers.spring.SpringFrameworkHandler;
import com.ibm.appscan.frameworks.analyzers.struts1.StrutsV1FrameworkHandler;
import com.ibm.appscan.frameworks.java.IJavaEEFrameworkHandler;
import com.ibm.appscan.frameworks.parsers.deploymentDescriptorParser.DOMBasedDeploymentDescriptorInfo;
import com.ibm.appscan.frameworks.parsers.deploymentDescriptorParser.IJavaEEDeploymentDescriptorInfo;
import com.ibm.appscan.frameworks.specinfo.FrameworkInfoImpl;
import com.ibm.appscan.frameworks.specinfo.IFrameworkInfo;
import com.ibm.appscan.frameworks.specinfo.WAFLSpecSerializer;
import com.ibm.appscan.frameworks.util.JavaFrameworkInfoUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.jstaint.util.scopes.ScopePruner;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.config.AnalysisScopeReader;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class WAFLSpecGen {
    private static final Logger logger = TaintLogger.i().getLogger();
    private final Collection<IJavaEEFrameworkHandler> handlers;
    private static final Collection<IJavaEEFrameworkHandler> BUILT_IN_HANDLERS = new ArrayList<IJavaEEFrameworkHandler>();

    public WAFLSpecGen(Collection<IJavaEEFrameworkHandler> handlers) {
        this.handlers = handlers;
    }

    public String getWAFLSpecForJavaEEApp(String scopeFileName, String exclusionsFileName, String webContentDir, Properties options) throws ClassHierarchyException, IOException, SAXException {
        Pair<IClassHierarchy, IFrameworkInfo> pair = this.getWAFLSpecAndCHAForJavaEEApp(scopeFileName, exclusionsFileName, webContentDir, options);
        return WAFLSpecSerializer.make((boolean)true).getFrameworkSpec((IFrameworkInfo)pair.snd);
    }

    public Pair<IClassHierarchy, IFrameworkInfo> getWAFLSpecAndCHAForJavaEEApp(String scopeFileName, String exclusionsFileName, String webContentDir, Properties options) throws ClassHierarchyException, IOException, SAXException {
        ClassHierarchy cha;
        AnalysisScope scope;
        File exclusionsFile = exclusionsFileName == null ? null : new File(exclusionsFileName);
        try {
            scope = AnalysisScopeReader.readJavaScope((String)scopeFileName, (File)exclusionsFile, (ClassLoader)WAFLSpecGen.class.getClassLoader());
            scope = ScopePruner.makeWithDefaultDepComputer().pruneScope(scope);
        }
        catch (IOException e) {
            logger.fatal((Object)"IOException while reading scope file or exclusions file", (Throwable)e);
            throw e;
        }
        try {
            cha = ClassHierarchy.make((AnalysisScope)scope);
        }
        catch (ClassHierarchyException e) {
            logger.fatal((Object)"ClassHierarchyException while constructing class hierarchy", (Throwable)e);
            Warning current = null;
            Iterator warn = Warnings.iterator();
            while (warn.hasNext()) {
                current = (Warning)warn.next();
                if (current == null || !current.toString().contains("No superclass found for")) continue;
                logger.fatal((Object)current.toString(), (Throwable)e);
            }
            throw e;
        }
        LangIndependentWalaUtil.logAllWarningsAndClear();
        IFrameworkInfo mergedFrameworkInfo = this.getWAFLSpecForJavaEEApp(scope, (IClassHierarchy)cha, webContentDir, options);
        return Pair.make((Object)cha, (Object)mergedFrameworkInfo);
    }

    public IFrameworkInfo getWAFLSpecForJavaEEApp(AnalysisScope scope, IClassHierarchy cha, String webContentDir, Properties options) throws ClassHierarchyException, IOException, SAXException {
        IJavaEEDeploymentDescriptorInfo ddInfo;
        try {
            ddInfo = WAFLSpecGen.getDDInfo(webContentDir);
            if (ddInfo == null) {
                logger.warn((Object)"No web.xml was found so built-in Spring, Struts and some Java EE handling have been skipped");
                return FrameworkInfoImpl.makeEmpty();
            }
        }
        catch (IOException e) {
            logger.warn((Object)"IOException while reading deployment descriptor, so built-in Spring, Struts and some Java EE handling have been skipped", (Throwable)e);
            return FrameworkInfoImpl.makeEmpty();
        }
        catch (SAXException e) {
            logger.warn((Object)"error parsing deployment descriptor, so built-in Spring, Struts and some Java EE handling have been skipped", (Throwable)e);
            return FrameworkInfoImpl.makeEmpty();
        }
        this.setServletsToIgnoreProperty(options, cha, ddInfo);
        ArrayList<IFrameworkInfo> collectedFrameworkInfo = new ArrayList<IFrameworkInfo>();
        for (IJavaEEFrameworkHandler handler : this.handlers) {
            collectedFrameworkInfo.add(handler.getFrameworkInfo(ddInfo, webContentDir, cha, options));
        }
        return JavaFrameworkInfoUtil.mergeJavaFrameworkInfo(collectedFrameworkInfo, cha);
    }

    private void setServletsToIgnoreProperty(Properties options, IClassHierarchy cha, IJavaEEDeploymentDescriptorInfo ddInfo) {
        HashSet allServletsToIgnore = HashSetFactory.make();
        for (IJavaEEFrameworkHandler handler : this.handlers) {
            allServletsToIgnore.addAll(handler.getServletsToIgnore(cha, ddInfo));
        }
        StringBuilder prop = new StringBuilder();
        Iterator iterator = allServletsToIgnore.iterator();
        while (iterator.hasNext()) {
            String servletName = (String)iterator.next();
            prop.append(servletName);
            if (!iterator.hasNext()) continue;
            prop.append(",");
        }
        options.setProperty(JavaEEOptions.SERVLETS_TO_IGNORE.getName(), prop.toString());
    }

    public static IJavaEEDeploymentDescriptorInfo getDDInfo(String webContentDir) throws IOException, SAXException {
        String webXMLFile = webContentDir + File.separator + "WEB-INF" + File.separator + "web.xml";
        if (!new File(webXMLFile).exists()) {
            return null;
        }
        return new DOMBasedDeploymentDescriptorInfo(webXMLFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateWAFLSpecForJavaEEApp(FileLocations fileLocs, Properties options) throws ClassHierarchyException, IOException, SAXException {
        String waflSpec = this.getWAFLSpecForJavaEEApp(fileLocs.getScopeFileName(), fileLocs.getExclusionsFileName(), fileLocs.getWebContentDir(), options);
        try (PrintWriter writer = null;){
            writer = new PrintWriter(fileLocs.getOutputWAFLFileName());
            writer.write(waflSpec);
        }
    }

    public static WAFLSpecGen makeWithDefaultHandlers() {
        return new WAFLSpecGen(BUILT_IN_HANDLERS);
    }

    static {
        BUILT_IN_HANDLERS.add(new CoreJavaEEFrameworkHandler());
        BUILT_IN_HANDLERS.add(new StrutsV1FrameworkHandler());
        BUILT_IN_HANDLERS.add(new SpringFrameworkHandler());
    }
}

