/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.parsers.strutsParser;

import com.ibm.appscan.frameworks.parsers.strutsParser.IAction;
import com.ibm.appscan.frameworks.parsers.strutsParser.IForward;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import java.util.ArrayList;
import java.util.List;

public class ActionImpl
extends IAction {
    private final String name;
    private final String path;
    private final String scope;
    private final String type;
    private final List<IForward> forwards;
    private final String forwardAttr;
    private final String parameter;
    private final FilePositionInfo filePosInfo;

    public ActionImpl(String name, String path, String scope, String type, List<IForward> forwards, String forwardsAttr, String parameters, FilePositionInfo filePosInfo) {
        this.name = name;
        this.path = path;
        this.scope = scope;
        this.type = type;
        this.forwards = forwards;
        this.forwardAttr = forwardsAttr;
        this.parameter = parameters;
        this.filePosInfo = filePosInfo;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.forwardAttr == null ? 0 : this.forwardAttr.hashCode());
        result = 31 * result + (this.forwards == null ? 0 : this.forwards.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.parameter == null ? 0 : this.parameter.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ActionImpl other = (ActionImpl)obj;
        if (this.forwardAttr == null ? other.forwardAttr != null : !this.forwardAttr.equals(other.forwardAttr)) {
            return false;
        }
        if (this.forwards == null ? other.forwards != null : !this.forwards.equals(other.forwards)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.parameter == null ? other.parameter != null : !this.parameter.equals(other.parameter)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    @Override
    public List<IForward> getForward() {
        return this.forwards;
    }

    @Override
    public String getForwardAttr() {
        return this.forwardAttr;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getParameter() {
        return this.parameter;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String toString() {
        return "Action [forwardAttr=" + this.forwardAttr + ", forwards=" + this.forwards + ", name=" + this.name + ", parameter=" + this.parameter + ", path=" + this.path + ", scope=" + this.scope + ", type=" + this.type + "]";
    }

    @Override
    public IAction replaceWildCard(String replacement) {
        return new ActionImpl(ActionImpl.replaceWC(this.name, replacement), this.replaceWCPath(replacement), ActionImpl.replaceWC(this.scope, replacement), ActionImpl.replaceWC(this.type, replacement), this.replaceForwards(replacement), ActionImpl.replaceWC(this.forwardAttr, replacement), ActionImpl.replaceWC(this.parameter, replacement), this.filePosInfo);
    }

    private List<IForward> replaceForwards(String replacement) {
        ArrayList<IForward> result = new ArrayList<IForward>();
        for (IForward f : this.forwards) {
            result.add(f.replaceWildCard(replacement));
        }
        return result;
    }

    private String replaceWCPath(String replacement) {
        if (this.path == null) {
            return null;
        }
        return this.path.replace("*", replacement);
    }

    public static String replaceWC(String s, String replacement) {
        if (s == null) {
            return s;
        }
        return s.replace("{1}", replacement);
    }

    @Override
    public FilePositionInfo getFilePositionInfo() {
        return this.filePosInfo;
    }
}

