/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.util;

import com.ibm.appscan.frameworks.specinfo.InvokeExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.util.strings.StringStuff;
import java.util.Map;

public class VDBJavaUtil {
    public static String jvmToVDBType(String jvmType) {
        return StringStuff.jvmToBinaryName((String)jvmType);
    }

    public static String vdbToJVMType(String vdbType) {
        return StringStuff.deployment2CanonicalTypeString((String)vdbType);
    }

    public static String jvmToVDBSignature(String jvmSig) {
        int ind = jvmSig.indexOf(40);
        String methodName = jvmSig.substring(0, ind);
        String descriptor = jvmSig.substring(ind);
        TypeName[] parameterTypeNames = StringStuff.parseForParameterNames((String)descriptor);
        TypeName returnType = StringStuff.parseForReturnTypeName((String)descriptor);
        StringBuilder result = new StringBuilder();
        result.append(methodName.replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
        result.append('(');
        if (parameterTypeNames != null) {
            for (int i = 0; i < parameterTypeNames.length; ++i) {
                String parameterType = VDBJavaUtil.jvmToVDBType(parameterTypeNames[i].toUnicodeString());
                result.append(parameterType);
                if (i >= parameterTypeNames.length - 1) continue;
                result.append(';');
            }
        }
        result.append("):");
        result.append(VDBJavaUtil.jvmToVDBType(returnType.toUnicodeString()));
        return result.toString();
    }

    public static String vdb2JVMSignature(String vdbSig) {
        int openParenInd = vdbSig.indexOf(40);
        String methodName = vdbSig.substring(0, openParenInd);
        String vdbDescriptor = vdbSig.substring(openParenInd);
        StringBuilder result = new StringBuilder();
        result.append(methodName.replaceAll("&lt;", "<").replaceAll("&gt;", ">"));
        result.append('(');
        int closeIndInDescriptor = vdbDescriptor.indexOf(41);
        String vdbParams = vdbDescriptor.substring(1, closeIndInDescriptor);
        String vdbReturn = vdbDescriptor.substring(closeIndInDescriptor + 2);
        if (!vdbParams.equals("")) {
            String[] vdbParamTypes = vdbParams.split(";");
            for (int i = 0; i < vdbParamTypes.length; ++i) {
                result.append(StringStuff.deployment2CanonicalDescriptorTypeString((String)vdbParamTypes[i]));
            }
        }
        result.append(')');
        result.append(StringStuff.deployment2CanonicalDescriptorTypeString((String)vdbReturn));
        return result.toString();
    }

    public static boolean isValidJVMSignature(String sig) {
        int openParenInd = sig.indexOf(40);
        String selector = sig.substring(openParenInd);
        return selector.indexOf(46) == -1;
    }

    public static InvokeExpr invokeFromJVMSig(FilePositionInfo filePosInfo, String calleeJVMSignature, Map<Integer, NonVoidSyntheticExpr> actualParameterPos2Value) {
        assert (VDBJavaUtil.isValidJVMSignature(calleeJVMSignature));
        return InvokeExpr.createInvokeExpr((FilePositionInfo)filePosInfo, (String)VDBJavaUtil.jvmToVDBSignature(calleeJVMSignature), actualParameterPos2Value);
    }
}

