/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.tomcat.compilers;

import com.hcl.appscan.discovery.java.utils.JDKHelper;
import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.model.IBuildInfo;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.utils.ClasspathUtil;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.discovery.jsp.compilers.ExternalJSPCompiler;
import com.ibm.appscan.discovery.tomcat.Messages;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Hashtable;

public class DefaultTomcatJSPCompiler
extends ExternalJSPCompiler {
    DefaultTomcatJSPCompiler() {
        super(new String[]{CommonCore.getDirectoryLocator().getProductRoot() + "tc/*"});
    }

    protected DefaultTomcatJSPCompiler(String[] classpathEntries) {
        super(classpathEntries);
    }

    public String getServerType() {
        return "TOMCAT";
    }

    protected String getCompilerClasspath() {
        return this.getServerClasspath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createInputFile() throws IOException {
        File file = new File(this.m_outDir.getParentFile(), "compiler.args");
        PrintStream out = new PrintStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), true, "UTF-8");
        try {
            String jspArgs;
            out.println(this.m_webapp.getPath());
            out.println(this.m_outDir.getPath());
            IBuildInfo info = this.m_proxy.getBuildInfo();
            String classpath = ClasspathUtil.joinPaths((String[])new String[]{info.getProperty("classpath"), info.getProperty("additional_classpath")});
            if (!classpath.isEmpty()) {
                out.println(classpath);
            }
            if ((jspArgs = info.getProperty("jsp_compiler_args")) != null && !jspArgs.isEmpty()) {
                out.println(jspArgs);
            } else {
                out.println("NoJSPArgs");
            }
            File file2 = file;
            return file2;
        }
        finally {
            IOUtil.close((Closeable)out);
        }
    }

    protected int mapRC(int rc) {
        if (DefaultTomcatJSPCompiler.class.equals(((Object)((Object)this)).getClass())) {
            if (rc == 0) {
                this.m_proxy.flagScanIncomplete(false);
            } else {
                this.m_proxy.flagScanIncomplete(true);
                this.m_proxy.getLogManager().log(new Message(2, Messages.getMessage("err.jsp.compiler.rc", rc)));
            }
            return 0;
        }
        return super.mapRC(rc);
    }

    protected boolean run(IProgress progress) throws Exception {
        String sharedJar = CommonCore.getDirectoryLocator().getLib() + "com.static.analyzer.shared.jar";
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("CLASSPATH", sharedJar + File.pathSeparator + this.getCompilerClasspath());
        String[] args = new String[]{JDKHelper.getJavaExec((IScanTargetMinProxy)this.m_proxy), "com.ibm.appscan.shared.utils.JasperRunner", this.createInputFile().getAbsolutePath()};
        if (this.compile(env, args) != 0) {
            return false;
        }
        this.initMappings(new File(this.m_outDir.getParentFile(), "web.xml"));
        return true;
    }
}

