/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.source.scanner.storage;

import com.hcl.appscan.source.scanner.Messages;
import com.hcl.appscan.source.scanner.logging.SourceCodeScannerException;
import com.hcl.appscan.source.scanner.storage.BlobResultStorage;
import com.hcl.appscan.source.scanner.storage.BlobScanStorage;
import com.hcl.appscan.source.scanner.storage.IScanStorage;
import com.hcl.appscan.source.scanner.utils.AzcopyRunner;
import com.ibm.appscan.common.logging.ILogManager;
import java.io.File;
import java.util.List;

public class BlobStorage
implements IScanStorage {
    private static final String QUOTE = "\"";
    private String m_scanId;
    private ILogManager m_logger;
    private String m_url;

    public BlobStorage(String asocScanId, ILogManager logger, String url) {
        this.m_scanId = asocScanId;
        this.m_logger = logger;
        this.m_url = url;
    }

    @Override
    public String storeFile(File file) throws SourceCodeScannerException {
        return new BlobScanStorage(this.m_scanId, this.m_logger, this.m_url).storeFile(file);
    }

    @Override
    public void retrieveFile(String identifier, File destination) throws SourceCodeScannerException {
        new BlobResultStorage(identifier, this.m_logger).getScanResult(destination);
    }

    @Override
    public void removeFromStorage(String identifier) throws SourceCodeScannerException {
    }

    protected void runAzCopy(List<String> args) throws SourceCodeScannerException {
        if (AzcopyRunner.run(args, this.m_logger) != 0) {
            throw new SourceCodeScannerException(Messages.getMessage("err.azcopy", new Object[0]));
        }
    }

    protected String getId() {
        return this.m_scanId;
    }

    protected String getUrl() {
        return this.m_url;
    }

    protected String getQuotedString(String string) {
        return QUOTE + string + QUOTE;
    }
}

