/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.callgraph.fieldbased;

import com.ibm.wala.cast.js.callgraph.fieldbased.FieldBasedCallGraphBuilder;
import com.ibm.wala.cast.js.callgraph.fieldbased.JSMethodInstructionVisitor;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.FlowGraph;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.FuncVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.VertexFactory;
import com.ibm.wala.cast.js.ssa.JavaScriptInvoke;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.types.AstMethodReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.MonitorUtil;
import java.util.Iterator;

public class PessimisticCallGraphBuilder
extends FieldBasedCallGraphBuilder {
    public PessimisticCallGraphBuilder(IClassHierarchy cha, AnalysisOptions options, AnalysisCache cache, boolean supportFullPointerAnalysis) {
        super(cha, options, cache, supportFullPointerAnalysis);
    }

    @Override
    public FlowGraph buildFlowGraph(MonitorUtil.IProgressMonitor monitor) {
        FlowGraph flowgraph = this.flowGraphFactory();
        this.resolveLocalCalls(flowgraph);
        return flowgraph;
    }

    protected boolean filterFunction(IMethod function) {
        return function.getDescriptor().equals((Object)AstMethodReference.fnDesc);
    }

    private void resolveLocalCalls(FlowGraph flowgraph) {
        for (IClass klass : this.cha) {
            for (IMethod method : klass.getDeclaredMethods()) {
                if (!this.filterFunction(method)) continue;
                IR ir = this.cache.getIR(method);
                ir.visitAllInstructions((SSAInstruction.Visitor)new LocalCallSSAVisitor(method, ir.getSymbolTable(), this.cache.getDefUse(ir), flowgraph));
            }
        }
    }

    private class LocalCallSSAVisitor
    extends JSMethodInstructionVisitor {
        private final FlowGraph flowgraph;
        private final VertexFactory factory;
        private final FuncVertex caller;

        public LocalCallSSAVisitor(IMethod method, SymbolTable symtab, DefUse du, FlowGraph flowgraph) {
            super(method, symtab, du);
            this.flowgraph = flowgraph;
            this.factory = flowgraph.getVertexFactory();
            this.caller = this.factory.makeFuncVertex(method.getDeclaringClass());
        }

        @Override
        public void visitJavaScriptInvoke(JavaScriptInvoke invk) {
            if (this.isFunctionConstructorInvoke(invk)) {
                int defn = invk.getDef();
                String fnName = this.symtab.getStringValue(invk.getUse(1));
                if (fnName == null || fnName.trim().length() == 0) {
                    return;
                }
                IClass fnClass = PessimisticCallGraphBuilder.this.cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)JavaScriptTypes.jsLoader, (String)fnName));
                if (fnClass == null) {
                    System.err.println("cannot find " + fnName + " at " + ((AstMethod)this.method).getSourcePosition());
                    return;
                }
                IMethod fn = fnClass.getMethod(AstMethodReference.fnSelector);
                FuncVertex callee = this.factory.makeFuncVertex(fnClass);
                Iterator uses = this.du.getUses(defn);
                while (uses.hasNext()) {
                    SSAInstruction use = (SSAInstruction)uses.next();
                    if (use instanceof JavaScriptInvoke && ((JavaScriptInvoke)use).getFunction() == defn) {
                        JavaScriptInvoke use_invk = (JavaScriptInvoke)use;
                        for (int i = 2; i < use_invk.getNumberOfParameters(); ++i) {
                            this.flowgraph.addEdge(this.factory.makeVarVertex(this.caller, use_invk.getUse(i)), this.factory.makeParamVertex(callee, i));
                        }
                        this.flowgraph.addEdge(this.factory.makeRetVertex(callee), this.factory.makeVarVertex(this.caller, use.getDef()));
                        continue;
                    }
                    for (int i = 1; i < fn.getNumberOfParameters(); ++i) {
                        this.flowgraph.addEdge(this.factory.makeUnknownVertex(), this.factory.makeParamVertex(callee, i));
                    }
                    this.flowgraph.addEdge(this.factory.makeRetVertex(callee), this.factory.makeUnknownVertex());
                }
            } else {
                SSAInstruction def = this.du.getDef(invk.getFunction());
                if (!(def instanceof JavaScriptInvoke) || !this.isFunctionConstructorInvoke((JavaScriptInvoke)def)) {
                    for (int i = 1; i < invk.getNumberOfParameters(); ++i) {
                        this.flowgraph.addEdge(this.factory.makeVarVertex(this.caller, invk.getUse(i)), this.factory.makeUnknownVertex());
                    }
                    this.flowgraph.addEdge(this.factory.makeUnknownVertex(), this.factory.makeVarVertex(this.caller, invk.getDef()));
                }
            }
        }
    }
}

