/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.client;

import com.ibm.wala.cast.ipa.callgraph.CAstAnalysisScope;
import com.ibm.wala.cast.ir.ssa.AstIRFactory;
import com.ibm.wala.cast.js.client.impl.ZeroCFABuilderFactory;
import com.ibm.wala.cast.js.ipa.callgraph.JSAnalysisOptions;
import com.ibm.wala.cast.js.ipa.callgraph.JavaScriptEntryPoints;
import com.ibm.wala.cast.js.loader.JavaScriptLoader;
import com.ibm.wala.cast.js.loader.JavaScriptLoaderFactory;
import com.ibm.wala.cast.js.translator.JavaScriptTranslatorFactory;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.cast.loader.SingleClassLoaderFactory;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.SourceModule;
import com.ibm.wala.client.AbstractAnalysisEngine;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.cha.ClassHierarchy;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.debug.Assertions;
import java.io.IOException;
import java.util.Collections;
import java.util.jar.JarFile;

public class JavaScriptAnalysisEngine
extends AbstractAnalysisEngine {
    protected JavaScriptLoaderFactory loaderFactory;
    protected JavaScriptTranslatorFactory translatorFactory;

    public void buildAnalysisScope() {
        try {
            this.loaderFactory = new JavaScriptLoaderFactory(this.translatorFactory);
            SourceModule[] files = this.moduleFiles.toArray(new SourceModule[this.moduleFiles.size()]);
            this.scope = new CAstAnalysisScope(files, (SingleClassLoaderFactory)this.loaderFactory, Collections.singleton(JavaScriptLoader.JS));
        }
        catch (IOException e) {
            Assertions.UNREACHABLE((String)e.toString());
        }
    }

    public IClassHierarchy buildClassHierarchy() {
        try {
            return ClassHierarchy.make((AnalysisScope)this.getScope(), (ClassLoaderFactory)this.loaderFactory, (Language)JavaScriptLoader.JS);
        }
        catch (ClassHierarchyException e) {
            Assertions.UNREACHABLE((String)e.toString());
            return null;
        }
    }

    public void setTranslatorFactory(JavaScriptTranslatorFactory factory) {
        this.translatorFactory = factory;
    }

    public void setJ2SELibraries(JarFile[] libs) {
        Assertions.UNREACHABLE((String)"Illegal to call setJ2SELibraries");
    }

    public void setJ2SELibraries(Module[] libs) {
        Assertions.UNREACHABLE((String)"Illegal to call setJ2SELibraries");
    }

    protected Iterable<Entrypoint> makeDefaultEntrypoints(AnalysisScope scope, IClassHierarchy cha) {
        return new JavaScriptEntryPoints(cha, cha.getLoader(JavaScriptTypes.jsLoader));
    }

    public AnalysisCache makeDefaultCache() {
        return new AnalysisCache(AstIRFactory.makeDefaultFactory());
    }

    public AnalysisOptions getDefaultOptions(Iterable<Entrypoint> roots) {
        AnalysisOptions options = new AnalysisOptions(this.scope, roots);
        options.setUseConstantSpecificKeys(true);
        options.setUseStacksForLexicalScoping(true);
        return options;
    }

    protected CallGraphBuilder getCallGraphBuilder(IClassHierarchy cha, AnalysisOptions options, AnalysisCache cache) {
        return new ZeroCFABuilderFactory().make((JSAnalysisOptions)options, cache, cha, this.scope, false);
    }
}

