/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.translator;

import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.AbstractSourcePosition;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public class RangePosition
extends AbstractSourcePosition
implements CAstSourcePositionMap.Position {
    private final URL url;
    private final int line;
    private final int startOffset;
    private final int endOffset;

    public RangePosition(URL url, int line, int startOffset, int endOffset) {
        this.url = url;
        this.line = line;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    public int compareTo(Object o) {
        CAstSourcePositionMap.Position other = (CAstSourcePositionMap.Position)o;
        if (this.startOffset != other.getFirstOffset()) {
            return this.startOffset - other.getFirstOffset();
        }
        return this.endOffset - other.getLastOffset();
    }

    public int getFirstLine() {
        return this.line;
    }

    public int getLastLine() {
        return -1;
    }

    public int getFirstCol() {
        return -1;
    }

    public int getLastCol() {
        return -1;
    }

    public int getFirstOffset() {
        return this.startOffset;
    }

    public int getLastOffset() {
        return this.endOffset;
    }

    public URL getURL() {
        return this.url;
    }

    public Reader getReader() throws IOException {
        return new InputStreamReader(this.url.openStream());
    }
}

