/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class SafeURL {
    private final URL url;
    private int hashCode = -1;

    public SafeURL(String urlStr) throws MalformedURLException {
        this.url = new URL(urlStr);
    }

    public SafeURL(URL url) {
        this.url = url;
    }

    public SafeURL(String protocol, String host, String file) throws MalformedURLException {
        this.url = new URL(protocol, host, file);
    }

    public SafeURL(String protocol, String host, int port, String file) throws MalformedURLException {
        this.url = new URL(protocol, host, port, file);
    }

    public URLConnection openConnection() throws IOException {
        return this.url.openConnection();
    }

    public String toExternalForm() {
        return this.url.toExternalForm();
    }

    public String getProtocol() {
        return this.url.getProtocol();
    }

    public String getHost() {
        return this.url.getHost();
    }

    public String getPath() {
        return this.url.getPath();
    }

    public String getFile() {
        return this.url.getFile();
    }

    public int getPort() {
        return this.url.getPort();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SafeURL) {
            SafeURL other = (SafeURL)obj;
            return this.hashCode() == other.hashCode();
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.computeHashCode();
        }
        return this.hashCode;
    }

    private int computeHashCode() {
        String file;
        String host;
        int ret = 0;
        String protocol = this.url.getProtocol();
        if (protocol != null) {
            ret += protocol.hashCode();
        }
        if ((host = this.url.getHost()) != null) {
            ret += host.toLowerCase().hashCode();
        }
        if ((file = this.url.getFile()) != null) {
            ret += file.hashCode();
        }
        ret = this.url.getPort() == -1 ? (ret += 8080) : (ret += this.url.getPort());
        String ref = this.url.getRef();
        if (ref != null) {
            ret += ref.hashCode();
        }
        return ret;
    }

    public URL getInnerURL() {
        return this.url;
    }

    public String toString() {
        return this.url.toString();
    }
}

