/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.exclude.exclusions;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.exclude.exclusions.ExclusionException;
import com.ibm.appscan.exclude.exclusions.ExclusionWriter;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.security.annotation.SuppressSecurityTrace;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public abstract class BaseExclusion {
    private HashSet<String> m_included_packages;
    private HashSet<String> m_excluded_packages;
    private HashSet<String> m_included_classes;
    private HashSet<String> m_excluded_classes;
    private HashSet<String> m_included_methods;
    private HashSet<String> m_excluded_methods;
    private HashSet<String> m_files;
    private HashSet<String> m_exclude_auto;
    private HashMap<String, Boolean> m_excluded_cache = new HashMap();

    public BaseExclusion() throws ExclusionException {
        VdbProvider.setRestMode((boolean)false);
    }

    public void reset() throws ExclusionException {
        this.m_included_packages = null;
        this.m_excluded_packages = null;
        this.m_included_classes = null;
        this.m_excluded_classes = null;
        this.m_included_methods = null;
        this.m_excluded_methods = null;
        this.m_files = null;
        this.m_excluded_cache = null;
    }

    public abstract Language.LANGUAGE getExclusionLanguage();

    public abstract boolean hasPackages();

    public abstract boolean hasClasses();

    public abstract boolean hasMethods();

    public abstract boolean hasFiles();

    public void save() throws ExclusionException {
        ExclusionWriter w = new ExclusionWriter(this);
        w.write();
    }

    public boolean isExcluded(String signature) throws ExclusionException {
        if (this.m_excluded_cache.containsKey(signature)) {
            return this.m_excluded_cache.get(signature);
        }
        this.m_excluded_cache.put(signature, false);
        if (this.hasPackages() && this.isPackageExcluded(signature)) {
            this.m_excluded_cache.put(signature, true);
        }
        if (!this.m_excluded_cache.get(signature).booleanValue() && this.hasClasses() && this.isClassExcluded(signature)) {
            this.m_excluded_cache.put(signature, true);
        }
        if (!this.m_excluded_cache.get(signature).booleanValue() && this.hasMethods() && this.isMethodExcluded(signature)) {
            this.m_excluded_cache.put(signature, true);
        }
        if (!this.m_excluded_cache.get(signature).booleanValue() && this.hasFiles() && this.isFileExcluded(new File(signature))) {
            this.m_excluded_cache.put(signature, true);
        }
        return this.m_excluded_cache.get(signature);
    }

    public boolean isPackageExcluded(String pack) throws ExclusionException {
        StringBuilder str = new StringBuilder();
        if (!this.getIncludedPackages().isEmpty()) {
            for (char c : pack.toCharArray()) {
                str.append(c);
                if (!this.getIncludedPackages().contains(str.toString())) continue;
                return false;
            }
            return true;
        }
        for (char c : pack.toCharArray()) {
            str.append(c);
            if (!this.getExcludedPackages().contains(str.toString())) continue;
            return true;
        }
        return false;
    }

    public boolean isClassExcluded(String c) throws ExclusionException {
        if (this.isPackageExcluded(c)) {
            return true;
        }
        if (!this.getIncludedClasses().isEmpty()) {
            for (String str : this.getIncludedClasses()) {
                if (!c.equals(str)) continue;
                return false;
            }
            return true;
        }
        for (String str : this.getExcludedClasses()) {
            if (!c.equals(str)) continue;
            return true;
        }
        return false;
    }

    public boolean isMethodExcluded(String method) throws ExclusionException {
        return !this.getIncludedMethods().isEmpty() && !this.getIncludedMethods().contains(method) || this.getExcludedMethods().contains(method);
    }

    public boolean isFileExcluded(File file) throws ExclusionException {
        for (String excluded_entry : this.getExcludedFiles()) {
            if (excluded_entry.isEmpty() || !file.getPath().contains(excluded_entry)) continue;
            return true;
        }
        return false;
    }

    public HashSet<String> getIncludedPackages() throws ExclusionException {
        if (this.m_included_packages == null) {
            this.m_included_packages = new HashSet();
        }
        return this.m_included_packages;
    }

    @SuppressSecurityTrace
    public HashSet<String> getExcludedPackages() throws ExclusionException {
        if (this.m_excluded_packages == null) {
            this.m_excluded_packages = new HashSet();
        }
        return this.m_excluded_packages;
    }

    public HashSet<String> getIncludedClasses() throws ExclusionException {
        if (this.m_included_classes == null) {
            this.m_included_classes = new HashSet();
        }
        return this.m_included_classes;
    }

    public HashSet<String> getExcludedClasses() throws ExclusionException {
        if (this.m_excluded_classes == null) {
            this.m_excluded_classes = new HashSet();
        }
        return this.m_excluded_classes;
    }

    public HashSet<String> getIncludedMethods() throws ExclusionException {
        if (this.m_included_methods == null) {
            this.m_included_methods = new HashSet();
        }
        return this.m_included_methods;
    }

    public HashSet<String> getExcludedMethods() throws ExclusionException {
        if (this.m_excluded_methods == null) {
            this.m_excluded_methods = new HashSet();
        }
        return this.m_excluded_methods;
    }

    public HashSet<String> getExcludedFiles() throws ExclusionException {
        if (this.m_files == null) {
            this.m_files = new HashSet();
        }
        return this.m_files;
    }

    public boolean isExcludedFromAutoMarkup(Method m) throws ExclusionException {
        if (this.hasPackages() && m.getPackageName() != null && m.getPackageName().length() > 0) {
            for (String s : this.getAutoMarkupPackages()) {
                if (!m.getPackageName().startsWith(s)) continue;
                return true;
            }
        }
        return false;
    }

    public HashSet<String> getAutoMarkupPackages() throws ExclusionException {
        if (this.m_exclude_auto == null) {
            this.m_exclude_auto = new HashSet();
        }
        return this.m_exclude_auto;
    }

    public void addPackageIncludes(Collection<String> includes) throws ExclusionException {
        this.getIncludedPackages().addAll(includes);
    }

    public void addPackageExcludes(Collection<String> excludes) throws ExclusionException {
        this.getExcludedPackages().addAll(excludes);
    }

    public void addClassIncludes(Collection<String> includes) throws ExclusionException {
        this.getIncludedClasses().addAll(includes);
    }

    public void addClassExcludes(Collection<String> excludes) throws ExclusionException {
        this.getExcludedClasses().addAll(excludes);
    }

    public void addMethodIncludes(Collection<String> includes) throws ExclusionException {
        this.getIncludedMethods().addAll(includes);
    }

    public void addMethodExcludes(Collection<String> excludes) throws ExclusionException {
        this.getExcludedMethods().addAll(excludes);
    }
}

