/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.ifa.common;

import com.hcl.appscan.ifa.common.IIfaLayer;
import com.hcl.appscan.ifa.common.IfaAssessment;
import com.hcl.appscan.ifa.common.IfaTarget;
import com.ibm.appscan.assessment.model.Finding;
import java.util.ArrayList;
import java.util.function.Predicate;

public class IfaQueue
implements IIfaLayer {
    private ArrayList<IfaPair> m_list = new ArrayList();

    public IfaQueue register(IIfaLayer ifa, Predicate<Finding> p) {
        this.m_list.add(new IfaPair(ifa, p));
        return this;
    }

    public IfaAssessment applyIfa(IfaAssessment a) {
        IfaTarget t = new IfaTarget(a);
        for (IfaPair pair : this.m_list) {
            IfaTarget slice = t.slice(pair.m_predicate);
            a.newRow(pair.m_ifa.getIfaName(), slice.size());
            pair.m_ifa.applyIfa(slice);
        }
        return a;
    }

    @Override
    public void close() throws Exception {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (IfaPair p : this.m_list) {
            try {
                p.m_ifa.close();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (exceptions.isEmpty()) {
            return;
        }
        throw (Exception)exceptions.get(0);
    }

    @Override
    public void applyIfa(IfaTarget t) {
        for (IfaPair pair : this.m_list) {
            IfaTarget slice = t.slice(pair.m_predicate);
            pair.m_ifa.applyIfa(slice);
        }
    }

    @Override
    public String getIfaName() {
        ArrayList<String> arr = new ArrayList<String>();
        arr.add(this.getClass().getSimpleName());
        this.m_list.forEach(p -> arr.add(((IfaPair)p).m_ifa.getIfaName()));
        return String.join((CharSequence)"/ ", arr);
    }

    private class IfaPair {
        private IIfaLayer m_ifa;
        private Predicate<Finding> m_predicate;

        private IfaPair(IIfaLayer ifa, Predicate<Finding> p) {
            this.m_ifa = ifa;
            this.m_predicate = p;
        }
    }
}

