/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.exception.BadMarkupException;

public abstract class VdbArtifact {
    private String m_simplePackName;
    private String m_framework;
    private Language.LANGUAGE m_lang;
    private String m_class;

    public VdbArtifact() {
    }

    public VdbArtifact(Language.LANGUAGE lang) {
        this.m_lang = lang;
    }

    public Language.LANGUAGE getLang() {
        return this.m_lang;
    }

    public void setLang(Language.LANGUAGE lang) {
        this.m_lang = lang;
    }

    public String getPackageName() {
        return this.m_simplePackName;
    }

    public void setPackageName(String name) {
        this.m_simplePackName = name;
    }

    public String getFramework() {
        return this.m_framework;
    }

    public void setFramework(String framework) {
        this.m_framework = framework;
    }

    public void setClassName(String name) {
        this.m_class = name != null && name.length() > 255 ? name.substring(0, 255) : name;
    }

    public String getClassName() {
        return this.m_class != null ? this.m_class : "";
    }

    public abstract void reset();

    public abstract void replace(VdbArtifact var1) throws BadMarkupException;

    public abstract boolean merge(VdbArtifact var1) throws BadMarkupException;

    public String getClassId() {
        if (this.getPackageName() != null && this.getPackageName().length() > 0) {
            return this.getPackageName();
        }
        return this.getClassName();
    }
}

