/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.data;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.Language;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.vdb.data.Vdb;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.VdbProvider;
import com.ibm.appscan.vdb.provider.data.file.load.VdbReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class VdbFile
extends Vdb {
    private File m_file;

    public VdbFile(Language.LANGUAGE lang, File f) {
        super(lang);
        try {
            if (f.exists()) {
                VdbReader r = new VdbReader(new FileInputStream(f));
                r.parse();
                if (r.getVdb() != null) {
                    this.setLang(r.getVdb().getLang());
                    for (Method m : r.getVdb().getMethods()) {
                        this.addMethod(m);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            CommonCore.getLogManager().log(new Message((Throwable)e));
        }
        catch (VDBGeneralException e) {
            CommonCore.getLogManager().log(new Message((Throwable)e));
        }
        catch (BadMarkupException e) {
            CommonCore.getLogManager().log(new Message((Throwable)e));
        }
        this.m_file = f;
    }

    @Override
    public void save(VDBEnums.BUCKET b) throws VDBGeneralException {
        VdbProvider.saveVdb((Vdb)this, this.m_file);
    }

    public File getFile() {
        return this.m_file;
    }
}

