/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.exception;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.vdb.provider.VdbProvider;
import java.io.File;
import java.util.ArrayList;

public class VDBException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static String STRING_ERROR = "Error:";
    private final int LINES = 25;
    protected ArrayList<ExceptionDetail> exceptionChildren = new ArrayList();
    private Throwable m_cause;

    public VDBException(String error, Object ... params) {
        super(new Exception());
        this.m_cause = new Throwable(VdbProvider.getString(error, params));
        this.addExceptionDetail(VdbProvider.getString(error, params), new Object[0]);
    }

    public VDBException(Throwable cause, String error, Object ... params) {
        super(new Exception());
        this.m_cause = cause;
        this.addExceptionDetail(VdbProvider.getString(error, params), new Object[0]);
    }

    public VDBException(Throwable cause) {
        this.m_cause = cause;
    }

    public ExceptionDetail addExceptionDetail(String error, Object ... params) {
        ExceptionDetail ed = new ExceptionDetail(VdbProvider.getString(error, params));
        this.exceptionChildren.add(ed);
        return ed;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getMessageDetail());
        int counter = 0;
        for (StackTraceElement e : this.m_cause.getStackTrace()) {
            str.append(VdbProvider.getString("\t\t {0}", e.getClassName() + "." + e.getMethodName() + "(" + e.getFileName() + ":" + e.getLineNumber() + ")"));
            str.append(File.separator);
            str.append(System.getProperty("line.separator"));
            if (++counter > 25) break;
        }
        return str.toString();
    }

    public void logException() {
        CommonCore.getLogManager().log(new Message(4, this.toString()));
    }

    private String getMessageDetail() {
        StringBuilder str = new StringBuilder(150);
        for (ExceptionDetail child : this.exceptionChildren) {
            str.append(STRING_ERROR + child.getError());
            str.append(System.getProperty("line.separator"));
        }
        if (this.m_cause.getLocalizedMessage() != null) {
            str.append(this.m_cause.getLocalizedMessage());
            str.append(System.getProperty("line.separator"));
        }
        return str.toString();
    }

    @Override
    public void printStackTrace() {
        this.logException();
    }

    protected boolean fullInfo() {
        return false;
    }

    private class ExceptionDetail {
        private String m_error = null;

        private ExceptionDetail(String error) {
            this.m_error = error;
        }

        public String getError() {
            return this.m_error;
        }
    }
}

