/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.method;

import com.ibm.appscan.common.Language;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.method.Method;
import com.ibm.appscan.vdb.method.markup.Taint;
import java.util.HashMap;
import java.util.regex.Pattern;

public class DotNetMethod
extends Method {
    private static final long serialVersionUID = -881445019360887110L;
    private static Pattern m_dot_net_pattern = Pattern.compile("(\\S+?\\.[\\S|\\s]+?\\([\\S|\\s]*?\\):[\\S|\\s]+?)");
    private static HashMap<String, String> m_dotNetType;
    private static HashMap<String, String> m_dotNetSimpleType;
    private static Pattern s_remove_comma_generics;
    private static Pattern s_remove_nested_generics;
    private static Pattern s_remove_extra_lt;
    private static Pattern s_fix_object_model_generic;
    private static Pattern s_fix_collections_generic;

    public DotNetMethod(String sig) throws BadMarkupException {
        super(sig, Language.LANGUAGE.DOT_NET);
        this.setSignature(DotNetMethod.getNormalizedSig(sig));
    }

    @Override
    public Pattern getPatternMatch() {
        return m_dot_net_pattern;
    }

    @Override
    public boolean addTaint(Taint t) throws BadMarkupException {
        if (this.getArgString().equals("*")) {
            if (!(t.getSourceParam().isNone() || t.getSourceParam().isAll() || t.getSourceParam().isThis())) {
                t.setSourceParam("default");
            }
            if (!(t.getDstParam().isNone() || t.getDstParam().isAll() || t.getDstParam().isThis())) {
                t.setDstParam("default");
            }
        }
        return super.addTaint(t);
    }

    @Override
    public void setSignature(String sig) throws BadMarkupException {
        super.setSignature(sig);
        this.setClassName(DotNetMethod.getClass(sig));
        this.setPackageName(DotNetMethod.getPackage(sig));
        this.setMethodName(this.getMethodName(sig));
    }

    @Override
    protected boolean isConstructor_() {
        return false;
    }

    @Override
    protected boolean isGetter_() {
        return this.getSignature().contains("get_");
    }

    @Override
    protected boolean isSetter_() {
        return this.getSignature().contains("set_");
    }

    public static String getFqnType(String type) {
        if (type.endsWith("[]") && DotNetMethod.getDotNetSimpleTypes().containsKey(type.subSequence(0, type.length() - 2))) {
            return DotNetMethod.getDotNetSimpleTypes().get(type.subSequence(0, type.length() - 2)) + "[]";
        }
        if (DotNetMethod.getDotNetSimpleTypes().containsKey(type)) {
            return DotNetMethod.getDotNetSimpleTypes().get(type);
        }
        return type;
    }

    public static HashMap<String, String> getDotNetTypes() {
        if (m_dotNetType == null) {
            m_dotNetType = new HashMap();
            m_dotNetType.put("System.Void", "void");
            m_dotNetType.put("System.Object", "object");
            m_dotNetType.put("System.String", "string");
            m_dotNetType.put("System.Boolean", "bool");
            m_dotNetType.put("System.Byte", "byte");
            m_dotNetType.put("System.SByte", "sbyte");
            m_dotNetType.put("System.Int16", "short");
            m_dotNetType.put("System.UInt16", "unsigned short");
            m_dotNetType.put("System.Int32", "int");
            m_dotNetType.put("System.UInt32", "unsigned int");
            m_dotNetType.put("System.Int64", "long");
            m_dotNetType.put("System.UInt64", "unsigned long");
            m_dotNetType.put("System.Single", "float");
            m_dotNetType.put("System.Double", "double");
            m_dotNetType.put("System.IntPtr", "native signed int");
            m_dotNetType.put("System.UIntPtr", "native unsigned int");
            m_dotNetType.put("System.Char", "char");
            m_dotNetType.put("System.Void", "void");
        }
        return m_dotNetType;
    }

    public static HashMap<String, String> getDotNetSimpleTypes() {
        if (m_dotNetSimpleType == null) {
            m_dotNetSimpleType = new HashMap();
            m_dotNetSimpleType.put("void", "System.Void");
            m_dotNetSimpleType.put("object", "System.Object");
            m_dotNetSimpleType.put("string", "System.String");
            m_dotNetSimpleType.put("bool", "System.Boolean");
            m_dotNetSimpleType.put("byte", "System.Byte");
            m_dotNetSimpleType.put("uint8", "System.Byte");
            m_dotNetSimpleType.put("sbyte", "System.SByte");
            m_dotNetSimpleType.put("int8", "System.SByte");
            m_dotNetSimpleType.put("short", "System.Int16");
            m_dotNetSimpleType.put("unsigned short", "System.UInt16");
            m_dotNetSimpleType.put("int", "System.Int32");
            m_dotNetSimpleType.put("int16", "System.Int16");
            m_dotNetSimpleType.put("int32", "System.Int32");
            m_dotNetSimpleType.put("unsigned int", "System.UInt32");
            m_dotNetSimpleType.put("long", "System.Int64");
            m_dotNetSimpleType.put("int64", "System.Int64");
            m_dotNetSimpleType.put("unsigned long", "System.UInt64");
            m_dotNetSimpleType.put("uint64", "System.UInt64");
            m_dotNetSimpleType.put("float", "System.Single");
            m_dotNetSimpleType.put("double", "System.Double");
            m_dotNetSimpleType.put("native signed int", "System.IntPtr");
            m_dotNetSimpleType.put("native unsigned int", "System.UIntPtr");
            m_dotNetSimpleType.put("char", "System.Char");
            m_dotNetSimpleType.put("void", "System.Void");
        }
        return m_dotNetSimpleType;
    }

    public static String getNormalizedSig(String sig) {
        if (!(sig.contains("external_source") || sig.contains("external_taint") || sig.contains("automatic_callback_source"))) {
            StringBuffer signature = new StringBuffer();
            boolean arg = false;
            boolean found_arg = false;
            boolean found_trailing_open = false;
            boolean close_opening = false;
            boolean open_arrow = false;
            boolean star_count = false;
            sig = DotNetMethod.cleansGenericsFromSignature(sig);
            StringBuffer str = new StringBuffer();
            str.append(sig.substring(0, sig.indexOf("(")));
            int i = 0;
            str.append("(");
            for (String a : DotNetMethod.getNormalizedArgs(sig.substring(sig.indexOf("(") + 1, sig.indexOf(")")))) {
                str.append(DotNetMethod.getFqnType(a));
                str.append(";");
                ++i;
            }
            if (i > 0) {
                str.deleteCharAt(str.length() - 1);
            }
            str.append(")");
            str.append(":");
            str.append(DotNetMethod.getFqnType(sig.substring(sig.lastIndexOf(":") + 1)));
            sig = str.toString();
        }
        return sig;
    }

    private static String cleansGenericsFromSignature(String sig) {
        String name = DotNetMethod.cleanseGenericFromSignatureName(sig.substring(0, sig.indexOf("(")));
        String args = sig.substring(sig.indexOf("(") + 1, sig.indexOf(")"));
        String return_string = sig.substring(sig.indexOf("):") + 2);
        StringBuilder ret = new StringBuilder();
        ret.append(name);
        ret.append("(");
        if (name.startsWith("System.Collections.Generic.Collection") || name.startsWith("System.Collections.ObjectModel.Model")) {
            ret.append("*");
        } else {
            ret.append(DotNetMethod.cleanseGenericsFromString(args));
        }
        ret.append("):");
        ret.append(DotNetMethod.cleanseGenericsFromString(return_string));
        return ret.toString();
    }

    private static String cleanseGenericFromSignatureName(String name) {
        name = DotNetMethod.cleanseGenericsFromString(name);
        name = s_fix_object_model_generic.matcher(name).replaceAll("System.Collections.ObjectModel.Model.");
        name = s_fix_collections_generic.matcher(name).replaceAll("System.Collections.Generic.Collection.$1");
        return name;
    }

    private static String cleanseGenericsFromString(String str) {
        str = s_remove_comma_generics.matcher(str).replaceAll("<*>");
        str = s_remove_nested_generics.matcher(str).replaceAll("<*>");
        str = s_remove_extra_lt.matcher(str).replaceAll(">");
        return str;
    }

    static {
        s_remove_comma_generics = Pattern.compile("<.*?(,.+)+>");
        s_remove_nested_generics = Pattern.compile("<(?!\\*).*?>");
        s_remove_extra_lt = Pattern.compile(">>");
        s_fix_object_model_generic = Pattern.compile("(System\\.Collections\\.ObjectModel\\..*?\\.)");
        s_fix_collections_generic = Pattern.compile("^System\\.Collections\\.Generic\\..*\\.(.*?)$");
    }
}

