/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.method.markup.ao;

import com.ibm.appscan.vdb.VdbArtifact;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.method.markup.MarkupBase;
import com.ibm.appscan.vdb.method.markup.Parameter;
import com.ibm.appscan.vdb.misc.VDBEnums;
import com.ibm.appscan.vdb.provider.EnumProvider;
import com.ibm.appscan.vdb.provider.VdbProvider;

public class Option
extends MarkupBase
implements Comparable<Option> {
    private VDBEnums.OPTION_NAME m_option_name;
    private Parameter m_parameter;
    private String m_value;
    private VDBEnums.OPTION_OPERATOR m_operator;
    private VDBEnums.OPTION_CONFIDENCE m_min = VDBEnums.OPTION_CONFIDENCE.NULL;
    private VDBEnums.OPTION_CONFIDENCE m_max = VDBEnums.OPTION_CONFIDENCE.NULL;

    public void setOptionName(VDBEnums.OPTION_NAME name) throws BadMarkupException {
        if (this.getOptionOperator() != null) {
            this.checkOptionNameAndOperator(name, this.getOptionOperator());
        }
        this.m_option_name = name;
    }

    public VDBEnums.OPTION_NAME getOptionName() {
        return this.m_option_name;
    }

    public Parameter getParameter() {
        return this.m_parameter;
    }

    public void setParameter(String param) throws BadMarkupException {
        this.m_parameter = new Parameter(param);
    }

    public String getOptionValue() {
        return this.m_value;
    }

    public void setOptionValue(String value) throws BadMarkupException {
        if (this.getOptionName() != VDBEnums.OPTION_NAME.OBT_NAME_ARG && this.getOptionName() != VDBEnums.OPTION_NAME.DST_BUFFER && this.getOptionName() != VDBEnums.OPTION_NAME.SIZE_WRITTEN && this.getOptionName() != VDBEnums.OPTION_NAME.OBT_NAME_STRING && !this.validateString(value)) {
            throw new BadMarkupException("Cannot set null value to a string or number option", new Object[0]);
        }
        if (this.getOptionName() == null || this.getOptionName() != VDBEnums.OPTION_NAME.OBT_NAME_ARG) {
            // empty if block
        }
        this.m_value = value;
    }

    public VDBEnums.OPTION_OPERATOR getOptionOperator() {
        return this.m_operator;
    }

    public void setOptionOperator(VDBEnums.OPTION_OPERATOR op) throws BadMarkupException {
        if (this.getOptionName() != null) {
            this.checkOptionNameAndOperator(this.getOptionName(), op);
        }
        this.m_operator = op;
    }

    public VDBEnums.OPTION_CONFIDENCE getMinCon() {
        return this.m_min;
    }

    public void setMinCon(VDBEnums.OPTION_CONFIDENCE min) {
        this.m_min = min;
    }

    public VDBEnums.OPTION_CONFIDENCE getMaxCon() {
        return this.m_max;
    }

    public void setMaxCon(VDBEnums.OPTION_CONFIDENCE max) {
        this.m_max = max;
    }

    public boolean canCoexist(Option o) {
        return this.testCoexit(this, o) && this.testCoexit(o, this);
    }

    private boolean testCoexit(Option a, Option b) {
        if (a.getOptionOperator() == VDBEnums.OPTION_OPERATOR.REGEX_MATCH && b.getOptionOperator() == VDBEnums.OPTION_OPERATOR.REGEX_NOT_MATCH) {
            return false;
        }
        if (a.getOptionOperator() == VDBEnums.OPTION_OPERATOR.EQUAL && b.getOptionOperator() == VDBEnums.OPTION_OPERATOR.NOT_EQUAL) {
            return false;
        }
        if (a.getOptionOperator() == VDBEnums.OPTION_OPERATOR.COMPILE_TIME_CONSTANT && b.getOptionOperator() == VDBEnums.OPTION_OPERATOR.NOT_COMPILE_TIME_CONSTANT) {
            return false;
        }
        return (a.getOptionOperator() != VDBEnums.OPTION_OPERATOR.GREATER_THAN && a.getOptionOperator() != VDBEnums.OPTION_OPERATOR.GREATER_THAN_EQUAL || b.getOptionOperator() != VDBEnums.OPTION_OPERATOR.LESS_THAN) && a.getOptionOperator() != VDBEnums.OPTION_OPERATOR.LESS_THAN_EQUAL;
    }

    @Override
    public boolean isValid() throws BadMarkupException {
        if (this.getOptionName() == VDBEnums.OPTION_NAME.OBT_NAME_NUMERIC && !VdbProvider.isNumeric(this.getOptionValue()) && !this.validateString(this.getParameter().toString())) {
            throw new BadMarkupException("Option is invalid. Name is numeric and value {0} is not a single integer, or parameter {1} is invalid", this.getOptionValue(), this.getParameter());
        }
        if (this.getOptionName() == VDBEnums.OPTION_NAME.OBT_NAME_STRING && !this.validateString(this.getOptionValue()) && !this.validateString(this.getParameter().toString())) {
            throw new BadMarkupException("Option is invalid. Name is string and value {0} is invalid, or parameter {0} is invalid", this.getOptionValue(), this.getParameter());
        }
        if (this.getOptionName() == VDBEnums.OPTION_NAME.OBT_NAME_ARG && this.m_parameter == null) {
            throw new BadMarkupException("Option is invalid. Name is argument and parameter is not specified", new Object[0]);
        }
        if (this.getOptionName() == null) {
            throw new BadMarkupException("Option is invalid. Name name must be specified", new Object[0]);
        }
        if (this.getOptionOperator() == null) {
            throw new BadMarkupException("Option is invalid. Operator must be specified", new Object[0]);
        }
        this.checkOptionNameAndOperator(this.getOptionName(), this.getOptionOperator());
        return true;
    }

    public boolean equals(Object obj) {
        Option o = (Option)obj;
        return this.compareTo(o) == 0;
    }

    @Override
    public int compareTo(Option o) {
        if (this.getParameter() != null && o.getParameter() == null) {
            return 1;
        }
        if (this.getParameter() == null && o.getParameter() != null) {
            return -1;
        }
        if (this.getParameter() != null && o.getParameter() != null && this.getParameter().compareTo(o.getParameter()) != 0) {
            return this.getParameter().compareTo(o.getParameter());
        }
        if (this.getOptionOperator() != null && o.getOptionOperator() == null) {
            return 1;
        }
        if (this.getOptionOperator() == null && o.getOptionOperator() != null) {
            return -1;
        }
        if (this.getOptionOperator() != null && o.getOptionOperator() != null && this.getOptionOperator().toString().compareToIgnoreCase(o.getOptionOperator().toString()) != 0) {
            return this.getOptionOperator().toString().compareToIgnoreCase(o.getOptionOperator().toString());
        }
        if (this.getOptionName() != null && o.getOptionName() == null) {
            return 1;
        }
        if (this.getOptionName() == null && o.getOptionName() != null) {
            return -1;
        }
        if (this.getOptionName() != null && o.getOptionName() != null && this.getOptionName().toString().compareToIgnoreCase(o.getOptionName().toString()) != 0) {
            return this.getOptionName().toString().compareToIgnoreCase(o.getOptionName().toString());
        }
        if (this.getOptionValue() != null && o.getOptionValue() == null) {
            return 1;
        }
        if (this.getOptionValue() == null && o.getOptionValue() != null) {
            return -1;
        }
        if (this.getOptionValue() != null && o.getOptionValue() != null && this.getOptionValue().toString().compareToIgnoreCase(o.getOptionValue().toString()) != 0) {
            return this.getOptionValue().toString().compareToIgnoreCase(o.getOptionValue().toString());
        }
        if (this.getMaxCon() != null && o.getMaxCon() == null) {
            return 1;
        }
        if (this.getMaxCon() == null && o.getMaxCon() != null) {
            return -1;
        }
        if (this.getMaxCon() != null && o.getMaxCon() != null && this.getMaxCon().toString().compareToIgnoreCase(o.getMaxCon().toString()) != 0) {
            return this.getMaxCon().toString().compareToIgnoreCase(o.getMaxCon().toString());
        }
        if (this.getMinCon() != null && o.getMinCon() == null) {
            return 1;
        }
        if (this.getMinCon() == null && o.getMinCon() != null) {
            return -1;
        }
        if (this.getMinCon() != null && o.getMinCon() != null && this.getMinCon().toString().compareToIgnoreCase(o.getMinCon().toString()) != 0) {
            return this.getMinCon().toString().compareToIgnoreCase(o.getMinCon().toString());
        }
        return 0;
    }

    @Override
    public void reset() {
        this.m_option_name = null;
        this.m_parameter = null;
        this.m_value = null;
        this.m_operator = null;
        this.m_min = null;
        this.m_max = null;
    }

    @Override
    public void replace(VdbArtifact artifact) throws BadMarkupException {
        if (artifact instanceof Option) {
            Option o = (Option)artifact;
            this.reset();
            this.setParameter(o.getParameter().toString());
            this.setOptionName(o.getOptionName());
            this.setOptionValue(o.getOptionValue());
            this.setOptionOperator(o.getOptionOperator());
            this.setMinCon(o.getMinCon());
            this.setMaxCon(o.getMaxCon());
        }
    }

    private void checkOptionNameAndOperator(VDBEnums.OPTION_NAME name, VDBEnums.OPTION_OPERATOR op) throws BadMarkupException {
        if (name == VDBEnums.OPTION_NAME.OBT_NAME_STRING && (op == VDBEnums.OPTION_OPERATOR.GREATER_THAN || op == VDBEnums.OPTION_OPERATOR.GREATER_THAN_EQUAL || op == VDBEnums.OPTION_OPERATOR.LESS_THAN || op == VDBEnums.OPTION_OPERATOR.LESS_THAN_EQUAL || op == VDBEnums.OPTION_OPERATOR.COMPILE_TIME_CONSTANT || op == VDBEnums.OPTION_OPERATOR.NOT_COMPILE_TIME_CONSTANT || op == VDBEnums.OPTION_OPERATOR.TAINTED)) {
            throw new BadMarkupException("Option name is String and operator {0} is invalid", op.toString());
        }
        if (name == VDBEnums.OPTION_NAME.OBT_NAME_NUMERIC && (op == VDBEnums.OPTION_OPERATOR.COMPILE_TIME_CONSTANT || op == VDBEnums.OPTION_OPERATOR.NOT_COMPILE_TIME_CONSTANT || op == VDBEnums.OPTION_OPERATOR.REGEX_MATCH || op == VDBEnums.OPTION_OPERATOR.REGEX_NOT_MATCH || op == VDBEnums.OPTION_OPERATOR.TAINTED)) {
            throw new BadMarkupException("Option name is numeric and operator {0} is invalid", op.toString());
        }
        if (name == VDBEnums.OPTION_NAME.OBT_NAME_ARG && op != VDBEnums.OPTION_OPERATOR.COMPILE_TIME_CONSTANT && op != VDBEnums.OPTION_OPERATOR.NOT_COMPILE_TIME_CONSTANT && op != VDBEnums.OPTION_OPERATOR.TAINTED) {
            throw new BadMarkupException("Option name is argument and operator {0} is invalid", op.toString());
        }
    }

    @Override
    public boolean merge(VdbArtifact artifact) throws BadMarkupException {
        if (artifact instanceof Option) {
            Option o = (Option)artifact;
            if (this.getOptionName() == o.getOptionName() && this.getOptionOperator() == o.getOptionOperator() && this.getMaxCon() == o.getMaxCon() && this.getMinCon() == o.getMinCon()) {
                if (this.getOptionValue() != null && o.getOptionValue() == null) {
                    return false;
                }
                if (o.getOptionValue() != null && this.getOptionValue() == null) {
                    return false;
                }
                if (this.getOptionValue().equals(o.getOptionValue()) && this.getParameter().canBeMerged(o.getParameter())) {
                    this.getParameter().merge(o.getParameter());
                    return true;
                }
            }
        }
        return false;
    }

    public void setMinCon(String minConfidence) {
        this.setMinCon(EnumProvider.getOptionCon(minConfidence));
    }

    public void setMaxCon(String maxConfidence) {
        this.setMaxCon(EnumProvider.getOptionCon(maxConfidence));
    }

    public void setOptionName(String name) throws BadMarkupException {
        this.setOptionName(EnumProvider.getOptionName(name));
    }

    public void setOptionOperator(String operator) throws BadMarkupException {
        this.setOptionOperator(EnumProvider.getOptionOperator(operator));
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(System.getProperty("line.separator"));
        str.append("\t\tName:" + (Object)((Object)this.getOptionName()));
        str.append(",Value:" + this.getOptionValue());
        str.append(",Operator:" + (Object)((Object)this.getOptionOperator()));
        str.append(",Parameter:" + (this.getParameter() == null ? "" : this.getParameter().toString()));
        str.append(",Max Con:" + (this.getMaxCon() == VDBEnums.OPTION_CONFIDENCE.NULL ? "" : this.getMaxCon()));
        str.append(",Min Con:" + (this.getMinCon() == VDBEnums.OPTION_CONFIDENCE.NULL ? "" : this.getMinCon()));
        return str.toString();
    }
}

