/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.vdb.method.markup.valid;

import com.ibm.appscan.assessment.model.Finding;
import com.ibm.appscan.vdb.VdbArtifact;
import com.ibm.appscan.vdb.exception.BadMarkupException;
import com.ibm.appscan.vdb.exception.VDBGeneralException;
import com.ibm.appscan.vdb.method.GlobalMethodCache;
import com.ibm.appscan.vdb.method.markup.MarkupBase;
import com.ibm.appscan.vdb.method.markup.Property;
import com.ibm.appscan.vdb.method.markup.valid.DescriptorPropertyBase;
import com.ibm.appscan.vdb.method.markup.valid.DescriptorSignatureBase;
import com.ibm.appscan.vdb.method.markup.valid.DescriptorSink;
import com.ibm.appscan.vdb.method.markup.valid.DescriptorSinkProperty;
import com.ibm.appscan.vdb.method.markup.valid.DescriptorSource;
import com.ibm.appscan.vdb.method.markup.valid.DescriptorSourceProperty;
import com.ibm.appscan.vdb.provider.VdbProvider;
import java.util.ArrayList;
import java.util.Collections;

public class Descriptor
extends MarkupBase
implements Comparable<Descriptor> {
    private ArrayList<DescriptorSinkProperty> m_sinkProps;
    private ArrayList<DescriptorSourceProperty> m_sourceProps;
    private ArrayList<DescriptorSource> m_sources;
    private ArrayList<DescriptorSink> m_sinks;
    private String m_name;

    public Descriptor() {
        this.setDescriptorName("UserType");
    }

    public Descriptor(String name) {
        this.setDescriptorName(name);
    }

    public String getDescriptorName() {
        return this.m_name;
    }

    public void setDescriptorName(String name) {
        this.m_name = name == null || name.length() == 0 ? "UserType" : name;
    }

    public ArrayList<DescriptorSinkProperty> getSinkProperties() {
        if (this.m_sinkProps == null) {
            this.m_sinkProps = new ArrayList();
        }
        return this.m_sinkProps;
    }

    public DescriptorSinkProperty getSinkProperty(String property) throws BadMarkupException {
        for (DescriptorSinkProperty s : this.getSinkProperties()) {
            try {
                if (s.getPropertyId() != VdbProvider.getPropertyProvider().getPropertyId(property)) continue;
                return s;
            }
            catch (VDBGeneralException e) {
                throw new BadMarkupException(e);
            }
        }
        return null;
    }

    public boolean addSinkProperty(String property) throws BadMarkupException {
        DescriptorSinkProperty prop = new DescriptorSinkProperty(property);
        if (this.getSinkProperties().contains(prop)) {
            return false;
        }
        this.getSinkProperties().add(prop);
        Collections.sort(this.getSinkProperties());
        return true;
    }

    public boolean deleteSinkProperty(String property) throws BadMarkupException {
        DescriptorSinkProperty s = this.getSinkProperty(property);
        if (this.getSinkProperties().contains(s)) {
            this.getSinkProperties().remove(s);
            return true;
        }
        return false;
    }

    public boolean deleteAllSinkProperties() {
        if (this.getSinkProperties().size() > 0) {
            this.getSinkProperties().clear();
            return true;
        }
        return false;
    }

    public ArrayList<DescriptorSourceProperty> getSourceProperties() {
        if (this.m_sourceProps == null) {
            this.m_sourceProps = new ArrayList();
        }
        return this.m_sourceProps;
    }

    public DescriptorSourceProperty getSourceProperty(String property) throws BadMarkupException {
        for (DescriptorSourceProperty s : this.getSourceProperties()) {
            try {
                if (s.getPropertyId() != VdbProvider.getPropertyProvider().getPropertyId(property)) continue;
                return s;
            }
            catch (VDBGeneralException e) {
                throw new BadMarkupException(e);
            }
        }
        return null;
    }

    public boolean addSourceProperty(String property) throws BadMarkupException {
        DescriptorSourceProperty sp = new DescriptorSourceProperty(property);
        if (this.getSourceProperties().contains(sp)) {
            return false;
        }
        this.getSourceProperties().add(sp);
        Collections.sort(this.getSourceProperties());
        return true;
    }

    public boolean deleteSourceProperty(String property) throws BadMarkupException {
        DescriptorSourceProperty s = this.getSourceProperty(property);
        if (this.getSourceProperties().contains(s)) {
            this.getSourceProperties().remove(s);
            return true;
        }
        return false;
    }

    public boolean deleteAllSourceProperties() {
        if (this.getSourceProperties().size() > 0) {
            this.getSourceProperties().clear();
            return true;
        }
        return false;
    }

    public ArrayList<DescriptorSource> getSources() {
        if (this.m_sources == null) {
            this.m_sources = new ArrayList();
        }
        return this.m_sources;
    }

    public DescriptorSource getSource(String sig) throws VDBGeneralException, BadMarkupException {
        for (DescriptorSource s : this.getSources()) {
            if (!s.getSignature().equals(sig)) continue;
            return s;
        }
        return null;
    }

    public boolean addSource(String sig) throws BadMarkupException {
        DescriptorSource source = new DescriptorSource(sig);
        if (this.getSources().contains(source)) {
            return false;
        }
        this.getSources().add(source);
        Collections.sort(this.getSources());
        return true;
    }

    public boolean deleteSource(String sig) throws BadMarkupException {
        DescriptorSource s = new DescriptorSource(sig);
        if (this.getSources().contains(s)) {
            this.getSources().remove(s);
            return true;
        }
        return false;
    }

    public boolean deleteAllSources() {
        if (this.getSources().size() > 0) {
            this.getSources().clear();
            return true;
        }
        return false;
    }

    public ArrayList<DescriptorSink> getSinks() {
        if (this.m_sinks == null) {
            this.m_sinks = new ArrayList();
        }
        return this.m_sinks;
    }

    public boolean addSink(String sig) throws BadMarkupException {
        DescriptorSink sink = new DescriptorSink(sig);
        if (this.getSinks().contains(sink)) {
            return false;
        }
        this.getSinks().add(sink);
        Collections.sort(this.getSinks());
        return true;
    }

    public DescriptorSink getSink(String sig) {
        for (DescriptorSink s : this.getSinks()) {
            if (!s.getSignature().equals(sig)) continue;
            return s;
        }
        return null;
    }

    public boolean deleteSink(String sig) throws BadMarkupException {
        DescriptorSink sink = new DescriptorSink(sig);
        if (this.getSinks().contains(sink)) {
            this.getSinks().remove(sink);
            return true;
        }
        return false;
    }

    public boolean deleteAllSinks() {
        if (this.getSinks().size() > 0) {
            this.getSinks().clear();
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Descriptor o) {
        if (this.getDescriptorName().compareToIgnoreCase(o.getDescriptorName()) == 0) {
            if (this.getSources().size() > o.getSources().size()) {
                return 1;
            }
            if (this.getSources().size() < o.getSources().size()) {
                return -1;
            }
            if (this.getSinks().size() > o.getSinks().size()) {
                return 1;
            }
            if (this.getSinks().size() < o.getSinks().size()) {
                return -1;
            }
            if (this.getSourceProperties().size() > o.getSourceProperties().size()) {
                return 1;
            }
            if (this.getSourceProperties().size() < o.getSourceProperties().size()) {
                return -1;
            }
            if (this.getSinkProperties().size() > o.getSinkProperties().size()) {
                return 1;
            }
            if (this.getSinkProperties().size() < o.getSinkProperties().size()) {
                return -1;
            }
            try {
                if (this.compareChildren(o) != 0) {
                    return this.compareChildren(o);
                }
            }
            catch (BadMarkupException e) {
                return 0;
            }
        }
        try {
            if (this.compareChildren(o) != 0) {
                return this.compareChildren(o);
            }
        }
        catch (BadMarkupException e) {
            return 0;
        }
        return this.getDescriptorName().compareToIgnoreCase(o.getDescriptorName());
    }

    private int compareChildren(Descriptor d) throws BadMarkupException {
        int i;
        for (i = 0; i < this.getSources().size(); ++i) {
            if (this.getSources().get(i).getSignature().compareTo(this.getSources().get(i).getSignature()) == 0) continue;
            return this.getSources().get(i).getSignature().compareTo(this.getSources().get(i).getSignature());
        }
        for (i = 0; i < this.getSinks().size(); ++i) {
            if (this.getSinks().get(i).getSignature().compareTo(this.getSinks().get(i).getSignature()) == 0) continue;
            return this.getSinks().get(i).getSignature().compareTo(this.getSinks().get(i).getSignature());
        }
        for (i = 0; i < this.getSourceProperties().size(); ++i) {
            if (this.getSourceProperties().get(i).getProperty().compareTo(this.getSourceProperties().get(i).getProperty()) == 0) continue;
            return this.getSourceProperties().get(i).getProperty().compareTo(this.getSourceProperties().get(i).getProperty());
        }
        for (i = 0; i < this.getSinkProperties().size(); ++i) {
            if (this.getSinkProperties().get(i).getProperty().compareTo(this.getSinkProperties().get(i).getProperty()) == 0) continue;
            return this.getSinkProperties().get(i).getProperty().compareTo(this.getSinkProperties().get(i).getProperty());
        }
        return 0;
    }

    public boolean equals(Object obj) {
        Descriptor d = (Descriptor)obj;
        return this.compareTo(d) == 0;
    }

    @Override
    public boolean isValid() {
        return this.getSinkProperties().size() != 0 || this.getSourceProperties().size() != 0 || this.getSinks().size() != 0 || this.getSources().size() != 0;
    }

    @Override
    public void reset() {
        this.m_name = null;
        this.m_sinks = null;
        this.m_sources = null;
        this.m_sinkProps = null;
        this.m_sourceProps = null;
    }

    @Override
    public void replace(VdbArtifact artifact) throws BadMarkupException {
        if (artifact instanceof Descriptor) {
            this.reset();
            Descriptor d = (Descriptor)artifact;
            this.setDescriptorName(d.getDescriptorName());
            this.merge(d);
        }
    }

    @Override
    public boolean merge(VdbArtifact artifact) throws BadMarkupException {
        boolean _ret = false;
        if (artifact instanceof Descriptor) {
            Descriptor d = (Descriptor)artifact;
            for (DescriptorSource descriptorSource : d.getSources()) {
                if (!this.addSource(descriptorSource.getSignature())) continue;
                _ret = true;
            }
            for (DescriptorSink descriptorSink : d.getSinks()) {
                if (!this.addSink(descriptorSink.getSignature())) continue;
                _ret = true;
            }
            for (DescriptorSourceProperty descriptorSourceProperty : d.getSourceProperties()) {
                if (!this.addSourceProperty(descriptorSourceProperty.getProperty())) continue;
                _ret = true;
            }
            for (DescriptorSinkProperty descriptorSinkProperty : d.getSinkProperties()) {
                if (!this.addSinkProperty(descriptorSinkProperty.getProperty())) continue;
                _ret = true;
            }
        }
        return _ret;
    }

    public boolean validatesFinding(Finding finding) throws VDBGeneralException, BadMarkupException {
        boolean source_match = false;
        boolean sink_match = false;
        boolean source_prop_match = false;
        boolean sink_prop_match = false;
        if (this.getSources().size() > 0) {
            if (this.getSource(GlobalMethodCache.getMethod(finding.getTrace().getRealSource().getSite().getSignature(), this.getLang()).getSignature()) != null) {
                source_match = true;
            }
        } else {
            source_match = true;
        }
        if (this.getSinks().size() > 0) {
            if (this.getSink(GlobalMethodCache.getMethod(finding.getTrace().getSink().getSite().getSignature(), this.getLang()).getSignature()) != null) {
                sink_match = true;
            }
        } else {
            sink_match = true;
        }
        if (this.getSinkProperties().size() > 0) {
            for (Property p : GlobalMethodCache.getMethod(finding.getTrace().getSink().getSite().getSignature(), this.getLang()).getAllProperties()) {
                if (this.getSinkProperty(p.getProperty()) == null) continue;
                sink_prop_match = true;
                break;
            }
            if (this.getSinkProperty(finding.getData().getVuln_type()) != null) {
                sink_prop_match = true;
            }
        } else {
            sink_prop_match = true;
        }
        if (this.getSourceProperties().size() > 0) {
            for (Property p : GlobalMethodCache.getMethod(finding.getTrace().getRealSource().getSite().getSignature(), this.getLang()).getAllProperties()) {
                if (this.getSourceProperty(p.getProperty()) == null) continue;
                source_prop_match = true;
                break;
            }
        } else {
            source_prop_match = true;
        }
        return source_match && sink_match && source_prop_match && sink_prop_match;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("Descriptor:");
        ret.append(this.getDescriptorName());
        ret.append(System.lineSeparator());
        if (this.getSourceProperties().size() > 0) {
            ret.append("Source Properties:");
            ret.append(System.lineSeparator());
            Collections.sort(this.getSourceProperties());
            for (DescriptorPropertyBase descriptorPropertyBase : this.getSourceProperties()) {
                ret.append("\t");
                ret.append(descriptorPropertyBase.toString());
                ret.append(System.lineSeparator());
            }
        }
        if (this.getSources().size() > 0) {
            ret.append("Sources:");
            ret.append(System.lineSeparator());
            Collections.sort(this.getSources());
            for (DescriptorSignatureBase descriptorSignatureBase : this.getSources()) {
                ret.append("\t");
                ret.append(descriptorSignatureBase.toString());
                ret.append(System.lineSeparator());
            }
        }
        if (this.getSinkProperties().size() > 0) {
            ret.append("Sink Properties:");
            ret.append(System.lineSeparator());
            Collections.sort(this.getSinkProperties());
            for (DescriptorPropertyBase descriptorPropertyBase : this.getSinkProperties()) {
                ret.append("\t");
                ret.append(descriptorPropertyBase.toString());
                ret.append(System.lineSeparator());
            }
        }
        if (this.getSinks().size() > 0) {
            ret.append("Sinks:");
            ret.append(System.lineSeparator());
            Collections.sort(this.getSinks());
            for (DescriptorSignatureBase descriptorSignatureBase : this.getSinks()) {
                ret.append("\t");
                ret.append(descriptorSignatureBase.toString());
                ret.append(System.lineSeparator());
            }
        }
        return ret.toString();
    }
}

